/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure;

import com.ur.swing.ToggleDelegate;
import com.ur.swing.Toggleable;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.event.MouseInputAdapter;

public abstract class Toggle
extends MouseInputAdapter
implements Toggleable {
    private JComponent parent;
    private Toggleable.RefreshCallback refreshCallback;
    private JComponent panel;
    private JComponent replacement;
    private ToggleDelegate toggleDelegate;

    Toggle(JComponent panel, JComponent replacement, String constraint) {
        this.panel = panel;
        this.replacement = replacement;
        this.toggleDelegate = new ToggleDelegate((Toggleable)this, constraint);
    }

    public abstract void paintToggleIcon(Component var1, Graphics var2);

    void putOnPanel(JComponent component) {
        this.panel.add(component);
        this.panel.validate();
    }

    public JComponent getParentPanel() {
        return this.parent;
    }

    void setParentPanel(JComponent parent) {
        this.parent = parent;
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public JComponent getReplacement() {
        return this.replacement;
    }

    public Toggleable.RefreshCallback getRefreshCallback() {
        return this.refreshCallback;
    }

    void setRefreshCallback(Toggleable.RefreshCallback refreshCallback) {
        this.refreshCallback = refreshCallback;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.isIconHit(mouseEvent)) {
            this.toggle();
            mouseEvent.consume();
        } else {
            this.toggleDelegate.mouseClicked(mouseEvent);
        }
    }

    public abstract boolean isIconHit(MouseEvent var1);

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.isIconHit(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isIconHit(mouseEvent)) {
            mouseEvent.consume();
        }
    }

    public void toggle() {
        this.toggleDelegate.toggle();
    }

    public int getWidth() {
        if (this.isShown()) {
            return this.panel.getPreferredSize().width;
        }
        return this.replacement.getPreferredSize().width;
    }

    protected void paintIcon(Component c, Graphics g, Icon icon, int x, int y) {
        icon.paintIcon(c, g, x, y);
    }

    public boolean isShown() {
        return this.toggleDelegate.isShown();
    }
}

