/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure.rendering.base;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.swing.URFontFactory;
import gui.polyscope.DashBoard;
import gui.polyscope.program.ProgramNodeInsertState;
import java.awt.Font;
import javax.inject.Inject;

public class IdentifyFont {
    protected final Font topLevelNodeFont;
    protected final Font undefinedNodeFont;
    protected final Font definedLevelNodeFont;
    protected final Font undefinedLevelNodeFont;
    private ProgramNodeInsertState programNodeInsertState;

    @Inject
    public IdentifyFont(URFontFactory fontFactory, ProgramNodeInsertState programNodeInsertState) {
        this.topLevelNodeFont = fontFactory.getDefaultFont().deriveFont(1);
        this.undefinedNodeFont = fontFactory.getDefaultFont().deriveFont(3);
        this.definedLevelNodeFont = fontFactory.getDefaultFont();
        this.undefinedLevelNodeFont = fontFactory.getDefaultFont().deriveFont(2);
        this.programNodeInsertState = programNodeInsertState;
    }

    public Font selectFontFor(AbstractProgramNode programNode, boolean isNodeDefined) {
        boolean isUndefined;
        boolean bl = isUndefined = this.programNodeInsertState.isUndefinedVetoed() || this.isUndefined(isNodeDefined);
        if (programNode.isOfSort(AbstractProgramNode.ProgramNodeSort.TOP_LEVEL)) {
            return isUndefined ? this.undefinedNodeFont : this.topLevelNodeFont;
        }
        return isUndefined ? this.undefinedLevelNodeFont : this.definedLevelNodeFont;
    }

    private boolean isUndefined(boolean isNodeDefined) {
        return !DashBoard.getUserProgramState().isActive() && !isNodeDefined;
    }
}

