/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure.rendering.base;

import com.ur.polyscope.program.commandview.ProgramTreeNodeRenderer;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.resources.ViewImageResource;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.Icon;

public class IdentifyIconAndText {
    private static final ProgramTreeNodeRenderer DEFAULT_RENDERER = new DefaultProgramNodeRenderer();
    private final TwoStateIcon leafIcon;
    private final TwoStateIcon branchIcon;
    private final Set<ProgramTreeNodeRenderer> rendererSet;

    @Inject
    IdentifyIconAndText(Set<ProgramTreeNodeRenderer> rendererSet) {
        this.rendererSet = rendererSet;
        this.leafIcon = new TwoStateIcon(ViewImageResource.programSet(), ViewImageResource.programSetUndefined());
        this.branchIcon = new TwoStateIcon(ViewImageResource.programRobot(), ViewImageResource.programRobotUndefined());
    }

    public Icon getIcon(AbstractProgramNode programNode, boolean isLeaf, boolean isNodeDefined) {
        ProgramTreeNodeRenderer renderer = this.getRenderer(programNode);
        Icon icon = renderer.getIcon(programNode, isNodeDefined);
        if (icon == null) {
            TwoStateIcon twoStateIcon = isLeaf || !programNode.isTreeExpandable() ? this.leafIcon : this.branchIcon;
            return isNodeDefined ? twoStateIcon.defined() : twoStateIcon.undefined();
        }
        return icon;
    }

    public String getText(AbstractProgramNode programNode, boolean isNodeDefined) {
        ProgramTreeNodeRenderer renderer = this.getRenderer(programNode);
        return renderer.getText(programNode, isNodeDefined);
    }

    ProgramTreeNodeRenderer getRenderer(AbstractProgramNode programNode) {
        Object userObject = programNode.getUserObject();
        if (userObject == null) {
            ProgramTreeNodeRenderer renderer = this.findRenderer(programNode);
            programNode.setUserObject((Object)renderer);
            return renderer;
        }
        if (userObject instanceof ProgramTreeNodeRenderer) {
            return (ProgramTreeNodeRenderer)userObject;
        }
        return this.findRenderer(programNode);
    }

    private ProgramTreeNodeRenderer findRenderer(AbstractProgramNode programNode) {
        for (ProgramTreeNodeRenderer each : this.rendererSet) {
            if (!each.isSupported(programNode)) continue;
            return each;
        }
        return DEFAULT_RENDERER;
    }

    private static class DefaultProgramNodeRenderer
    implements ProgramTreeNodeRenderer {
        private DefaultProgramNodeRenderer() {
        }

        public boolean isSupported(AbstractProgramNode abstractProgramNode) {
            return true;
        }

        public Icon getIcon(AbstractProgramNode abstractProgramNode, boolean isNodeDefined) {
            return null;
        }

        public String getText(AbstractProgramNode abstractProgramNode, boolean isNodeDefined) {
            return abstractProgramNode.toString();
        }
    }

    public static class TwoStateIcon {
        private final Icon defined;
        private final Icon undefined;

        public TwoStateIcon(Icon defined, Icon undefined) {
            this.defined = defined;
            this.undefined = undefined;
        }

        public Icon defined() {
            return this.defined;
        }

        public Icon undefined() {
            return this.undefined;
        }
    }
}

