/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.edit.infrastructure.rendering.base;

import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.polyscope.program.ProgramLoadingContext;
import com.ur.polyscope.program.ProgramStateHolder;
import com.ur.polyscope.program.monitor.ProgramState;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.edit.infrastructure.rendering.base.IdentifyColor;
import com.ur.program.edit.infrastructure.rendering.base.IdentifyFont;
import com.ur.program.edit.infrastructure.rendering.base.IdentifyIconAndText;
import java.awt.Color;
import java.awt.Component;
import java.beans.PropertyChangeListener;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.BorderFactory;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.DefaultTreeCellRenderer;

public class ProgramTreeCellRenderer
extends DefaultTreeCellRenderer {
    private final Provider<ProgramLoadingContext> programLoadingContext;
    private final Border defaultBorder;
    private final CompoundBorder errorBorder;
    private final Provider<IdentifyFont> identifyFont;
    private final Provider<InstallationLoadingContext> installationLoadingContext;
    private final IdentifyIconAndText identifyIconAndContext;
    private final IdentifyColor identifyColor;
    private final Provider<ProgramStateHolder> programState;

    @Inject
    public ProgramTreeCellRenderer(IdentifyIconAndText identifyIconAndText, Provider<IdentifyFont> identifyFont, Provider<ProgramLoadingContext> programLoadingContext, Provider<InstallationLoadingContext> installationLoadingContext, Provider<ProgramStateHolder> programState) {
        this.identifyIconAndContext = identifyIconAndText;
        this.identifyFont = identifyFont;
        this.installationLoadingContext = installationLoadingContext;
        this.programState = programState;
        this.identifyColor = new IdentifyColor(this);
        this.programLoadingContext = programLoadingContext;
        this.defaultBorder = this.getBorder();
        this.errorBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.RED), this.defaultBorder);
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        AbstractProgramNode programNode = (AbstractProgramNode)value;
        this.hasFocus = hasFocus;
        this.selected = sel;
        ProgramStateHolder programStateHolder = (ProgramStateHolder)this.programState.get();
        boolean isNodeDefined = programStateHolder.getProgramState() == ProgramState.PLAYING || programStateHolder.getProgramState() == ProgramState.PAUSED || ((ProgramLoadingContext)this.programLoadingContext.get()).isLoading() || ((InstallationLoadingContext)this.installationLoadingContext.get()).isLoading() || programNode.isDefined();
        this.setFont(((IdentifyFont)this.identifyFont.get()).selectFontFor(programNode, isNodeDefined));
        this.setForeground(this.identifyColor.getForegroundColor(sel, programNode));
        this.setComponentOrientation(tree.getComponentOrientation());
        this.setEnabled(this.identifyColor.isEnabled(programNode));
        this.setBorder(programNode.hasScriptError() ? this.errorBorder : this.defaultBorder);
        this.setIcon(this.identifyIconAndContext.getIcon(programNode, leaf, isNodeDefined));
        this.setText(this.identifyIconAndContext.getText(programNode, isNodeDefined));
        this.accessibleContext = null;
        return this;
    }
}

