/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.force.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.PrimitiveUtils;
import com.ur.monitor.model.Vector3;
import com.ur.polyscope.viewfacade.lang.URMath;
import com.ur.program.internal.TextResource;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.i18n.UnitsResource;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.swing.HTML;
import com.ur.view.polyscope.program.ForceType;
import gui.program.ForceNode;
import gui.program.validation.ForceNodeValidationStrategyProvider;
import java.awt.Color;
import java.text.DecimalFormat;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class ForceCardAdvancedPanel
extends CardPanel {
    private static final int DIMENSIONS = Vector3.Axis.values().length;
    private final JCheckBox[] checkBoxes = new JCheckBox[2 * DIMENSIONS];
    protected final NumberField[] limitsTextFields = new NumberField[2 * DIMENSIONS];
    private final NumberField[] forceValueTextFields = new NumberField[2 * DIMENSIONS];
    private ForceNode node;
    private final ViewContext viewContext;
    private final ForceNodeValidationStrategyProvider validationStrategyProvider;
    private boolean updating = false;
    private JLabel forceLabel;
    private JLabel limitsLabel;

    public ForceCardAdvancedPanel(ViewContext viewContext, ForceNodeValidationStrategyProvider validationStrategyProvider) {
        this.viewContext = viewContext;
        this.validationStrategyProvider = validationStrategyProvider;
        this.initComponents();
        this.assignHelp((HelpIdAssigner)viewContext.getHelpIdAssigner());
    }

    private void assignHelp(HelpIdAssigner helpIdAssigner) {
        helpIdAssigner.assignHelpId((JComponent)this.forceLabel, "gui:force_value_selection");
        helpIdAssigner.assignHelpId((JComponent)this.limitsLabel, "gui:force_mode_limits");
    }

    private void useValue(int index, String value) {
        block12: {
            if (value.isEmpty()) {
                return;
            }
            if (index >= 0 && index <= 5) {
                try {
                    if (index <= 2) {
                        this.node.setWrench(index, Units.convert_to_N((String)value));
                        break block12;
                    }
                    this.node.setWrench(index, Units.convert_to_Nm((String)value));
                }
                catch (NumberFormatException numberFormatException) {}
            } else if (index >= 6 && index <= 11) {
                try {
                    boolean forceControlledParameter;
                    double newVal = PrimitiveUtils.parseDouble((String)value);
                    if (newVal < 0.0) {
                        newVal = 0.0;
                    }
                    newVal = index <= 8 ? Units.convert_to_m((double)newVal) : (newVal *= Math.PI / 180);
                    boolean bl = forceControlledParameter = this.node.getSelection(index - 6) == 1;
                    if (forceControlledParameter) {
                        this.node.setForceControlSpeedLimit(index - 6, newVal);
                    } else {
                        this.node.setMotionControlErrorLimit(index - 6, newVal);
                    }
                }
                catch (NumberFormatException numberFormatException) {}
            }
        }
    }

    public void enter(Object o) {
        this.node = (ForceNode)o;
        this.updateAllValues();
    }

    private void updateAllValues() {
        this.updating = true;
        double[] wrench = this.node.getWrenchVector();
        this.forceValueTextFields[0].setText(Units.convert_from_N((double)wrench[0]));
        this.forceValueTextFields[1].setText(Units.convert_from_N((double)wrench[1]));
        this.forceValueTextFields[2].setText(Units.convert_from_N((double)wrench[2]));
        this.forceValueTextFields[3].setText(Units.convert_from_Nm((double)wrench[3]));
        this.forceValueTextFields[4].setText(Units.convert_from_Nm((double)wrench[4]));
        this.forceValueTextFields[5].setText(Units.convert_from_Nm((double)wrench[5]));
        int[] selectionVector = this.node.getSelectionVector();
        UnitsResource text = Units.getText();
        int i = 0;
        while (i < selectionVector.length) {
            boolean forceSelected = selectionVector[i] == 1;
            this.checkBoxes[i].setSelected(forceSelected);
            this.updateEnablement(i);
            double limit = this.node.getForceControlSpeedLimits()[i];
            this.setLimitTextForFieldIndex(i, limit);
            this.limitsTextFields[i].setUnit(i < DIMENSIONS ? text.unitMmS() : text.unitDegS());
            ++i;
        }
        this.updateValidatorForAllLimitsFields();
        if (this.node.getForceType() == ForceType.MOTION) {
            this.forceValueTextFields[0].setEnabled(false);
            this.forceValueTextFields[0].setText("0.0");
            this.limitsTextFields[0].setEnabled(false);
            this.checkBoxes[0].setEnabled(false);
            this.checkBoxes[0].setSelected(false);
        } else {
            this.forceValueTextFields[0].setEnabled(true);
            this.limitsTextFields[0].setEnabled(true);
            this.checkBoxes[0].setEnabled(true);
        }
        this.updateForceValidator(this.forceValueTextFields[0]);
        this.updateForceValidator(this.forceValueTextFields[1]);
        this.updateForceValidator(this.forceValueTextFields[2]);
        i = 0;
        while (i < 2 * DIMENSIONS) {
            this.updateEnablement(i);
            ++i;
        }
        this.updating = false;
    }

    private boolean isRotationalAxis(int index) {
        return index >= DIMENSIONS;
    }

    private void updateValidatorForAllLimitsFields() {
        int i = 0;
        while (i < 2 * DIMENSIONS) {
            this.limitsTextFields[i].setErrorValidationStrategy(new ValidationStrategy[]{this.updateValidator(i, this.isRotationalAxis(i))});
            ++i;
        }
    }

    private void setLimitTextForFieldIndex(int index, double limit) {
        if (index < DIMENSIONS) {
            String limitConvertedToUserMetric = Units.convert_from_m_max3dec((double)limit);
            limitConvertedToUserMetric = limitConvertedToUserMetric.replace(",", ".");
            double roundedLimit = URMath.roundUpDouble((double)Double.valueOf(limitConvertedToUserMetric), (int)2);
            this.limitsTextFields[index].setText(String.valueOf(roundedLimit));
        } else {
            DecimalFormat df = DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.0#");
            this.limitsTextFields[index].setText(df.format(limit *= 57.29577951308232));
        }
    }

    private void updateForceValidator(NumberField textField) {
        textField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getForceValidator()});
    }

    private void initComponents() {
        int i = 0;
        while (i < DIMENSIONS * 2) {
            this.forceValueTextFields[i] = this.createValueInputField(i);
            this.forceValueTextFields[i].setText("0");
            this.forceValueTextFields[i].setMode(Mode.Standard);
            this.forceValueTextFields[i].setDisabledTextColor(Color.WHITE);
            this.limitsTextFields[i] = this.createValueInputField(i + 6);
            this.limitsTextFields[i].setText("0.0");
            this.limitsTextFields[i].setMode(Mode.PositiveNumbers);
            this.limitsTextFields[i].setDisabledTextColor(Color.WHITE);
            ++i;
        }
        AutoCorrectionValidator forceValidator = this.validationStrategyProvider.getForceValidator();
        this.forceValueTextFields[0].setErrorValidationStrategy(new ValidationStrategy[]{forceValidator});
        this.forceValueTextFields[1].setErrorValidationStrategy(new ValidationStrategy[]{forceValidator});
        this.forceValueTextFields[2].setErrorValidationStrategy(new ValidationStrategy[]{forceValidator});
        AutoCorrectionValidator torqueValidator = this.validationStrategyProvider.getTorqueValidator();
        this.forceValueTextFields[3].setErrorValidationStrategy(new ValidationStrategy[]{torqueValidator});
        this.forceValueTextFields[4].setErrorValidationStrategy(new ValidationStrategy[]{torqueValidator});
        this.forceValueTextFields[5].setErrorValidationStrategy(new ValidationStrategy[]{torqueValidator});
        AutoCorrectionValidator limitValidator = this.validationStrategyProvider.getLimitValidator();
        this.limitsTextFields[0].setErrorValidationStrategy(new ValidationStrategy[]{limitValidator});
        this.limitsTextFields[1].setErrorValidationStrategy(new ValidationStrategy[]{limitValidator});
        this.limitsTextFields[2].setErrorValidationStrategy(new ValidationStrategy[]{limitValidator});
        AutoCorrectionValidator rotationValidator = this.validationStrategyProvider.getRotationValidator();
        this.limitsTextFields[3].setErrorValidationStrategy(new ValidationStrategy[]{rotationValidator});
        this.limitsTextFields[4].setErrorValidationStrategy(new ValidationStrategy[]{rotationValidator});
        this.limitsTextFields[5].setErrorValidationStrategy(new ValidationStrategy[]{rotationValidator});
        this.checkBoxes[0] = new JCheckBox("X");
        this.checkBoxes[0].addActionListener(evt -> this.selectionCheckBoxActionPerformed(0));
        this.checkBoxes[1] = new JCheckBox("Y");
        this.checkBoxes[1].addActionListener(evt -> this.selectionCheckBoxActionPerformed(1));
        this.checkBoxes[2] = new JCheckBox("Z");
        this.checkBoxes[2].addActionListener(evt -> this.selectionCheckBoxActionPerformed(2));
        this.checkBoxes[3] = new JCheckBox("RX");
        this.checkBoxes[3].addActionListener(evt -> this.selectionCheckBoxActionPerformed(3));
        this.checkBoxes[4] = new JCheckBox("RY");
        this.checkBoxes[4].addActionListener(evt -> this.selectionCheckBoxActionPerformed(4));
        this.checkBoxes[5] = new JCheckBox("RZ");
        this.checkBoxes[5].addActionListener(evt -> this.selectionCheckBoxActionPerformed(5));
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.limitsLabel = new JLabel(HTML.html((String)resource.speedLimits()));
        this.forceLabel = new JLabel(HTML.html((String)resource.Force()));
        this.forceValueTextFields[0].setUnit(Units.getText().unitN());
        this.forceValueTextFields[1].setUnit(Units.getText().unitN());
        this.forceValueTextFields[2].setUnit(Units.getText().unitN());
        this.forceValueTextFields[3].setUnit(Units.getText().unitNm());
        this.forceValueTextFields[4].setUnit(Units.getText().unitNm());
        this.forceValueTextFields[5].setUnit(Units.getText().unitNm());
        this.limitsTextFields[0].setUnit(Units.getText().unitMm());
        this.limitsTextFields[1].setUnit(Units.getText().unitMm());
        this.limitsTextFields[2].setUnit(Units.getText().unitMm());
        this.limitsTextFields[3].setUnit(Units.getText().unitDegrees());
        this.limitsTextFields[4].setUnit(Units.getText().unitDegrees());
        this.limitsTextFields[5].setUnit(Units.getText().unitDegrees());
        JPanel panel = this.viewContext.createFormBuilder().spacer().label(this.forceLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).label(this.limitsLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.checkBoxes[0], new FormBuilder.PanelConstraints[0]).component((JComponent)this.forceValueTextFields[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsTextFields[0], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.checkBoxes[1], new FormBuilder.PanelConstraints[0]).component((JComponent)this.forceValueTextFields[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsTextFields[1], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.checkBoxes[2], new FormBuilder.PanelConstraints[0]).component((JComponent)this.forceValueTextFields[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsTextFields[2], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.checkBoxes[3], new FormBuilder.PanelConstraints[0]).component((JComponent)this.forceValueTextFields[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsTextFields[3], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.checkBoxes[4], new FormBuilder.PanelConstraints[0]).component((JComponent)this.forceValueTextFields[4], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsTextFields[4], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.checkBoxes[5], new FormBuilder.PanelConstraints[0]).component((JComponent)this.forceValueTextFields[5], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).component((JComponent)this.limitsTextFields[5], new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(2).getPanel();
        panel.setBorder(BorderFactory.createEmptyBorder());
        this.add(panel);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private void updateEnablement(int index) {
        boolean visible = this.checkBoxes[index].isSelected();
        this.limitsTextFields[index].setEnabled(visible);
        this.forceValueTextFields[index].setEnabled(visible);
    }

    public NumberField createValueInputField(int i) {
        NumberField field = new NumberField();
        field.addActionListener(e -> this.useValue(i, field.getText()));
        return field;
    }

    private void selectionCheckBoxActionPerformed(int index) {
        if (this.updating) {
            return;
        }
        this.node.setSelection(index, this.checkBoxes[index].isSelected() ? 1 : 0);
        this.updateEnablement(index);
        this.limitsTextFields[index].setErrorValidationStrategy(new ValidationStrategy[]{this.updateValidator(index, this.isRotationalAxis(index))});
    }

    private ValidationStrategy updateValidator(int textFieldIndex, boolean isRotationAxes) {
        boolean isForceControlledParameter;
        boolean bl = isForceControlledParameter = this.node.getSelectionVector()[textFieldIndex] == 1;
        if (isForceControlledParameter) {
            return isRotationAxes ? this.validationStrategyProvider.getRotationSpeedValidator() : this.validationStrategyProvider.getLimitSpeedValidator();
        }
        return isRotationAxes ? this.validationStrategyProvider.getRotationValidator() : this.validationStrategyProvider.getLimitValidator();
    }
}

