/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.force.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.lang.react.Consumer;
import com.ur.lang.react.Recipe;
import com.ur.lang.react.RecipeHelper;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.move.internal.ControllerTeachButton;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.program.force.infrastructure.ForceCardAdvancedPanel;
import com.ur.program.force.infrastructure.ForceCardSimplePanel;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.CardPanel;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumComboBoxModel;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.dialog.ConfirmationMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.DefaultComboBoxRenderer;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.help.HelpIdAssignerExt;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.hmc.ControllerSocketSender;
import com.ur.view.polyscope.program.ForceType;
import gui.commandpanels.ForceCard;
import gui.program.ForceNode;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReference;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.program.validation.ForceNodeValidationStrategyProvider;
import gui.swing.renderers.FeatureComboBoxModel;
import gui.swing.renderers.TopLevelFeatureRenderingStrategy;
import gui.tools.LegacyURDialogCreator;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;

public class ForceCardImpl
extends ForceCard {
    private boolean updating = false;
    private boolean isExecutingForceTestProgram = false;
    private JComboBox featureSelectionComboBox;
    private JComboBox forceTypeComboBox;
    private FlippablePanel valuesCardPanel;
    private JToggleButton disablePhysicalTeachButton;
    private JLabel forceIllustration;
    private RecipeHelper recipeHelper = new RecipeHelper();

    @Inject
    ForceCardImpl(ViewContext viewContext, InstallationComponentLookup installationLookup, ProgramReferenceService programReferenceService, ForceNodeValidationStrategyProvider validationStrategyProvider, FeaturesLookup featuresLookup, ControllerInterface controllerInterface, ProgramFeatureService programFeatureService, @Source(value=RobotState.class) Recipe<RobotState> robotStateRecipe) {
        super(viewContext, installationLookup, programReferenceService, validationStrategyProvider, featuresLookup, controllerInterface, programFeatureService);
        this.recipeHelper.add(RobotState.class, robotStateRecipe, (Consumer)this);
        this.initComponents();
        this.valuesCardPanel.addCardPanel((CardPanel)new ForceCardSimplePanel(viewContext, validationStrategyProvider));
        this.valuesCardPanel.addCardPanel((CardPanel)new ForceCardAdvancedPanel(viewContext, validationStrategyProvider));
        this.valuesCardPanel.setCardParent((CardPanel)this);
        this.bindComponents();
        this.assignHelpIds();
    }

    private void bindComponents() {
        this.forceTypeComboBox.setRenderer(new DefaultComboBoxRenderer(){

            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                ForceType type = (ForceType)value;
                switch (type) {
                    case FRAME: {
                        this.setText(((TextResource)ForceCardImpl.this.viewContext.getTextResource(TextResource.class)).Frame());
                        break;
                    }
                    case MOTION: {
                        this.setText(((TextResource)ForceCardImpl.this.viewContext.getTextResource(TextResource.class)).Motion());
                        break;
                    }
                    case POINT: {
                        this.setText(((CommandNamesResource)ForceCardImpl.this.viewContext.getTextResource(CommandNamesResource.class)).geomPoint());
                        break;
                    }
                    case SIMPLE: {
                        this.setText(((TextResource)ForceCardImpl.this.viewContext.getTextResource(TextResource.class)).Simple());
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown type: " + type);
                    }
                }
                return this;
            }
        });
        TopLevelFeatureRenderingStrategy renderingStrategy = new TopLevelFeatureRenderingStrategy(this.featuresLookup);
        ComboBoxRenderer.bindRenderer((JComboBox)this.featureSelectionComboBox, (RenderingStrategy)renderingStrategy);
        this.featureSelectionComboBox.setRenderer(new ContributedComboBoxRenderer((RenderingStrategy)renderingStrategy));
    }

    private void assignHelpIds() {
        HelpIdAssignerExt helpIdAssigner = this.viewContext.getHelpIdAssigner();
        helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:force_mode_overall");
        helpIdAssigner.assignHelpId((JComponent)this.featureSelectionComboBox, "gui:force_mode_feature");
        helpIdAssigner.assignHelpId((JComponent)this.forceTypeComboBox, "gui:force_mode_type");
        helpIdAssigner.assignHelpId((JComponent)this.disablePhysicalTeachButton, "gui:test_force_mode_by_freedrive_button");
    }

    public void enter(Object o) {
        super.enter(o);
        this.featureSelectionComboBox.setModel(new FeatureComboBoxModel(this.installationLookup, this.programReferenceService, (GeomFeatureReferenceBase)((ForceNode)this.getNode()).getFeatureReference(), this.featuresLookup, false, this.programFeatureService));
        this.recipeHelper.subscribe(RobotState.class);
        this.maybeDisableTestButton();
        this.disablePhysicalTeachButton.setSelected(true);
    }

    private void maybeDisableTestButton() {
        this.disablePhysicalTeachButton.setEnabled(((ForceNode)this.getNode()).getForceType() != ForceType.MOTION);
    }

    public Object exit() {
        this.recipeHelper.unsubscribe(RobotState.class);
        this.stopForceTestProgram();
        ControllerTeachButton.setPhysicalTeachButtonEnabled((boolean)true);
        return super.exit();
    }

    protected void updateCard() {
        this.updating = true;
        ForceType forceType = ((ForceNode)this.getNode()).getForceType();
        this.forceTypeComboBox.setSelectedItem(forceType);
        this.updateForceCard(forceType);
        this.updating = false;
    }

    private void initComponents() {
        this.valuesCardPanel = new FlippablePanel();
        this.valuesCardPanel.setBorder(BorderFactory.createEmptyBorder());
        WidgetFactory widgetFactory = this.viewContext.createWidgetFactory();
        URFontFactory fontFactory = this.viewContext.getFontFactory();
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        CommandNamesResource names = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        this.forceTypeComboBox = new JComboBox();
        this.forceTypeComboBox.setModel(new EnumComboBoxModel((Enum[])ForceType.values()));
        this.forceTypeComboBox.setFont(fontFactory.getRelativeFont(URFontFactory.Style.DEFAULT, URFontFactory.Size.LARGE));
        this.forceTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForceCardImpl.this.forceTypeComboBoxActionPerformed();
            }
        });
        this.forceTypeComboBox.setName(ForceCard.FORCE_TYPE_SELECTION);
        this.featureSelectionComboBox = new JComboBox();
        this.featureSelectionComboBox.setAlignmentX(0.0f);
        this.featureSelectionComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ForceCardImpl.this.featureSelectionComboBoxActionPerformed();
            }
        });
        this.disablePhysicalTeachButton = widgetFactory.createToggleButton((Action)((Object)new TeachTestActionDefinition(resource)));
        this.disablePhysicalTeachButton.setPreferredSize(new Dimension(200, 50));
        JPanel testButton = new JPanel(new FlowLayout(0, 20, 0));
        testButton.setBorder(new EmptyBorder(10, 0, 10, 20));
        testButton.add(this.disablePhysicalTeachButton);
        JLabel testLabel = new JLabel(HTML.html((String)resource.forceTestButtonDescription()));
        testLabel.setPreferredSize(new Dimension(400, 50));
        testLabel.setFont(fontFactory.getRelativeFont(URFontFactory.Size.SMALL));
        JPanel testButtonPanel = new JPanel();
        testButtonPanel.setLayout(new BoxLayout(testButtonPanel, 0));
        testButtonPanel.setBorder(BorderFactory.createEmptyBorder(10, 20, 10, 20));
        testButtonPanel.add(Box.createHorizontalGlue());
        testButtonPanel.add(testLabel);
        testButtonPanel.add(Box.createHorizontalStrut(20));
        testButtonPanel.add(testButton);
        testButtonPanel.add(Box.createHorizontalGlue());
        this.forceIllustration = new JLabel();
        this.setLayout(new BorderLayout(0, 5));
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.add(this.viewContext.createFormBuilder().headerLabel(names.Force(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component((JComponent)this.forceTypeComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().description(resource.simpleForceDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).label(resource.Feature(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.featureSelectionComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().end().component((JComponent)this.forceIllustration, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER, FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).component((JComponent)this.valuesCardPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(12).getPanel(), "Center");
        this.add(testButtonPanel, "South");
        this.forceIllustration.setVerticalAlignment(3);
    }

    private void featureSelectionComboBoxActionPerformed() {
        if (this.featureSelectionComboBox.getSelectedItem() instanceof GeomFeatureReference) {
            GeomFeatureReference selectedFeature = (GeomFeatureReference)this.featureSelectionComboBox.getSelectedItem();
            ((ForceNode)this.getNode()).setFeatureReference(selectedFeature);
        } else {
            Log.error((String)"It was not a GeomFeature that was selected in the combobox");
        }
        this.updateCard();
    }

    boolean isSimpleWithAdvanchedSettings(ForceType forceType) {
        return forceType == ForceType.SIMPLE && ((ForceNode)this.getNode()).hasAdvancedSettings();
    }

    private boolean confirmDeleteAdvanvedSettingsOnForceCard() {
        ConfirmationMessage confirmDeleteAdvancedSettingsOnForceCard = this.confirmDeleteAdvancedSettingsOnForceCard((com.ur.i18n.TextResource)this.viewContext.getTextResource(com.ur.i18n.TextResource.class));
        return LegacyURDialogCreator.confirmMessageDialog((ConfirmationMessage)confirmDeleteAdvancedSettingsOnForceCard) == DialogReturnValue.OK;
    }

    private boolean canForceTypeBeUpdated(ForceType forceType) {
        boolean simpleWithAdvanchedSettings = this.isSimpleWithAdvanchedSettings(forceType);
        return !simpleWithAdvanchedSettings || this.confirmDeleteAdvanvedSettingsOnForceCard();
    }

    private void forceTypeComboBoxActionPerformed() {
        if (this.updating) {
            return;
        }
        ForceType selection = (ForceType)this.forceTypeComboBox.getSelectedItem();
        if (this.canForceTypeBeUpdated(selection)) {
            ((ForceNode)this.getNode()).setForceTypeAndAdjustValues(selection);
        }
        this.forceTypeComboBox.setSelectedItem(((ForceNode)this.getNode()).getForceType());
        this.updateForceCard(selection);
        this.maybeDisableTestButton();
    }

    public void accept(RobotState robotState) {
        if (this.shouldStartTestForceProgram(robotState)) {
            this.startForceTestProgram();
        } else if (!this.isFreedriveButtonPressed(robotState)) {
            this.stopForceTestProgram();
        }
    }

    private void updateForceCard(ForceType forceType) {
        ForceNode node = (ForceNode)this.getNode();
        switch (forceType) {
            case SIMPLE: {
                this.forceIllustration.setIcon(ProgramImageResource.forceSimple());
                this.valuesCardPanel.switchTo(ForceCardSimplePanel.class, (Object)node);
                break;
            }
            case FRAME: {
                this.forceIllustration.setIcon(ProgramImageResource.forceSimple());
                this.valuesCardPanel.switchTo(ForceCardAdvancedPanel.class, (Object)node);
                break;
            }
            case POINT: {
                this.forceIllustration.setIcon(ProgramImageResource.forcePoint());
                this.valuesCardPanel.switchTo(ForceCardAdvancedPanel.class, (Object)node);
                break;
            }
            case MOTION: {
                this.forceIllustration.setIcon(ProgramImageResource.forceMotion());
                this.valuesCardPanel.switchTo(ForceCardAdvancedPanel.class, (Object)node);
                break;
            }
            default: {
                Log.error((String)("Force type returned by forceNode was not recognized: " + forceType));
            }
        }
        this.valuesCardPanel.enterActiveChild((Object)node);
    }

    private void startForceTestProgram() {
        this.controllerInterface.runScript(((ForceNode)this.getNode()).getForceTestScriptCode());
        ControllerSocketSender.sendRunProgram();
        this.isExecutingForceTestProgram = true;
    }

    private void stopForceTestProgram() {
        if (this.isExecutingForceTestProgram) {
            ControllerSocketSender.sendStopProgram();
            this.isExecutingForceTestProgram = false;
        }
    }

    private boolean shouldStartTestForceProgram(RobotState robotState) {
        boolean isNoProgramRunning = !robotState.programRunning && !this.isExecutingForceTestProgram;
        boolean isHardwareButtonPressed = this.isFreedriveButtonPressed(robotState);
        return isNoProgramRunning && isHardwareButtonPressed && !this.disablePhysicalTeachButton.isSelected();
    }

    private boolean isFreedriveButtonPressed(RobotState robotState) {
        return robotState.isTeachButtonPressed() || robotState.freedriveIOPressed;
    }

    private class TeachTestActionDefinition
    extends AbstractActionDefinition {
        TeachTestActionDefinition(TextResource resource) {
            this.putValue("Function", ActionDefinition.Function.INLINE_ACTION);
            this.putValue("Name", resource.teachTest());
        }

        public void actionPerformed(ActionEvent e) {
            boolean enabled = ForceCardImpl.this.disablePhysicalTeachButton.isSelected();
            if (enabled) {
                ForceCardImpl.this.stopForceTestProgram();
            }
            ControllerTeachButton.setPhysicalTeachButtonEnabled((boolean)enabled);
        }
    }
}

