/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.force.infrastructure;

import com.ur.program.internal.TextResource;
import com.ur.swing.BindingRegistration;
import com.ur.swing.CardPanel;
import com.ur.swing.CompletedListener;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberFieldUtils;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.ForceNode;
import gui.program.validation.ForceNodeValidationStrategyProvider;
import java.awt.Container;
import java.awt.FlowLayout;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ForceCardSimplePanel
extends CardPanel {
    public static final String FORCE_TEXT_FIELD = "forceTextField.G5ForceCardSimplePanel";
    protected JTextField simpleForceTextField;
    private ForceNode node;
    private ViewContext viewContext;
    private final ForceNodeValidationStrategyProvider validationStrategyProvider;
    private BindingRegistration bindingRegistration;

    public ForceCardSimplePanel(ViewContext viewContext, ForceNodeValidationStrategyProvider validationStrategyProvider) {
        this.viewContext = viewContext;
        this.validationStrategyProvider = validationStrategyProvider;
        this.initComponents();
        this.bindComponents();
    }

    private void initComponents() {
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(Box.createVerticalStrut(50));
        JLabel forceValueLabel = new JLabel();
        forceValueLabel.setText(((TextResource)this.viewContext.getTextResource(TextResource.class)).Force());
        forceValueLabel.setAlignmentX(0.0f);
        this.add(forceValueLabel);
        JPanel simpleForcePanel = new JPanel();
        simpleForcePanel.setLayout(new FlowLayout(0));
        simpleForcePanel.setAlignmentX(0.0f);
        this.simpleForceTextField = new JTextField();
        this.simpleForceTextField.setFocusable(false);
        this.simpleForceTextField.setHorizontalAlignment(4);
        this.simpleForceTextField.setColumns(5);
        this.simpleForceTextField.setName(FORCE_TEXT_FIELD);
        simpleForcePanel.add(this.simpleForceTextField);
        JLabel forceUnitLabel = new JLabel();
        forceUnitLabel.setText(Units.getText().unitN());
        simpleForcePanel.add(forceUnitLabel);
        this.add(simpleForcePanel);
        this.add(Box.createVerticalGlue());
    }

    private void bindComponents() {
        NumberFieldUtils.bindNumberPicker((JTextField)this.simpleForceTextField, (CompletedListener)new CompletedListener.Template(){

            public void requestApply() {
                int indexOfEditingForce = ForceCardSimplePanel.this.node.getDefaultCompliantAxis();
                try {
                    ForceCardSimplePanel.this.node.setWrench(indexOfEditingForce, Units.convert_to_N((String)ForceCardSimplePanel.this.simpleForceTextField.getText()));
                }
                catch (NumberFormatException numberFormatException) {}
                ForceCardSimplePanel.this.updateTextFieldValue();
            }
        }, (Mode)Mode.Standard);
        this.updateBinder();
    }

    private void updateTextFieldValue() {
        double wrench = this.node.getWrench(this.node.getDefaultCompliantAxis());
        this.simpleForceTextField.setText(Units.convert_from_N((double)wrench));
    }

    public void enter(Object o) {
        this.node = (ForceNode)o;
        this.updateTextFieldValue();
        this.updateBinder();
    }

    private void updateBinder() {
        if (this.bindingRegistration != null) {
            this.bindingRegistration.removeRegistration();
        }
        this.bindingRegistration = NumberFieldUtils.bindErrorValidator((JTextField)this.simpleForceTextField, (ValidationStrategy)this.validationStrategyProvider.getForceValidator());
    }
}

