/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.internal;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.errorcode.ErrorCode;
import com.ur.program.edit.infrastructure.CommandTab;
import com.ur.swing.SwingUtil;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.constants.errorcodes.ReportLevel;
import gui.installation.naming.NotificationFacade;
import javax.inject.Inject;
import javax.inject.Provider;

public class NotificationFacadeImpl
implements NotificationFacade {
    private final Provider<CommandTab> commandTabProvider;

    @Inject
    public NotificationFacadeImpl(Provider<CommandTab> commandTabProvider) {
        this.commandTabProvider = commandTabProvider;
    }

    public void updateCommandTab() {
        final CommandTab commandTab = (CommandTab)this.commandTabProvider.get();
        SwingUtil.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                commandTab.showCommandPanelOfCurrentProgramNode();
            }
        });
    }

    public void notifyFeatureNameClash(int numberOfNameClashes) {
        RobotMessage msg = new RobotMessage();
        msg.type = RobotMessageType.KEY;
        msg.timestamp = -1L;
        msg.source = MessageSource.GUI;
        msg.warningLevel = ReportLevel.WARNING;
        msg.type = RobotMessageType.ERROR_CODE;
        msg.errorCode = ErrorCode.NAME_CONFLICT_IN_LOADED_PROGRAM;
        msg.errorArgument = 1;
        msg.extraData = numberOfNameClashes;
        msg.notifyAllSubscribers();
    }
}

