/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.internal;

import com.ur.lang.resources.Key;
import com.ur.util.logging.Log;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.ImageIcon;

public final class ProgramImageResource {
    private static boolean isG5 = true;

    static {
        if (isG5) {
            ProgramImageResource.tryGetImage("switchOn.png");
            ProgramImageResource.tryGetImage("rename.png");
            ProgramImageResource.tryGetImage("save_small_hover.png");
            ProgramImageResource.tryGetImage("program-search-exit.png");
            ProgramImageResource.tryGetImage("destacking.png");
            ProgramImageResource.tryGetImage("program_small_hover.png");
            ProgramImageResource.tryGetImage("swipe_left.png");
            ProgramImageResource.tryGetImage("stacking.png");
            ProgramImageResource.tryGetImage("link_icon.png");
            ProgramImageResource.tryGetImage("swipe_right.png");
            ProgramImageResource.tryGetImage("program_tree.png");
            ProgramImageResource.tryGetImage("question_mark.png");
            ProgramImageResource.tryGetImage("switchOff.png");
            ProgramImageResource.tryGetImage("save_small.png");
            ProgramImageResource.tryGetImage("program-search.png");
            ProgramImageResource.tryGetImage("program_small.png");
            ProgramImageResource.tryGetImage("force_point.png");
            ProgramImageResource.tryGetImage("arrow_next_search.png");
            ProgramImageResource.tryGetImage("node_list.png");
            ProgramImageResource.tryGetImage("arrow_previous_search.png");
            ProgramImageResource.tryGetImage("force_motion.png");
            ProgramImageResource.tryGetImage("force_simple.png");
        }
    }

    private ProgramImageResource() {
    }

    private static Icon tryGetImage(String fileName) {
        if (isG5) {
            return ImageLoader.getIconImage("/images/", fileName);
        }
        return ImageLoader.getIconImage("<g3ImagesDir>", fileName);
    }

    @Key(value="switchOn.png")
    public static @Key(value="switchOn.png") Icon switchOn() {
        return ProgramImageResource.tryGetImage("switchOn.png");
    }

    @Key(value="rename.png")
    public static @Key(value="rename.png") Icon rename() {
        return ProgramImageResource.tryGetImage("rename.png");
    }

    @Key(value="save_small_hover.png")
    public static @Key(value="save_small_hover.png") Icon saveSmallHover() {
        return ProgramImageResource.tryGetImage("save_small_hover.png");
    }

    @Key(value="program-search-exit.png")
    public static @Key(value="program-search-exit.png") Icon programSearchExit() {
        return ProgramImageResource.tryGetImage("program-search-exit.png");
    }

    @Key(value="destacking.png")
    public static @Key(value="destacking.png") Icon destacking() {
        return ProgramImageResource.tryGetImage("destacking.png");
    }

    @Key(value="program_small_hover.png")
    public static @Key(value="program_small_hover.png") Icon programSmallHover() {
        return ProgramImageResource.tryGetImage("program_small_hover.png");
    }

    @Key(value="swipe_left.png")
    public static @Key(value="swipe_left.png") Icon swipeLeft() {
        return ProgramImageResource.tryGetImage("swipe_left.png");
    }

    @Key(value="stacking.png")
    public static @Key(value="stacking.png") Icon stacking() {
        return ProgramImageResource.tryGetImage("stacking.png");
    }

    @Key(value="link_icon.png")
    public static @Key(value="link_icon.png") Icon linkIcon() {
        return ProgramImageResource.tryGetImage("link_icon.png");
    }

    @Key(value="swipe_right.png")
    public static @Key(value="swipe_right.png") Icon swipeRight() {
        return ProgramImageResource.tryGetImage("swipe_right.png");
    }

    @Key(value="program_tree.png")
    public static @Key(value="program_tree.png") Icon programTree() {
        return ProgramImageResource.tryGetImage("program_tree.png");
    }

    @Key(value="question_mark.png")
    public static @Key(value="question_mark.png") Icon questionMark() {
        return ProgramImageResource.tryGetImage("question_mark.png");
    }

    @Key(value="switchOff.png")
    public static @Key(value="switchOff.png") Icon switchOff() {
        return ProgramImageResource.tryGetImage("switchOff.png");
    }

    @Key(value="save_small.png")
    public static @Key(value="save_small.png") Icon saveSmall() {
        return ProgramImageResource.tryGetImage("save_small.png");
    }

    @Key(value="program-search.png")
    public static @Key(value="program-search.png") Icon programSearch() {
        return ProgramImageResource.tryGetImage("program-search.png");
    }

    @Key(value="program_small.png")
    public static @Key(value="program_small.png") Icon programSmall() {
        return ProgramImageResource.tryGetImage("program_small.png");
    }

    @Key(value="force_point.png")
    public static @Key(value="force_point.png") Icon forcePoint() {
        return ProgramImageResource.tryGetImage("force_point.png");
    }

    @Key(value="arrow_next_search.png")
    public static @Key(value="arrow_next_search.png") Icon arrowNextSearch() {
        return ProgramImageResource.tryGetImage("arrow_next_search.png");
    }

    @Key(value="node_list.png")
    public static @Key(value="node_list.png") Icon nodeList() {
        return ProgramImageResource.tryGetImage("node_list.png");
    }

    @Key(value="arrow_previous_search.png")
    public static @Key(value="arrow_previous_search.png") Icon arrowPreviousSearch() {
        return ProgramImageResource.tryGetImage("arrow_previous_search.png");
    }

    @Key(value="force_motion.png")
    public static @Key(value="force_motion.png") Icon forceMotion() {
        return ProgramImageResource.tryGetImage("force_motion.png");
    }

    @Key(value="force_simple.png")
    public static @Key(value="force_simple.png") Icon forceSimple() {
        return ProgramImageResource.tryGetImage("force_simple.png");
    }

    public static URL asResource(Icon iconFromImageResource) {
        return ProgramImageResource.class.getResource(((ImageIcon)iconFromImageResource).getDescription());
    }

    private static final class ImageLoader {
        private static final HashMap<String, Icon> cachedIconResources = new HashMap();

        private ImageLoader() {
        }

        static Icon getIconImage(String path, String resource) {
            if (!cachedIconResources.containsKey(resource)) {
                String resourcePath = String.valueOf(path) + resource;
                cachedIconResources.put(resource, new ImageIconWrapper(resourcePath, ImageLoader.tryToLoadImage(resourcePath)));
            }
            return cachedIconResources.get(resource);
        }

        private static BufferedImage tryToLoadImage(String resource) {
            try {
                return ImageIO.read(ImageLoader.class.getResource(resource));
            }
            catch (IOException e1) {
                Log.warning((String)"Failed to load image as bundle resource", (Throwable)e1);
                try {
                    return ImageIO.read(new File(resource));
                }
                catch (IOException e2) {
                    Log.warning((String)("Failed to load image as file '" + resource + "'."), (Throwable)e2);
                    return null;
                }
            }
        }

        private static class ImageIconWrapper
        extends ImageIcon {
            private final String name;
            private final String fullName;

            ImageIconWrapper(String fullPathToResource, BufferedImage image) {
                super(image);
                this.name = fullPathToResource.substring(fullPathToResource.lastIndexOf(47) + 1);
                this.fullName = fullPathToResource;
            }

            @Override
            public String getDescription() {
                return this.fullName;
            }

            @Override
            public String toString() {
                return "ImageIcon '" + this.name + "'";
            }
        }
    }
}

