/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.internal;

import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageListener;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.program.script.ScriptErrorDialogCreator;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.WarningMessage;
import com.ur.util.event.EventManager;
import com.ur.view.DialogWithName;
import com.ur.view.constants.comm.RobotMessageType;
import com.ur.view.constants.dev.SafetyMode;
import com.ur.view.constants.errorcodes.MessageSource;
import com.ur.view.hmc.ControllerSocketSender;
import gui.polyscope.InstallationTreeSelector;
import gui.tools.DialogCreator;
import javax.inject.Inject;

public class ShowRobotMessagesFromController
implements RobotMessageListener {
    private final DialogCreator dialogCreator;
    private TextResource text;
    private InstallationTreeSelector installationTreeSelector;
    private ControllerInterface controllerInterface;
    private ScriptErrorDialogCreator scriptErrorDialogCreator;

    @Inject
    private ShowRobotMessagesFromController(TextResource text, EventManager eventManager, InstallationTreeSelector installationTreeSelector, DialogCreator dialogCreator, ControllerInterface controllerInterface, ScriptErrorDialogCreator scriptErrorDialogCreator) {
        this.dialogCreator = dialogCreator;
        this.text = text;
        this.installationTreeSelector = installationTreeSelector;
        this.controllerInterface = controllerInterface;
        this.scriptErrorDialogCreator = scriptErrorDialogCreator;
        eventManager.addStrongListener(RobotMessageListener.class, (Object)this);
    }

    public void handleRobotMessage(RobotMessage rm) {
        if (rm.source == MessageSource.SIMULATED_ROBOT) {
            this.showSimulationMessage(rm);
            ControllerSocketSender.sendUnlockProtectiveStop();
        } else if (rm.type == RobotMessageType.RUNTIME_EXCEPTION) {
            if (!this.controllerInterface.isUserProgramOnRobot()) {
                this.dialogCreator.showWarningMessageDialog(new WarningMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), this.text.RuntimeException(), rm.toString()), null);
            } else {
                this.installationTreeSelector.revalidateTree();
                ErrorMessage errorMessage = new ErrorMessage(DialogWithName.RUNTIME_EXCEPTION.getName(), this.text.RuntimeException(), rm.toString(), "");
                URDialogPanel popupPanel = this.scriptErrorDialogCreator.create(rm);
                this.dialogCreator.showErrorMessageWithCustomPanel((DialogMessage)errorMessage, popupPanel, null);
            }
        }
    }

    private void showSimulationMessage(RobotMessage rm) {
        if (rm.safetyMode == null) {
            rm.safetyMode = SafetyMode.PROTECTIVE_STOP;
        }
        this.dialogCreator.showSimulatedProtectiveStop(rm, this.text);
    }
}

