/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.assignment;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.visualizer.geomfeature.GeomFeature;
import com.ur.program.internal.TextResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.InputField;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.TextProvider;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.ExpressionValidator;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.Conjunction;
import com.ur.util.Predicate;
import com.ur.util.swing.HTML;
import com.ur.view.naming.UniqueByName;
import com.ur.view.program.CommandPanel;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.ProgramVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.controllerinterface.AssignmentExpressionValidatorImpl;
import gui.polyscope.setup.treenodes.geom.GeomPoseNodeContributed;
import gui.program.AssignmentNode;
import gui.program.EntityFactory;
import gui.program.services.GeomFeatureVariable;
import gui.program.validation.AssignmentNodeValidationStrategyProvider;
import gui.swing.renderers.VariableComboBoxModel;
import gui.swing.renderers.VariableRenderingStrategy;
import gui.tools.LanguagePack;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class AssignmentCard
extends CommandPanel<AssignmentNode> {
    public static final String RENAME_VARIABLE = "renameVariable." + AssignmentCard.class.getName();
    public static final String EXPRESSION_FIELD = "expressionField." + AssignmentCard.class.getName();
    public static final String VARIABLE_SELECTOR = "variableSelector." + AssignmentCard.class.getName();
    protected static String CREATE_NEW_VARIABLE_STRING = LanguagePack.getTextResource().createNew();
    private final EntityFactory entityFactory;
    private final ExpressionField expressionEditor;
    private final VariableLookupService lookupService;
    private final TextResource textResource;
    private final com.ur.i18n.TextResource i18nTextResource;
    private ViewContext viewContext;
    private EnumButtonGroup<AssignmentNode.OperatorValueType> requestType = new EnumButtonGroup(AssignmentNode.OperatorValueType.class);
    private JLabel explanationLabel;
    private InputField operatorMessageTextField;
    private JPanel optionsSwitchablePanel;
    private JButton renameVariableButton;
    private JComboBox sourceComboBox;
    private JComboBox variableSelectorComboBox;
    private JPanel theRestPanel;

    @Inject
    AssignmentCard(ViewContext viewContext, ExpressionField expressionEditor, EntityFactory entityFactory, VariableLookupService lookupService, AssignmentNodeValidationStrategyProvider assignmentNodeValidationStrategyProvider) {
        super(AssignmentNode.class);
        this.viewContext = viewContext;
        this.expressionEditor = expressionEditor;
        this.expressionEditor.setExpressionValidator((ExpressionValidator)new AssignmentExpressionValidatorImpl());
        this.entityFactory = entityFactory;
        this.lookupService = lookupService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.i18nTextResource = (com.ur.i18n.TextResource)viewContext.getTextResource(com.ur.i18n.TextResource.class);
        this.initComponents();
        this.bindComponents(assignmentNodeValidationStrategyProvider);
        viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_assignment");
    }

    public JTextField getOperatorMessageField() {
        return this.operatorMessageTextField;
    }

    private void bindComponents(AssignmentNodeValidationStrategyProvider assignmentValidationProvider) {
        ComboBoxRenderer.bindRenderer((JComboBox)this.variableSelectorComboBox, (RenderingStrategy)new VariableRenderingStrategy());
        TextProvider variableNameProvider = this.createVariableNameProvider();
        TextHolder provider = new TextHolder(){

            public String getText() {
                return ((AssignmentNode)AssignmentCard.this.getNode()).getVariableName();
            }

            public void setText(String text) {
                ((AssignmentNode)AssignmentCard.this.getNode()).setVariableName(text);
                AssignmentCard.this.updateCard();
            }
        };
        AutoCorrectionValidator variableNameValidator = assignmentValidationProvider.getVariableNameValidator(variableNameProvider, Variable.class, this.i18nTextResource);
        TextFieldUtils.bindTextPicker((JComponent)this.renameVariableButton, (TextHolder)provider, (ValidationStrategy)variableNameValidator);
        this.expressionEditor.setName(EXPRESSION_FIELD);
        this.renameVariableButton.setName(RENAME_VARIABLE);
        this.variableSelectorComboBox.setName(VARIABLE_SELECTOR);
        this.renameVariableButton.setName(RENAME_VARIABLE);
    }

    private TextProvider createVariableNameProvider() {
        return new TextProvider(){

            public String getText() {
                if (AssignmentCard.this.getNode() != null) {
                    return ((AssignmentNode)AssignmentCard.this.getNode()).getVariableName();
                }
                return "";
            }
        };
    }

    protected void updateCard() {
        this.expressionEditor.setNodeWithExpression((ExpressionNodeProperty)this.getNode());
        this.makeVariableSelectorComboBoxModel();
        switch (((AssignmentNode)this.getNode()).getValueSource()) {
            case EXPRESSION: {
                this.sourceComboBox.setSelectedIndex(0);
                break;
            }
            case OPERATOR: {
                this.sourceComboBox.setSelectedIndex(1);
            }
        }
        CardLayout cl1 = (CardLayout)this.optionsSwitchablePanel.getLayout();
        CardLayout cl2 = (CardLayout)this.theRestPanel.getLayout();
        if (((AssignmentNode)this.getNode()).getValueSource() == AssignmentNode.ValueSource.EXPRESSION) {
            this.explanationLabel.setText(this.textResource.commandAssignment());
            cl1.show(this.optionsSwitchablePanel, "expression");
            cl2.show(this.theRestPanel, "emptyCard");
        } else {
            this.explanationLabel.setText(this.textResource.commandAssignmentOperator());
            cl1.show(this.optionsSwitchablePanel, "operator");
            cl2.show(this.theRestPanel, "messageCard");
            this.operatorMessageTextField.setText(((AssignmentNode)this.getNode()).getAssignmentOperatorMessage());
            if (this.requestType.hasReference((Enum)((AssignmentNode)this.getNode()).getOperatorValueType())) {
                this.requestType.select((Enum)((AssignmentNode)this.getNode()).getOperatorValueType());
            }
        }
    }

    private DefaultComboBoxModel getVariablesComboBoxModel() {
        return new DefaultComboBoxModel();
    }

    private DefaultComboBoxModel getAssignemntTypesComboBoxModel() {
        DefaultComboBoxModel<String> dcbm = new DefaultComboBoxModel<String>();
        dcbm.addElement(((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Expression());
        dcbm.addElement(((TextResource)this.viewContext.getTextResource(TextResource.class)).MachineOperator());
        return dcbm;
    }

    private void makeVariableSelectorComboBoxModel() {
        Collection variables = this.lookupService.getAllNamedEntities();
        VariableComboBoxModel comboBoxModel = new VariableComboBoxModel();
        comboBoxModel.addElement((Object)CREATE_NEW_VARIABLE_STRING);
        comboBoxModel.addVariables(CollectionUtils.filter((Iterable)variables, (Predicate)new Conjunction(new Predicate[]{new UniqueByName(), new Predicate.ByType(Variable.class)})));
        if (((AssignmentNode)this.getNode()).getVariable() == null) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        } else {
            comboBoxModel.selectVariable(((AssignmentNode)this.getNode()).getVariable());
        }
        this.variableSelectorComboBox.setModel(comboBoxModel);
        this.renameVariableButton.setEnabled(this.isRenamable(comboBoxModel.getSelectedItem()));
    }

    private void initComponents() {
        Font valueFont = this.viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD);
        this.sourceComboBox = new JComboBox();
        this.explanationLabel = new JLabel();
        this.renameVariableButton = new JButton();
        this.variableSelectorComboBox = new ComboBox();
        this.optionsSwitchablePanel = new JPanel();
        JRadioButton requestBoolean = new JRadioButton();
        JRadioButton requestWholeNumber = new JRadioButton();
        JRadioButton requestDecimalNumber = new JRadioButton();
        JRadioButton requestString = new JRadioButton();
        this.theRestPanel = new JPanel();
        JLabel sourceLabel = new JLabel(this.textResource.assignmentValuefrom());
        sourceLabel.setHorizontalAlignment(4);
        this.sourceComboBox.setModel(this.getAssignemntTypesComboBoxModel());
        this.sourceComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssignmentCard.this.sourceComboBoxActionPerformed();
            }
        });
        JPanel typeSelectorPanel = this.viewContext.createFormBuilder().label(sourceLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.sourceComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).getRow();
        this.explanationLabel.setVerticalAlignment(1);
        this.variableSelectorComboBox.setModel(this.getVariablesComboBoxModel());
        this.variableSelectorComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                AssignmentCard.this.variableSelectorComboBoxActionPerformed();
            }
        });
        JLabel expressionLabel = new JLabel(this.textResource.Expression());
        expressionLabel.setFont(valueFont);
        this.expressionEditor.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ((AssignmentNode)AssignmentCard.this.getNode()).textHasChanged();
            }
        });
        this.expressionEditor.setHorizontalAlignment(0);
        JPanel expressionPanel = this.viewContext.createFormBuilder().label(expressionLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS}).end().component((JComponent)this.expressionEditor, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS}).end().getRow();
        requestBoolean.setText(this.textResource.assignmentOperatorYesOrNo());
        requestBoolean.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((AssignmentNode)AssignmentCard.this.getNode()).setOperatorValueType(AssignmentNode.OperatorValueType.BOOLEAN);
            }
        });
        requestWholeNumber.setText(this.textResource.assignmentOperatorAWholeNumber());
        requestWholeNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((AssignmentNode)AssignmentCard.this.getNode()).setOperatorValueType(AssignmentNode.OperatorValueType.INTEGER);
            }
        });
        requestDecimalNumber.setText(this.textResource.assignmentOperatorADecimalNumber());
        requestDecimalNumber.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((AssignmentNode)AssignmentCard.this.getNode()).setOperatorValueType(AssignmentNode.OperatorValueType.FLOAT);
            }
        });
        requestString.setText(this.textResource.assignmentOperatorATextString());
        requestString.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ((AssignmentNode)AssignmentCard.this.getNode()).setOperatorValueType(AssignmentNode.OperatorValueType.STRING);
            }
        });
        this.requestType.add((Enum)AssignmentNode.OperatorValueType.BOOLEAN, (AbstractButton)requestBoolean);
        this.requestType.add((Enum)AssignmentNode.OperatorValueType.FLOAT, (AbstractButton)requestDecimalNumber);
        this.requestType.add((Enum)AssignmentNode.OperatorValueType.INTEGER, (AbstractButton)requestWholeNumber);
        this.requestType.add((Enum)AssignmentNode.OperatorValueType.STRING, (AbstractButton)requestString);
        JPanel valueOperatorSelectPanel = this.viewContext.createFormBuilder().label(HTML.fontBold((String)this.textResource.assignmentOperatorRequestTheOperatorFor()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)requestBoolean, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)requestWholeNumber, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)requestDecimalNumber, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)requestString, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().getRow();
        this.optionsSwitchablePanel.setLayout(new CardLayout());
        this.optionsSwitchablePanel.setBorder(BorderFactory.createEmptyBorder());
        this.optionsSwitchablePanel.add((Component)expressionPanel, "expression");
        this.optionsSwitchablePanel.add((Component)valueOperatorSelectPanel, "operator");
        this.operatorMessageTextField = new InputField();
        this.operatorMessageTextField.setFocusable(false);
        this.operatorMessageTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String text = AssignmentCard.this.operatorMessageTextField.getText();
                ((AssignmentNode)AssignmentCard.this.getNode()).setAssignmentOperatorMessage(text);
            }
        });
        JPanel messageCardPanel = this.viewContext.createFormBuilder().label(this.textResource.assignmentOperatorOperatorMessage(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS}).end().component((JComponent)this.operatorMessageTextField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS}).end().getRow();
        this.theRestPanel.setLayout(new CardLayout());
        this.theRestPanel.add((Component)new JPanel(), "emptyCard");
        this.theRestPanel.add((Component)messageCardPanel, "messageCard");
        CommandNamesResource commandNamesResource = (CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class);
        this.renameVariableButton.setIcon(ViewImageResource.rename());
        this.viewContext.createFormBuilder().headerLabel(commandNamesResource.Assignment(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_6_COLUMNS}).component((JComponent)typeSelectorPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().component((JComponent)this.explanationLabel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_8_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).label(HTML.fontBold((String)this.textResource.Variable()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).component((JComponent)this.optionsSwitchablePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_8_ROWS}).end().component((JComponent)this.renameVariableButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.variableSelectorComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).label(HTML.fontBold((String)"\u2254"), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end(7).component((JComponent)this.theRestPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_10_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).setOnPanel((JPanel)((Object)this));
    }

    public Object exit() {
        ExpressionField.ShowExpressionPicker expressionPicker = this.expressionEditor.getExpressionPicker();
        if (expressionPicker != null) {
            expressionPicker.clean();
        }
        return super.exit();
    }

    private void variableSelectorComboBoxActionPerformed() {
        Object selectedItem = this.variableSelectorComboBox.getSelectedItem();
        if (selectedItem == CREATE_NEW_VARIABLE_STRING) {
            this.makeNewVariableAndAssignToNode();
        }
        if (selectedItem instanceof Variable) {
            ((AssignmentNode)this.getNode()).setVariable((Variable)selectedItem);
            this.renameVariableButton.setEnabled(this.isRenamable(selectedItem));
        }
    }

    private void makeNewVariableAndAssignToNode() {
        ProgramVariable variable = this.entityFactory.createVariable();
        ((AssignmentNode)this.getNode()).setVariable((Variable)variable);
        this.makeVariableSelectorComboBoxModel();
    }

    private boolean isRenamable(Object selectedVariable) {
        GeomFeature feature;
        if (selectedVariable instanceof GeomFeatureVariable && (feature = ((GeomFeatureVariable)selectedVariable).dereference()) instanceof GeomPoseNodeContributed) {
            return false;
        }
        return !(selectedVariable instanceof InstallationVariableReference);
    }

    private void sourceComboBoxActionPerformed() {
        if (this.sourceComboBox.getSelectedIndex() == 0) {
            ((AssignmentNode)this.getNode()).setValueSource(AssignmentNode.ValueSource.EXPRESSION);
        } else if (this.sourceComboBox.getSelectedIndex() == 1) {
            ((AssignmentNode)this.getNode()).setValueSource(AssignmentNode.ValueSource.OPERATOR);
        }
        this.updateCard();
    }
}

