/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.assignment;

import com.ur.lang.StringUtils;
import com.ur.polyscope.program.commandview.ProgramTreeNodeRenderer;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.resources.ViewImageResource;
import com.ur.swing.LanguageConfiguration;
import com.ur.view.Settings;
import gui.program.AssignmentNode;
import gui.tools.LanguagePack;
import javax.swing.Icon;

public class AssignmentNodeRenderer
implements ProgramTreeNodeRenderer {
    public boolean isSupported(AbstractProgramNode abstractProgramNode) {
        return abstractProgramNode instanceof AssignmentNode;
    }

    public Icon getIcon(AbstractProgramNode abstractProgramNode, boolean definedNode) {
        return definedNode ? ViewImageResource.programAssignment() : ViewImageResource.programAssignmentUndefined();
    }

    public String getText(AbstractProgramNode abstractProgramNode, boolean b) {
        AssignmentNode assignmentNode = (AssignmentNode)abstractProgramNode;
        StringBuffer s = new StringBuffer();
        if (assignmentNode.getVariable() == null) {
            s.append("...");
        } else {
            s.append(assignmentNode.getVariable());
        }
        if (Settings.getLanguage().equals((Object)LanguageConfiguration.SupportedLanguage.jp)) {
            s.append(":=");
        } else {
            s.append("\u2254");
        }
        StringBuffer sb = new StringBuffer();
        assignmentNode.getExpression().generateText(sb);
        String expr = sb.toString();
        switch (assignmentNode.getValueSource()) {
            case EXPRESSION: {
                this.expressionToBuffer(expr, s);
                break;
            }
            case OPERATOR: {
                this.operatorToBuffer(assignmentNode, s);
            }
        }
        return s.toString();
    }

    private void expressionToBuffer(String expr, StringBuffer s) {
        if (expr.equals("")) {
            s.append("...");
        } else {
            s.append(expr);
        }
    }

    private void operatorToBuffer(AssignmentNode assignmentNode, StringBuffer s) {
        String operatorMessage = assignmentNode.getAssignmentOperatorMessage();
        if (!StringUtils.isNullOrEmpty((String)operatorMessage)) {
            s.append("'" + operatorMessage + "'");
        } else {
            switch (assignmentNode.getOperatorValueType()) {
                case BOOLEAN: {
                    s.append(LanguagePack.getCommandNamesResource().getBoolean());
                    break;
                }
                case INTEGER: {
                    s.append(LanguagePack.getCommandNamesResource().getInteger());
                    break;
                }
                case FLOAT: {
                    s.append(LanguagePack.getCommandNamesResource().getFloat());
                    break;
                }
                case STRING: {
                    s.append(LanguagePack.getCommandNamesResource().getString());
                }
            }
        }
    }
}

