/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.assignment.execution;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.program.nodes.assignment.execution.RequestDialogCreator;
import com.ur.program.nodes.assignment.execution.UserValueRequest;
import com.ur.swing.CompletedListener;
import com.ur.swing.ValueRequest;
import com.ur.swing.dialog.DialogButtonListener;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.dialog.URDialogType;
import com.ur.swing.dialog.WarningMessage;
import com.ur.swing.number.KeypadPanel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberPicker;
import com.ur.swing.text.TextHolder;
import com.ur.swing.text.TextPicker;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.constants.comm.RequestValueType;
import com.ur.view.variables.validation.ExpressionValidationStrategy;
import com.ur.view.variables.validation.NumberValidator;
import com.ur.view.variables.validation.WholeNumberValidator;
import gui.controllerinterface.PopupMessageExtraData;
import gui.tools.DialogCreator;
import gui.tools.LanguagePack;
import gui.tools.LegacyURDialogCreator;
import gui.tools.NonBlockingDialogCreator;
import javax.inject.Inject;
import javax.swing.JPanel;

public class RequestDialogCreatorImpl
implements RequestDialogCreator {
    private final NonBlockingDialogCreator creator;
    private final ValidationStrategy wholeNumberValidator;
    private final ValidationStrategy numberValidator;
    private final String title;
    private final DialogCreator dialogCreator;

    @Inject
    public RequestDialogCreatorImpl(NonBlockingDialogCreator creator, @WholeNumberValidator ValidationStrategy wholeNumberValidator, @NumberValidator ValidationStrategy numberValidator, DialogCreator dialogCreator) {
        this.creator = creator;
        this.wholeNumberValidator = wholeNumberValidator;
        this.numberValidator = numberValidator;
        this.title = LanguagePack.getCommandNamesResource().Assignment();
        this.dialogCreator = dialogCreator;
    }

    @Override
    public void showYesNoPicker(UserValueRequest next) {
        next.setReturnValue(LegacyURDialogCreator.popupYesNoCancelDialog((String)this.title, (String)next.getMessage()));
        next.returned();
    }

    @Override
    public void showWarning(RobotMessage rm, UserValueRequest next) {
        MessageDialogType dialogType = PopupMessageExtraData.getDialogType((Object)rm.extraData);
        if (rm.title.equals("EUROMAP67 Warning")) {
            this.dialogCreator.showWarningMessageDialog(new WarningMessage(rm.title, next.getMessage()), null);
            next.setReturnValue(DialogReturnValue.OK);
        } else {
            next.setReturnValue(LegacyURDialogCreator.showTitledMessageDialog((String)rm.title, (String)rm.message, (MessageDialogType)dialogType, (boolean)true, (boolean)true));
        }
        next.returned();
    }

    @Override
    public void showNumberPicker(final UserValueRequest valueRequest, CompletedListener completedListener) {
        NumberPicker numberPicker = new NumberPicker((ValueRequest)valueRequest);
        numberPicker.addCompletedListener(completedListener);
        if (valueRequest.getReturnValueType() == RequestValueType.INTEGER) {
            numberPicker.setMode(Mode.WholeNumbers);
            numberPicker.setErrorValidationStrategy(this.wholeNumberValidator);
        } else {
            numberPicker.setMode(Mode.Standard);
            numberPicker.setErrorValidationStrategy(this.numberValidator);
        }
        KeypadPanel panel = numberPicker.getKeypadPanelForShowing();
        this.creator.showNonBlockingDialog(new DialogMessage(this.title, ""), (URDialogPanel)panel, new DialogButtonListener(){

            public void onClick(Object o) {
                if (o == DialogReturnValue.CLOSE) {
                    valueRequest.returned();
                }
            }
        });
    }

    @Override
    public void showTextPicker(final UserValueRequest valueRequest, final CompletedListener completedListener) {
        TextHolder textHolder = new TextHolder(){

            public String getText() {
                return "";
            }

            public void setText(String text) {
                text = RequestDialogCreatorImpl.this.cleanUpInput(text);
                valueRequest.setReturnValue(text);
            }
        };
        TextPicker textPicker = new TextPicker(textHolder, false, valueRequest.getMessage());
        textPicker.setValidationStrategy((ValidationStrategy)new StringValidationStrategy(textPicker, new ExpressionValidationStrategy()));
        TextPickerDialogPanel urDialogPanel = new TextPickerDialogPanel(textPicker);
        textPicker.addCompletedListener((CompletedListener)new TextCompletedListener(urDialogPanel, completedListener));
        this.creator.showNonBlockingDialog(new DialogMessage(this.title, ""), (URDialogPanel)urDialogPanel, new DialogButtonListener(){

            public void onClick(Object o) {
                if (o == DialogReturnValue.CLOSE) {
                    completedListener.requestCancel();
                }
            }
        });
    }

    private String cleanUpInput(String text) {
        if (text.trim().isEmpty()) {
            return "\" \"";
        }
        if (!text.startsWith("\"")) {
            text = "\"" + text;
        }
        if (!text.endsWith("\"")) {
            text = String.valueOf(text) + "\"";
        }
        return text;
    }

    private static class StringValidationStrategy
    implements ValidationStrategy {
        private final TextPicker textPicker;
        private final ExpressionValidationStrategy expressionValidationStrategy;

        public StringValidationStrategy(TextPicker textPicker, ExpressionValidationStrategy expressionValidationStrategy) {
            this.textPicker = textPicker;
            this.expressionValidationStrategy = expressionValidationStrategy;
        }

        public boolean isValid(String text) {
            if (text.contains("\"")) {
                this.textPicker.setSubmitKeyEnabled(false);
                return false;
            }
            this.textPicker.setSubmitKeyEnabled(true);
            return true;
        }

        public String getErrorMessage(String text) {
            return this.expressionValidationStrategy.getErrorMessage(text);
        }
    }

    private static class TextCompletedListener
    implements CompletedListener {
        private final URDialogPanel urDialogPanel;
        private final CompletedListener completedListener;

        public TextCompletedListener(URDialogPanel urDialogPanel, CompletedListener completedListener) {
            this.urDialogPanel = urDialogPanel;
            this.completedListener = completedListener;
        }

        public void requestApply() {
            this.urDialogPanel.setReturnValueAndClose((Object)DialogReturnValue.OK);
            this.completedListener.requestApply();
        }

        public void requestCancel() {
            this.urDialogPanel.setReturnValueAndClose((Object)DialogReturnValue.CANCEL);
            this.completedListener.requestCancel();
        }
    }

    private static class TextPickerDialogPanel
    extends URDialogPanel {
        private final TextPicker textPicker;

        public TextPickerDialogPanel(TextPicker textPicker) {
            this.textPicker = textPicker;
        }

        public JPanel getPanel() {
            return (JPanel)this.textPicker.getInputPanel();
        }

        public URDialogType getDialogType() {
            return URDialogType.TEXT_PICKER;
        }
    }
}

