/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.assignment.execution;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.log.logentry.robotmessage.RobotMessageConsumer;
import com.ur.program.nodes.assignment.execution.UserValueRequest;
import gui.controllerinterface.PopupMessageExtraData;
import java.io.DataInput;
import java.io.IOException;
import javax.inject.Singleton;

@Singleton
public class UserRequestMessageConsumer
implements RobotMessageConsumer {
    public boolean sendNotification() {
        return false;
    }

    public int consume(DataInput dataInputStream, int messageLength, RobotMessage robotMessage) throws IOException {
        robotMessage.valueRequestId = dataInputStream.readInt();
        robotMessage.errorArgument = dataInputStream.readInt();
        int messageOffset = 8;
        if (robotMessage.errorArgument == 8) {
            boolean warning = dataInputStream.readBoolean();
            boolean error = dataInputStream.readBoolean();
            boolean blocking = dataInputStream.readBoolean();
            int titleLength = dataInputStream.readUnsignedByte();
            messageOffset += 4 + titleLength;
            robotMessage.extraData = new PopupMessageExtraData(warning, error, blocking);
            byte[] titleData = new byte[titleLength];
            dataInputStream.readFully(titleData);
            robotMessage.title = new String(titleData);
        }
        byte[] data = new byte[messageLength - messageOffset];
        dataInputStream.readFully(data);
        robotMessage.message = new String(data);
        UserValueRequest.addValueRequest(robotMessage);
        return messageLength;
    }
}

