/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.assignment.execution;

import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.controllerinterface.ControllerInterface;
import com.ur.program.nodes.assignment.execution.RequestDialogCreator;
import com.ur.program.nodes.assignment.execution.UserValueRequest$AjcClosure1;
import com.ur.swing.CompletedListener;
import com.ur.swing.ValueRequest;
import com.ur.swing.dialog.DialogReturnValue;
import com.ur.view.constants.comm.RequestValueType;
import com.ur.view.gui.threading.WorkerDeamon;
import com.ur.view.gui.threading.WorkerDeamonAspect;
import com.ur.view.hmc.ControllerSocketSender;
import gui.controllerinterface.PopupMessageExtraData;
import java.util.LinkedList;
import java.util.Queue;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class UserValueRequest
implements ControllerSocketSender.StopRobotListener,
ValueRequest {
    private static final int CANCEL_THRESHOLD_COUNT = 1;
    private static final Queue<UserValueRequest> valueRequestQueue;
    private static UserValueRequest currentlyShowing;
    private static int cancelCount;
    private static RequestDialogCreator requestDialogCreator;
    private static ControllerInterface controllerInterface;
    final RobotMessage robotMessage;
    private Object returnValue;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        UserValueRequest.ajc$preClinit();
        valueRequestQueue = new LinkedList<UserValueRequest>();
        currentlyShowing = null;
        cancelCount = 0;
    }

    public UserValueRequest(RobotMessage robotMessage) {
        this.robotMessage = robotMessage;
        this.returnValue = null;
        ControllerSocketSender.addStopRobotListener((ControllerSocketSender.StopRobotListener)this);
    }

    @Inject
    public static void setRequestDialogCreator(RequestDialogCreator requestDialogCreator) {
        UserValueRequest.requestDialogCreator = requestDialogCreator;
    }

    @Inject
    public static void setControllerInterface(ControllerInterface controllerInterface) {
        UserValueRequest.controllerInterface = controllerInterface;
    }

    public String getMessage() {
        return this.robotMessage.message;
    }

    public int getID() {
        return this.robotMessage.valueRequestId;
    }

    public RequestValueType getReturnValueType() {
        return RequestValueType.byId((int)this.robotMessage.errorArgument);
    }

    public void setReturnValue(Object value) {
        this.returnValue = value;
    }

    public boolean isBlocking() {
        boolean result = false;
        if (this.robotMessage.extraData instanceof PopupMessageExtraData) {
            result = ((PopupMessageExtraData)this.robotMessage.extraData).blocking;
        }
        return result;
    }

    private boolean isCancelled() {
        return this.returnValue == null || this.returnValue == DialogReturnValue.CANCEL;
    }

    public void returned() {
        if (currentlyShowing == null) {
            cancelCount = 0;
            return;
        }
        if (currentlyShowing.isCancelled() && ++cancelCount > 1) {
            this.robotMessage.message = String.valueOf(this.robotMessage.message) + ": 'CANCELLED'";
            this.robotMessage.notifyAllSubscribers();
            ControllerSocketSender.sendStopProgram();
            UserValueRequest.clear();
            return;
        }
        if (currentlyShowing.getReturnValueType() == RequestValueType.NONE) {
            this.handleInfoPopup();
        } else if (!currentlyShowing.isCancelled()) {
            currentlyShowing.doSendValue();
            cancelCount = 0;
        }
        if (currentlyShowing != null && !currentlyShowing.isCancelled() && valueRequestQueue.size() != 0) {
            valueRequestQueue.remove();
        }
        currentlyShowing = null;
        UserValueRequest.popupNextVariableRequestScreen();
    }

    private void handleInfoPopup() {
        if (currentlyShowing.isStopProgram()) {
            ControllerSocketSender.sendStopProgram();
            UserValueRequest.clear();
        } else if (currentlyShowing.isBlocking()) {
            controllerInterface.runScript("reply popup " + this.getID() + "\n");
        } else {
            ControllerSocketSender.sendResumeProgram();
        }
    }

    private void doSendValue() {
        this.robotMessage.message = String.valueOf(this.robotMessage.message) + ": " + this.getFriendlyStringValue();
        this.robotMessage.notifyAllSubscribers();
        controllerInterface.runScript(this.createReplyMessage());
    }

    private String createReplyMessage() {
        return "reply " + this.getReturnValueType().name().toLowerCase() + " " + this.getID() + " " + this.getFriendlyStringValue() + "\n";
    }

    private String getFriendlyStringValue() {
        switch (this.getReturnValueType()) {
            case BOOLEAN: {
                return this.returnValue == DialogReturnValue.YES ? "True" : "False";
            }
            case INTEGER: 
            case FLOAT: 
            case STRING: {
                return "" + this.returnValue;
            }
        }
        throw new IllegalStateException("Unhandled ValueType: " + this.getReturnValueType());
    }

    static void addValueRequest(RobotMessage rm) {
        valueRequestQueue.add(new UserValueRequest(rm));
        UserValueRequest.popupNextVariableRequestScreen();
    }

    static int size() {
        return valueRequestQueue.size();
    }

    static void clear() {
        cancelCount = 0;
        valueRequestQueue.clear();
        currentlyShowing = null;
    }

    @WorkerDeamon(name="Variable-Request-Thread")
    private static void popupNextVariableRequestScreen() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null);
        Object[] objectArray = new Object[]{joinPoint};
        UserValueRequest$AjcClosure1 userValueRequest$AjcClosure1 = new UserValueRequest$AjcClosure1(objectArray);
        WorkerDeamonAspect.aspectOf().aroundAnnotatedMethod(userValueRequest$AjcClosure1.linkClosureAndJoinPoint(65536));
    }

    public boolean isStopProgram() {
        return this.returnValue == DialogReturnValue.STOP_PROGRAM;
    }

    public void stopProgramSent() {
        UserValueRequest.clear();
    }

    static final /* synthetic */ void popupNextVariableRequestScreen_aroundBody0(JoinPoint joinPoint) {
        if (valueRequestQueue.isEmpty() || currentlyShowing != null) {
            return;
        }
        UserValueRequest next = currentlyShowing = valueRequestQueue.peek();
        switch (next.getReturnValueType()) {
            case BOOLEAN: {
                requestDialogCreator.showYesNoPicker(next);
                break;
            }
            case INTEGER: 
            case FLOAT: {
                requestDialogCreator.showNumberPicker(next, (CompletedListener)new OnCompletion(next));
                break;
            }
            case STRING: {
                requestDialogCreator.showTextPicker(next, (CompletedListener)new OnCompletion(next));
                break;
            }
            case NONE: {
                requestDialogCreator.showWarning(next.robotMessage, next);
                break;
            }
            default: {
                throw new IllegalStateException("Unhandled ValueType: " + next.getReturnValueType());
            }
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("UserValueRequest.java", UserValueRequest.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("a", "popupNextVariableRequestScreen", "com.ur.program.nodes.assignment.execution.UserValueRequest", "", "", "", "void"), 163);
    }

    private static class OnCompletion
    extends CompletedListener.Template {
        private final UserValueRequest next;

        OnCompletion(UserValueRequest next) {
            this.next = next;
        }

        public void requestApply() {
            this.next.returned();
        }

        public void requestCancel() {
            this.next.returned();
        }
    }
}

