/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.program.nodes.directionnode.DirectionViewPart;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.util.Optional;
import gui.program.direction.DirectionsLookup;
import gui.program.direction.MoveDirectionNode;
import javax.inject.Inject;
import javax.swing.JPanel;

public class DirectionButtonGroup
implements DirectionViewPart {
    private final DirectionViewPart.NodeProvider nodeProvider;
    private final View view;

    @Inject
    public DirectionButtonGroup(DirectionViewPart.NodeProvider nodeProvider, View view) {
        this.nodeProvider = nodeProvider;
        this.view = view;
        this.view.setService(this);
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void update() {
        Optional<MoveDirectionNode> optional = this.nodeProvider.getDirectionNode();
        if (optional.isPresent()) {
            ExpressionBranchNode expression;
            MoveDirectionNode node = (MoveDirectionNode)optional.get();
            boolean useCombobox = node.getSelectedDirection().isPresent();
            DirectionsLookup.Direction direction = DirectionsLookup.Direction.XPlus;
            if (useCombobox) {
                direction = (DirectionsLookup.Direction)node.getSelectedDirection().get();
                expression = new ExpressionBranchNode(direction.getPoseString());
            } else {
                expression = (ExpressionBranchNode)node.getExpression().get();
            }
            this.view.update(new ViewModel(useCombobox, direction, expression));
        }
    }

    public void viewChanged(ViewModel model) {
        Optional<MoveDirectionNode> optional = this.nodeProvider.getDirectionNode();
        if (optional.isPresent()) {
            MoveDirectionNode node = (MoveDirectionNode)optional.get();
            if (model.useCombobox) {
                if (!node.getSelectedDirection().isPresent() || model.selectedDirection != node.getSelectedDirection().get()) {
                    node.setDirectionCompound(Optional.of((Object)model.selectedDirection));
                    node.textHasChanged();
                }
            } else if (!node.getExpression().isPresent() || !model.expression.equals(node.getExpression().get())) {
                node.setExpressionCompound(Optional.of((Object)model.expression));
                node.textHasChanged();
            }
        }
    }

    public static interface View {
        public JPanel getPanel();

        public void update(ViewModel var1);

        public void setService(DirectionButtonGroup var1);
    }

    public static class ViewModel {
        public final boolean useCombobox;
        public final DirectionsLookup.Direction selectedDirection;
        public final ExpressionBranchNode expression;

        public ViewModel(boolean useCombobox, DirectionsLookup.Direction selectedDirection, ExpressionBranchNode expression) {
            this.useCombobox = useCombobox;
            this.selectedDirection = selectedDirection;
            this.expression = expression;
        }
    }
}

