/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.program.internal.TextResource;
import com.ur.program.nodes.directionnode.DirectionButtonGroup;
import com.ur.program.nodes.directionnode.DirectionRenderingStrategy;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.ExpressionBranchNode;
import com.ur.swing.expression.field.ExpressionField;
import gui.program.direction.DirectionsLookup;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class DirectionButtonGroupView
extends JPanel
implements DirectionButtonGroup.View {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton useFixedDirection;
    private JRadioButton useExpression;
    private JComboBox directionCombobox;
    private ExpressionField expressionEditor;
    private final ViewContext viewContext;
    private DirectionButtonGroup service;
    private boolean isUpdating = false;

    @Inject
    public DirectionButtonGroupView(ViewContext viewContext, ExpressionField expressionEditor) {
        this.viewContext = viewContext;
        this.expressionEditor = expressionEditor;
        this.initComponents();
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.useFixedDirection = new JRadioButton();
        this.useFixedDirection.setName("MoveDirectionCard.useDirectionCombobox");
        this.useExpression = new JRadioButton();
        this.useExpression.setName("MoveDirectionCard.useExpression");
        this.buttonGroup.add(this.useFixedDirection);
        this.buttonGroup.add(this.useExpression);
        this.initializeDirectionCombobox();
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 0;
        this.add((Component)new JLabel(textResource.Direction()), constraints);
        constraints.gridy = 1;
        this.add(Box.createVerticalStrut(24));
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        this.add((Component)this.useFixedDirection, constraints);
        constraints.fill = 0;
        constraints.gridx = 1;
        constraints.weightx = 1.0;
        this.add((Component)this.directionCombobox, constraints);
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        this.add((Component)this.useExpression, constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.weightx = 6.0;
        this.add((Component)new JLabel(textResource.DirectionVector()), constraints);
        constraints.gridy = 4;
        this.add((Component)this.expressionEditor, constraints);
        this.expressionEditor.setName("MoveDirectionCard.expressionEditor");
        this.useFixedDirection.addActionListener(new RadioButtonSelectionListener());
        this.useExpression.addActionListener(new RadioButtonSelectionListener());
        this.directionCombobox.addItemListener(new DirectionChangeListener());
        this.expressionEditor.addActionListener((ActionListener)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DirectionButtonGroupView.this.updateViewModel();
            }
        });
    }

    private void updateViewModel() {
        if (!this.isUpdating) {
            boolean useCombobox = this.useFixedDirection.isSelected();
            DirectionsLookup.Direction selectedDirection = (DirectionsLookup.Direction)this.directionCombobox.getSelectedItem();
            ExpressionBranchNode expression = this.expressionEditor.getExpression();
            this.service.viewChanged(new DirectionButtonGroup.ViewModel(useCombobox, selectedDirection, expression));
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void update(DirectionButtonGroup.ViewModel model) {
        this.isUpdating = true;
        this.directionCombobox.setSelectedItem(model.selectedDirection);
        this.expressionEditor.setExpression(model.expression);
        if (model.useCombobox) {
            this.useFixedDirection.setSelected(true);
        } else {
            this.useExpression.setSelected(true);
        }
        this.directionCombobox.setEnabled(model.useCombobox);
        this.expressionEditor.setEnabled(!model.useCombobox);
        this.isUpdating = false;
    }

    @Override
    public void setService(DirectionButtonGroup service) {
        this.service = service;
    }

    private void initializeDirectionCombobox() {
        this.directionCombobox = new JComboBox();
        this.directionCombobox.setName("MoveDirectionCard.directionCombobox");
        ComboBoxRenderer.bindRenderer((JComboBox)this.directionCombobox, (RenderingStrategy)new DirectionRenderingStrategy());
        DirectionsLookup.Direction[] directionArray = DirectionsLookup.Direction.values();
        int n = directionArray.length;
        int n2 = 0;
        while (n2 < n) {
            DirectionsLookup.Direction direction = directionArray[n2];
            this.directionCombobox.addItem(direction);
            ++n2;
        }
    }

    public class DirectionChangeListener
    implements ItemListener {
        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 1) {
                DirectionButtonGroupView.this.updateViewModel();
            }
        }
    }

    public class RadioButtonSelectionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean useCombobox = DirectionButtonGroupView.this.useFixedDirection.isSelected();
            DirectionButtonGroupView.this.directionCombobox.setEnabled(useCombobox);
            DirectionButtonGroupView.this.expressionEditor.setEnabled(!useCombobox);
            DirectionButtonGroupView.this.updateViewModel();
        }
    }
}

