/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.program.nodes.directionnode.DirectionViewPart;
import com.ur.util.Optional;
import gui.program.MotionDefiningNode;
import gui.program.direction.MoveDirectionNode;
import gui.program.services.geom.GeomFeatureReferenceBase;
import javax.inject.Inject;
import javax.swing.JPanel;

public class FeatureButtonGroup
implements DirectionViewPart {
    private final DirectionViewPart.NodeProvider nodeProvider;
    private final View view;

    @Inject
    public FeatureButtonGroup(DirectionViewPart.NodeProvider nodeProvider, View view) {
        this.nodeProvider = nodeProvider;
        this.view = view;
        this.view.setService(this);
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void update() {
        Optional<MoveDirectionNode> optional = this.nodeProvider.getDirectionNode();
        if (optional.isPresent()) {
            MoveDirectionNode node = (MoveDirectionNode)optional.get();
            boolean useSharedFeature = !node.getFeatureReference().isPresent();
            this.view.update(new ViewModel(useSharedFeature ? ((MotionDefiningNode)node.getNodeOfType(MotionDefiningNode.class)).getFeatureReference() : (GeomFeatureReferenceBase)node.getFeatureReference().get(), useSharedFeature));
        }
    }

    public void viewChanged(ViewModel model) {
        Optional<MoveDirectionNode> optional = this.nodeProvider.getDirectionNode();
        if (optional.isPresent()) {
            MoveDirectionNode node = (MoveDirectionNode)optional.get();
            if (model.useShared) {
                node.setFeatureReference(Optional.empty());
                node.textHasChanged();
            } else if (!node.getFeatureReference().isPresent() || !((GeomFeatureReferenceBase)node.getFeatureReference().get()).equals((Object)model.featureReference)) {
                node.setFeatureReference(Optional.of((Object)model.featureReference));
                node.textHasChanged();
            }
        }
    }

    public static interface View {
        public JPanel getPanel();

        public void update(ViewModel var1);

        public void setService(FeatureButtonGroup var1);
    }

    public static class ViewModel {
        public final GeomFeatureReferenceBase featureReference;
        public final boolean useShared;

        public ViewModel(GeomFeatureReferenceBase featureReference, boolean useShared) {
            this.featureReference = featureReference;
            this.useShared = useShared;
        }
    }
}

