/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.polyscope.geomfeature.ProgramFeatureService;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.visualizer.geomfeature.FeaturesLookup;
import com.ur.program.internal.TextResource;
import com.ur.program.nodes.directionnode.FeatureButtonGroup;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.IconAndLabelProvider;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.renderers.contributed.ContributedComboBoxRenderer;
import gui.installation.RobotInstallationLookupService;
import gui.polyscope.setup.safety.FeatureIconAndLabelProvider;
import gui.program.services.ProgramReferenceService;
import gui.program.services.geom.GeomFeatureReferenceBase;
import gui.swing.renderers.FeatureComboBoxModel;
import gui.swing.renderers.TopLevelFeatureRenderingStrategy;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class FeatureButtonGroupView
extends JPanel
implements FeatureButtonGroup.View {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private JRadioButton sharedFeatureSelection;
    private JRadioButton customFeatureSelection;
    private JComboBox customFeatureCombobox;
    private final ViewContext viewContext;
    private final FeaturesLookup featuresLookup;
    private final RobotInstallationLookupService installationLookup;
    private final ProgramReferenceService programReferenceService;
    private final ProgramFeatureService programFeatureService;
    private FeatureButtonGroup service;
    private boolean isUpdating = false;

    @Inject
    public FeatureButtonGroupView(ViewContext viewContext, FeaturesLookup featuresLookup, RobotInstallationLookupService installationLookup, ProgramReferenceService programReferenceService, ProgramFeatureService programFeatureService) {
        this.viewContext = viewContext;
        this.featuresLookup = featuresLookup;
        this.installationLookup = installationLookup;
        this.programReferenceService = programReferenceService;
        this.programFeatureService = programFeatureService;
        this.initComponents();
    }

    private void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        this.sharedFeatureSelection = new JRadioButton();
        this.sharedFeatureSelection.setName("MoveDirectionCard.useSharedFeature");
        this.customFeatureSelection = new JRadioButton();
        this.customFeatureSelection.setName("MoveDirectionCard.useCustomFeature");
        this.buttonGroup.add(this.sharedFeatureSelection);
        this.buttonGroup.add(this.customFeatureSelection);
        this.customFeatureCombobox = factory.createComboBox((IconAndLabelProvider)new FeatureIconAndLabelProvider(), new Object[0]);
        this.customFeatureCombobox.setName("MoveDirectionCard.featureCombobox");
        TopLevelFeatureRenderingStrategy renderingStrategy = new TopLevelFeatureRenderingStrategy(this.featuresLookup);
        ComboBoxRenderer.bindRenderer((JComboBox)this.customFeatureCombobox, (RenderingStrategy)renderingStrategy);
        this.customFeatureCombobox.setRenderer(new ContributedComboBoxRenderer((RenderingStrategy)renderingStrategy));
        this.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.gridy = 0;
        this.add((Component)new JLabel(textResource.Feature()), constraints);
        constraints.gridy = 1;
        this.add(Box.createVerticalStrut(24));
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 0.0;
        this.add((Component)this.sharedFeatureSelection, constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.weightx = 6.0;
        this.add((Component)new JLabel(this.tagWithHtml(textResource.UseSharedFeature())), constraints);
        constraints.fill = 0;
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.weightx = 0.0;
        this.add((Component)this.customFeatureSelection, constraints);
        constraints.fill = 2;
        constraints.gridx = 1;
        constraints.weightx = 6.0;
        this.add((Component)this.customFeatureCombobox, constraints);
        constraints.gridy = 4;
        this.add(Box.createVerticalStrut(32), constraints);
        this.sharedFeatureSelection.addActionListener(new RadioButtonSelectionListener());
        this.customFeatureSelection.addActionListener(new RadioButtonSelectionListener());
        this.customFeatureCombobox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FeatureButtonGroupView.this.updateViewModel();
            }
        });
    }

    private String tagWithHtml(String input) {
        return "<html>" + input + "</html>";
    }

    private void updateViewModel() {
        if (!this.isUpdating) {
            this.service.viewChanged(new FeatureButtonGroup.ViewModel((GeomFeatureReferenceBase)this.customFeatureCombobox.getSelectedItem(), this.sharedFeatureSelection.isSelected()));
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void update(FeatureButtonGroup.ViewModel model) {
        this.isUpdating = true;
        this.customFeatureCombobox.setModel(new FeatureComboBoxModel((InstallationComponentLookup)this.installationLookup, this.programReferenceService, model.featureReference, this.featuresLookup, true, this.programFeatureService));
        if (model.useShared) {
            this.sharedFeatureSelection.setSelected(true);
        } else {
            this.customFeatureSelection.setSelected(true);
        }
        this.customFeatureCombobox.setEnabled(this.customFeatureSelection.isSelected());
        this.isUpdating = false;
    }

    @Override
    public void setService(FeatureButtonGroup service) {
        this.service = service;
    }

    public class RadioButtonSelectionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            FeatureButtonGroupView.this.customFeatureCombobox.setEnabled(FeatureButtonGroupView.this.customFeatureSelection.isSelected());
            FeatureButtonGroupView.this.updateViewModel();
        }
    }
}

