/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.program.nodes.ProgramNodeCardContribution;
import com.ur.program.internal.TextResource;
import com.ur.program.nodes.directionnode.DirectionButtonGroup;
import com.ur.program.nodes.directionnode.DirectionViewPart;
import com.ur.program.nodes.directionnode.FeatureButtonGroup;
import com.ur.program.nodes.directionnode.ToolParametersButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.Optional;
import gui.commandpanels.MoveDirectionCard;
import gui.program.direction.MoveDirectionNode;
import java.awt.BorderLayout;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.JComponent;
import javax.swing.JPanel;

@Singleton
public class MoveDirectionCardImpl
extends MoveDirectionCard
implements DirectionViewPart.NodeProvider {
    protected final ViewContext viewContext;
    private final FeatureButtonGroup featureButtonGroup;
    private final DirectionButtonGroup directionButtonGroup;
    private final ToolParametersButtonGroup toolParametersButtonGroup;
    private final Set<ProgramNodeCardContribution> programNodeCardContributions;

    @Inject
    public MoveDirectionCardImpl(ViewContext viewContext, Set<ProgramNodeCardContribution> programNodeCardContributions, FeatureButtonGroup featureButtonGroup, DirectionButtonGroup directionButtonGroup, ToolParametersButtonGroup toolParametersButtonGroup) {
        this.viewContext = viewContext;
        this.programNodeCardContributions = programNodeCardContributions;
        this.featureButtonGroup = featureButtonGroup;
        this.directionButtonGroup = directionButtonGroup;
        this.toolParametersButtonGroup = toolParametersButtonGroup;
        this.initComponents();
    }

    protected void initComponents() {
        TextResource textResource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        JPanel mainPanel = this.viewContext.createFormBuilder().headerLabel(((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Direction(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().description(textResource.DirectionDescription(textResource.Linear()), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).component((JComponent)this.featureButtonGroup.getPanel(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).spacer().component((JComponent)this.directionButtonGroup.getPanel(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).end(10).component(this.viewContext.createWidgetFactory().createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_COLUMNS}).end().component((JComponent)this.toolParametersButtonGroup.getPanel(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_5_ROWS}).end(8).getPanel();
        JPanel contributionsPanel = this.viewContext.createFormBuilder().component((JComponent)this.addContributions(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).spacer(5).end(2).getPanel();
        this.setLayout(new BorderLayout(0, 0));
        this.add(mainPanel, "Center");
        this.add(contributionsPanel, "South");
        this.assignHelpIds();
    }

    protected void updateCard() {
        this.featureButtonGroup.update();
        this.directionButtonGroup.update();
        this.toolParametersButtonGroup.update();
    }

    @Override
    public Optional<MoveDirectionNode> getDirectionNode() {
        return this.getNode() == null ? Optional.empty() : Optional.of((Object)((MoveDirectionNode)this.getNode()));
    }

    private JPanel addContributions() {
        FormBuilder formBuilder = this.viewContext.createFormBuilder();
        ProgramNodeCardContribution[] contributions = this.programNodeCardContributions.toArray(new ProgramNodeCardContribution[0]);
        Arrays.sort(contributions, Comparator.comparingInt(ProgramNodeCardContribution::getPriority));
        ProgramNodeCardContribution[] programNodeCardContributionArray = contributions;
        int n = contributions.length;
        int n2 = 0;
        while (n2 < n) {
            ProgramNodeCardContribution contribution = programNodeCardContributionArray[n2];
            formBuilder.component(contribution.getContribution(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.CENTER}).end();
            ++n2;
        }
        return formBuilder.getPanel();
    }

    protected void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_direction");
    }
}

