/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.program.nodes.directionnode.DirectionViewPart;
import com.ur.util.Optional;
import gui.program.direction.MoveDirectionNode;
import javax.inject.Inject;
import javax.swing.JPanel;

public class ToolParametersButtonGroup
implements DirectionViewPart {
    private final DirectionViewPart.NodeProvider nodeProvider;
    private final View view;

    @Inject
    public ToolParametersButtonGroup(DirectionViewPart.NodeProvider nodeProvider, View view) {
        this.nodeProvider = nodeProvider;
        this.view = view;
        this.view.setService(this);
    }

    @Override
    public JPanel getPanel() {
        return this.view.getPanel();
    }

    @Override
    public void update() {
        Optional<MoveDirectionNode> optional = this.nodeProvider.getDirectionNode();
        if (optional.isPresent()) {
            MoveDirectionNode node = (MoveDirectionNode)optional.get();
            MoveDirectionNode.ToolMotionParams resolvedToolParams = node.resolveToolMotionParams();
            this.view.update(new ViewModel(!node.getToolMotionParams().isPresent(), resolvedToolParams.usingOptiMove, resolvedToolParams.speed, resolvedToolParams.accel));
        }
    }

    public void viewChanged(ViewModel model) {
        Optional<MoveDirectionNode> optional = this.nodeProvider.getDirectionNode();
        if (optional.isPresent()) {
            MoveDirectionNode node = (MoveDirectionNode)optional.get();
            if (!model.useSharedParameters) {
                ToolParametersButtonGroup.updateParamsIfDifferent(model, node);
            } else {
                node.setToolMotionParams(Optional.empty());
            }
        }
    }

    private static void updateParamsIfDifferent(ViewModel model, MoveDirectionNode node) {
        if (!node.getToolMotionParams().isPresent()) {
            ToolParametersButtonGroup.setToolMotionParamsOnNode(node, model);
        } else {
            MoveDirectionNode.ToolMotionParams existingToolParams = (MoveDirectionNode.ToolMotionParams)node.getToolMotionParams().get();
            if (!existingToolParams.speed.equals((Object)model.speed) || !existingToolParams.accel.equals((Object)model.acceleration)) {
                ToolParametersButtonGroup.setToolMotionParamsOnNode(node, model);
            }
        }
    }

    private static void setToolMotionParamsOnNode(MoveDirectionNode node, ViewModel model) {
        node.setToolMotionParams(Optional.of((Object)new MoveDirectionNode.ToolMotionParams(model.usingOptiMove, model.speed, model.acceleration)));
    }

    public static interface View {
        public JPanel getPanel();

        public void update(ViewModel var1);

        public void setService(ToolParametersButtonGroup var1);
    }

    public static class ViewModel {
        public final boolean useSharedParameters;
        public boolean usingOptiMove;
        public final Speed speed;
        public final Acceleration acceleration;

        public ViewModel(boolean useSharedParameters, boolean usingOptiMove, Speed speed, Acceleration acceleration) {
            this.useSharedParameters = useSharedParameters;
            this.usingOptiMove = usingOptiMove;
            this.speed = speed;
            this.acceleration = acceleration;
        }
    }
}

