/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.directionnode;

import com.ur.polyscope.valueobjects.Acceleration;
import com.ur.polyscope.valueobjects.Speed;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.program.internal.TextResource;
import com.ur.program.nodes.directionnode.ToolParametersButtonGroup;
import com.ur.swing.BindingRegistration;
import com.ur.swing.DisplayMessageFactory;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class ToolParametersButtonGroupView
extends JPanel
implements ToolParametersButtonGroup.View {
    private final ButtonGroup buttonGroup = new ButtonGroup();
    private final ViewContext viewContext;
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;
    private final TextResource textResource;
    private NumberField accelerationField;
    private NumberField speedField;
    private JRadioButton sharedRadioButton;
    private JRadioButton speedAccelerationRadioButton;
    private ToolParametersButtonGroup service;
    private boolean isUpdating = false;
    private BindingRegistration errorRegistration = BindingRegistration.NULL_REGISTRATION;
    private ToolParametersButtonGroup.ViewModel model;

    @Inject
    public ToolParametersButtonGroupView(ViewContext viewContext, WaypointNodeValidationStrategyProvider validationStrategyProvider) {
        this.viewContext = viewContext;
        this.validationStrategyProvider = validationStrategyProvider;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        this.speedField = factory.createNumberField(e -> this.updateViewModel(), UnitsValueConverterFactory.getSpeedConverter());
        this.speedField.setName("MoveDirectionCard.speedNumberField");
        this.speedField.setUnitWidth(55);
        this.speedField.setUnit(Units.getText().unitMmS());
        this.speedField.setMode(Mode.PositiveNumbers);
        this.speedField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointSpeedLimitValidator()});
        this.accelerationField = factory.createNumberField(e -> this.updateViewModel(), UnitsValueConverterFactory.getAccelerationConverter());
        this.accelerationField.setName("MoveDirectionCard.accelerationNumberField");
        this.accelerationField.setUnitWidth(55);
        this.accelerationField.setUnit(Units.getText().unitMmS2());
        this.accelerationField.setMode(Mode.PositiveNumbers);
        this.accelerationField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointAccelerationLimitValidator()});
        this.sharedRadioButton = new JRadioButton(resource.useSharedParameters());
        this.sharedRadioButton.setName("MoveDirectionCard.useSharedToolParameters");
        this.speedAccelerationRadioButton = new JRadioButton(resource.toolSpeed());
        this.speedAccelerationRadioButton.setName("MoveDirectionCard.useCustomToolParameters");
        JLabel accelerationLabel = new JLabel(resource.toolAcceleration());
        accelerationLabel.setBorder(BorderFactory.createEmptyBorder(0, 36, 0, 0));
        this.viewContext.createFormBuilder().component((JComponent)this.sharedRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.speedAccelerationRadioButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.speedField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)accelerationLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.accelerationField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().groupColumns(new int[]{2}).setOnPanel((JPanel)this);
        this.sharedRadioButton.addActionListener(new RadioButtonSelectionListener());
        this.speedAccelerationRadioButton.addActionListener(new RadioButtonSelectionListener());
        this.buttonGroup.add(this.sharedRadioButton);
        this.buttonGroup.add(this.speedAccelerationRadioButton);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    private void updateViewModel() {
        if (!this.isUpdating) {
            this.service.viewChanged(new ToolParametersButtonGroup.ViewModel(this.sharedRadioButton.isSelected(), this.model != null && this.model.usingOptiMove, (Speed)this.speedField.getValue(), (Acceleration)this.accelerationField.getValue()));
        }
    }

    @Override
    public JPanel getPanel() {
        return this;
    }

    @Override
    public void update(ToolParametersButtonGroup.ViewModel model) {
        this.model = model;
        this.isUpdating = true;
        this.sharedRadioButton.setEnabled(!model.usingOptiMove);
        if (model.useSharedParameters) {
            this.sharedRadioButton.setSelected(true);
        } else {
            this.speedAccelerationRadioButton.setSelected(true);
        }
        this.speedField.setValue((Object)model.speed);
        this.accelerationField.setValue((Object)model.acceleration);
        this.speedField.setEnabled(!model.useSharedParameters);
        this.accelerationField.setEnabled(!model.useSharedParameters);
        if (model.useSharedParameters && model.usingOptiMove) {
            this.errorRegistration = DisplayMessageFactory.error((JComponent)this.sharedRadioButton, (String)this.textResource.optiMoveNotAvailable());
        } else if (DisplayMessageFactory.hasError((Component)this.sharedRadioButton)) {
            this.errorRegistration.removeRegistration();
            this.sharedRadioButton.setBackground(DisplayMessageFactory.OK_COLOR);
            this.errorRegistration = BindingRegistration.NULL_REGISTRATION;
        }
        this.isUpdating = false;
    }

    @Override
    public void setService(ToolParametersButtonGroup service) {
        this.service = service;
    }

    public class RadioButtonSelectionListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            boolean useSharedParameters = ToolParametersButtonGroupView.this.sharedRadioButton.isSelected();
            ToolParametersButtonGroupView.this.speedField.setEnabled(!useSharedParameters);
            ToolParametersButtonGroupView.this.accelerationField.setEnabled(!useSharedParameters);
            ToolParametersButtonGroupView.this.updateViewModel();
        }
    }
}

