/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.program.internal.TextResource;
import com.ur.resources.IllustrationImageResource;
import com.ur.swing.AbstractActionDefinition;
import com.ur.swing.ActionDefinition;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import gui.commandpanels.ControlProgramTreeStructure;
import gui.commandpanels.wizards.NewPatternCard;
import gui.program.EntityFactory;
import gui.program.PatternNode;
import java.awt.event.ActionEvent;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class NewPatternCardImpl
extends NewPatternCard {
    private final EntityFactory entityFactory;
    private ViewContext view;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private EnumButtonGroup<PatternNode.Type> buttonGroup;

    @Inject
    NewPatternCardImpl(ViewContext view, EntityFactory entityFactory, ControlProgramTreeStructure controlProgramTreeStructure) {
        this.entityFactory = entityFactory;
        this.view = view;
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.initComponents();
        this.assignHelpIds();
        this.setName("PickCard");
    }

    private void assignHelpIds() {
        this.view.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_pattern");
    }

    private void dimensionalityChange(PatternNode.Type dim) {
        this.entityFactory.setDimensionalityAndAdjustNodes((PatternNode)this.getNode(), dim);
    }

    protected void updateCard() {
        if (((PatternNode)this.getNode()).getDimensionality() == PatternNode.Type.UNDEFINED) {
            this.buttonGroup.clearSelection();
        } else {
            this.buttonGroup.select((Enum)((PatternNode)this.getNode()).getDimensionality());
        }
    }

    private void initComponents() {
        WidgetFactory factory = this.view.createWidgetFactory();
        CommandNamesResource commandText = (CommandNamesResource)this.view.getTextResource(CommandNamesResource.class);
        TextResource text = (TextResource)this.view.getTextResource(TextResource.class);
        this.buttonGroup = new EnumButtonGroup(PatternNode.Type.class);
        JButton lineSelection = factory.createButton((Action)((Object)new LineAction(text)));
        JButton squareSelection = factory.createButton((Action)((Object)new SquareAction(text)));
        JButton boxSelection = factory.createButton((Action)((Object)new BoxAction(text)));
        JButton listSelection = factory.createButton((Action)((Object)new ListAction(text)));
        lineSelection.setHorizontalAlignment(2);
        squareSelection.setHorizontalAlignment(2);
        boxSelection.setHorizontalAlignment(2);
        listSelection.setHorizontalAlignment(2);
        this.view.createFormBuilder().headerLabel(commandText.Pattern(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().description(text.commandPattern(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).label(text.positionsOnALine(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.INDENT}).component((JComponent)lineSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).spacer().end(2).label(text.positionsInASquare(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.INDENT}).component((JComponent)squareSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).spacer().end(2).label(text.positionsInABox(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.INDENT}).component((JComponent)boxSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).spacer().end(2).label(text.aListOfPositions(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.INDENT}).component((JComponent)listSelection, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).end().setOnPanel((JPanel)((Object)this));
        this.buttonGroup.add((Enum)PatternNode.Type.LINE, (AbstractButton)lineSelection);
        this.buttonGroup.add((Enum)PatternNode.Type.SQUARE, (AbstractButton)squareSelection);
        this.buttonGroup.add((Enum)PatternNode.Type.SQUARE_OBSOLETE, (AbstractButton)squareSelection);
        this.buttonGroup.add((Enum)PatternNode.Type.BOX, (AbstractButton)boxSelection);
        this.buttonGroup.add((Enum)PatternNode.Type.BOX_OBSOLETE, (AbstractButton)boxSelection);
        this.buttonGroup.add((Enum)PatternNode.Type.LIST, (AbstractButton)listSelection);
    }

    private void updateCardAndShowNewChildren() {
        if (((PatternNode)this.getNode()).getChildCount() != 0) {
            this.controlProgramTreeStructure.makeVisible(((PatternNode)this.getNode()).getFirstChild());
        }
        this.switchTo(((PatternNode)this.getNode()).getCardClass(), this.getNode());
    }

    private class BoxAction
    extends AbstractActionDefinition {
        public BoxAction(TextResource text) {
            this.putValue("Name", text.Box());
            this.putValue("InternalName", NewPatternCard.BOX_BUTTON);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("SmallIcon", IllustrationImageResource.threeDimensional());
        }

        public void actionPerformed(ActionEvent e) {
            NewPatternCardImpl.this.dimensionalityChange(PatternNode.Type.BOX);
            NewPatternCardImpl.this.updateCardAndShowNewChildren();
        }
    }

    private class LineAction
    extends AbstractActionDefinition {
        public LineAction(TextResource text) {
            this.putValue("Name", text.Line());
            this.putValue("InternalName", NewPatternCard.LINE_BUTTON);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("SmallIcon", IllustrationImageResource.oneDimensional());
        }

        public void actionPerformed(ActionEvent e) {
            NewPatternCardImpl.this.dimensionalityChange(PatternNode.Type.LINE);
            NewPatternCardImpl.this.updateCardAndShowNewChildren();
        }
    }

    private class ListAction
    extends AbstractActionDefinition {
        public ListAction(TextResource text) {
            this.putValue("Name", text.List());
            this.putValue("InternalName", NewPatternCard.LIST_BUTTON);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("SmallIcon", IllustrationImageResource.zeroDimensional());
        }

        public void actionPerformed(ActionEvent e) {
            NewPatternCardImpl.this.dimensionalityChange(PatternNode.Type.LIST);
            NewPatternCardImpl.this.updateCardAndShowNewChildren();
        }
    }

    private class SquareAction
    extends AbstractActionDefinition {
        public SquareAction(TextResource text) {
            this.putValue("Name", text.Square());
            this.putValue("InternalName", NewPatternCard.SQUARE_BUTTON);
            this.putValue("Function", ActionDefinition.Function.SECONDARY);
            this.putValue("SmallIcon", IllustrationImageResource.twoDimensional());
        }

        public void actionPerformed(ActionEvent e) {
            NewPatternCardImpl.this.dimensionalityChange(PatternNode.Type.SQUARE);
            NewPatternCardImpl.this.updateCardAndShowNewChildren();
        }
    }
}

