/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.LanguageConfiguration;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.util.swing.HTML;
import com.ur.view.Settings;
import com.ur.view.action.DeleteNodeAction;
import gui.commandpanels.ProgramCard;
import gui.polyscope.program.InsertNodeStrategy;
import gui.program.EntityFactory;
import gui.program.MainProgram;
import gui.program.ProgramRootNode;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.CompoundBorder;
import javax.swing.tree.TreeNode;

public class ProgramCardImpl
extends ProgramCard {
    public static final String INITIAL_VARS_CHECKBOX = "initialVarsCheckbox." + ProgramCardImpl.class.getSimpleName();
    public static final String PROGRAM_ROOT_CARD = "ProgramRootCard";
    private final EntityFactory entityFactory;
    private final DeleteNodeAction deleteNodeAction;
    private final InsertNodeStrategy insertNodeStrategy;
    private JCheckBox addBeforeStartSequenceCheckBox;
    private JCheckBox loopForeverCheckbox;
    private JCheckBox setInitialVariableValuesCheckBox;

    @Inject
    ProgramCardImpl(ViewContext view, EntityFactory entityFactory, DeleteNodeAction deleteNodeAction) {
        super(view, entityFactory, deleteNodeAction);
        this.entityFactory = entityFactory;
        this.deleteNodeAction = deleteNodeAction;
        this.insertNodeStrategy = new InsertNodeStrategy.AfterPlacementStrategy(entityFactory, (com.ur.i18n.TextResource)view.getTextResource(com.ur.i18n.TextResource.class));
        this.initComponents(view);
        this.setInitialVariableValuesCheckBox.setName(INITIAL_VARS_CHECKBOX);
        this.setName(PROGRAM_ROOT_CARD);
    }

    public void enter(Object o) {
        if (o instanceof ProgramRootNode) {
            ProgramRootNode rootNode = (ProgramRootNode)o;
            MainProgram mainProgram = rootNode.getMainProgram();
            mainProgram.setSelected();
            o = mainProgram;
        }
        super.enter(o);
    }

    protected void updateCard() {
        this.loopForeverCheckbox.setSelected(!((MainProgram)this.getNode()).isRunOnlyOnce());
        ProgramRootNode programRoot = ProgramRootNode.get((AbstractProgramNode)((AbstractProgramNode)this.getNode()));
        this.setInitialVariableValuesCheckBox.setSelected(programRoot.hasInitVariables());
        this.addBeforeStartSequenceCheckBox.setSelected(programRoot.hasBeforeStart());
    }

    private void initComponents(ViewContext view) {
        TextResource text = (TextResource)view.getTextResource(TextResource.class);
        WidgetFactory factory = view.createWidgetFactory();
        this.addBeforeStartSequenceCheckBox = factory.createCheckBox(text.addBeforeStart());
        this.setInitialVariableValuesCheckBox = factory.createCheckBox(text.setInitialVariable());
        this.loopForeverCheckbox = factory.createCheckBox(text.programLoopsForever());
        JPanel options = view.createFormBuilder().component((JComponent)this.addBeforeStartSequenceCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end().component((JComponent)this.loopForeverCheckbox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT}).end(2).getPanel();
        options.setBorder(new CompoundBorder(BorderFactory.createLineBorder(G5LookAndFeel.BETWEEN_CARD_COLOR), BorderFactory.createEmptyBorder(5, 0, 0, 0)));
        FormBuilder.PanelConstraints spanForImages = Settings.getLanguage() == LanguageConfiguration.SupportedLanguage.ru ? FormBuilder.PanelConstraints.SPAN_14_ROWS : FormBuilder.PanelConstraints.SPAN_12_ROWS;
        view.createFormBuilder().headerLabel(((CommandNamesResource)view.getTextResource(CommandNamesResource.class)).Program(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().description(text.programRootNodeDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_ROWS, FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end(3).end(1).label(this.imageBelow(text.nodeList(), ProgramImageResource.nodeList()), new FormBuilder.PanelConstraints[]{spanForImages}).label(this.imageBelow(text.programTree(), ProgramImageResource.programTree()), new FormBuilder.PanelConstraints[]{spanForImages}).end(12).end(3).component((JComponent)options, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS, FormBuilder.PanelConstraints.SPAN_3_ROWS}).end(3).groupColumns(new int[]{1, 3, 4}).setOnPanel((JPanel)((Object)this));
        this.addBeforeStartSequenceCheckBox.addItemListener(evt -> this.addBeforeStartSequence());
        this.setInitialVariableValuesCheckBox.addItemListener(evt -> this.setInitialVariableValues());
        this.loopForeverCheckbox.addItemListener(evt -> ((MainProgram)this.getNode()).setRunOnlyOnce(!this.loopForeverCheckbox.isSelected()));
    }

    private JLabel imageBelow(String s, Icon icon) {
        JLabel result = new JLabel(HTML.html((String)HTML.fontBold((String)s)), icon, 0);
        result.setVerticalTextPosition(1);
        result.setHorizontalTextPosition(0);
        result.setBorder(BorderFactory.createEmptyBorder());
        return result;
    }

    private void setInitialVariableValues() {
        ProgramRootNode programRootNode = ProgramRootNode.get((AbstractProgramNode)((AbstractProgramNode)this.getNode()));
        boolean selected = this.setInitialVariableValuesCheckBox.isSelected();
        ((MainProgram)this.getNode()).setInitVarsEnabled(selected);
        if (selected == programRootNode.hasInitVariables()) {
            return;
        }
        if (selected) {
            this.insertNodeStrategy.insertChild((AbstractProgramNode)this.entityFactory.createInitVariablesNode(), (AbstractProgramNode)programRootNode.getFirstChild(), 0);
        } else {
            this.deleteNodeAction.execute((AbstractProgramNode)programRootNode.getFirstChild());
            ((ProgramSelectionModel)programRootNode.getComponent(ProgramSelectionModel.class)).setSelected((AbstractProgramNode)programRootNode.getMainProgram());
        }
    }

    private void addBeforeStartSequence() {
        ProgramRootNode programRootNode = ProgramRootNode.get((AbstractProgramNode)((AbstractProgramNode)this.getNode()));
        boolean selected = this.addBeforeStartSequenceCheckBox.isSelected();
        if (selected == programRootNode.hasBeforeStart()) {
            return;
        }
        if (selected) {
            this.insertNodeStrategy.insertChild((AbstractProgramNode)this.entityFactory.createBeforeStartNode(), (AbstractProgramNode)this.getNode(), programRootNode.getIndex((TreeNode)this.getNode()));
        } else {
            this.deleteNodeAction.execute((AbstractProgramNode)programRootNode.getBeforeStart());
            ((ProgramSelectionModel)programRootNode.getComponent(ProgramSelectionModel.class)).setSelected((AbstractProgramNode)programRootNode.getMainProgram());
        }
    }
}

