/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.resources.ViewImageResource;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.TextProvider;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.AutoCorrectionValidator;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.VariableLookupService;
import gui.commandpanels.TimerCard;
import gui.program.EntityFactory;
import gui.program.TimerNode;
import gui.program.validation.TimerNodeValidationStrategyProvider;
import gui.swing.renderers.VariableRenderingStrategy;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.inject.Inject;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TimerCardImpl
extends TimerCard {
    private HelpIdAssigner helpIdAssigner;

    @Inject
    public TimerCardImpl(VariableLookupService lookupService, TimerNodeValidationStrategyProvider timerNodeValidationStrategyProvider, EntityFactory entityFactory, ViewContext viewContext) {
        super(timerNodeValidationStrategyProvider, entityFactory, lookupService, viewContext);
        this.helpIdAssigner = viewContext.getHelpIdAssigner();
        this.initCard();
        this.bindCardComponents(timerNodeValidationStrategyProvider);
    }

    private void initCard() {
        WidgetFactory widgetFactory = this.getViewContext().createWidgetFactory();
        this.variableDropDown = widgetFactory.createComboBox();
        this.variableDropDown.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TimerCardImpl.this.variableSelectorComboBoxActionPerformed();
            }
        });
        this.renameVariableButton = widgetFactory.createButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerCardImpl.this.variableSelectorComboBoxActionPerformed();
            }
        });
        this.radioButtons = new EnumButtonGroup(TimerNode.TimerAction.class);
        this.noneSelectedInvisibleRadioButton = new JRadioButton();
        this.noneSelectedInvisibleRadioButton.setText("iAmInvisible");
        this.radioButtons.add((Enum)TimerNode.TimerAction.UNDEFINED, (AbstractButton)this.noneSelectedInvisibleRadioButton);
        this.startButton = widgetFactory.createRadioButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerCardImpl.this.timerActionSelectedActionPerformed(TimerNode.TimerAction.START);
            }
        });
        TextResource textResource = (TextResource)this.getViewContext().getTextResource(TextResource.class);
        this.startButton.setText(textResource.StartTimer());
        this.startButton.setName(TimerCard.START_TIMER);
        this.radioButtons.add((Enum)TimerNode.TimerAction.START, (AbstractButton)this.startButton);
        this.stopButton = widgetFactory.createRadioButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerCardImpl.this.timerActionSelectedActionPerformed(TimerNode.TimerAction.STOP);
            }
        });
        this.stopButton.setText(textResource.StopTimer());
        this.stopButton.setName(TimerCard.STOP_TIMER);
        this.radioButtons.add((Enum)TimerNode.TimerAction.STOP, (AbstractButton)this.stopButton);
        this.resetButton = widgetFactory.createRadioButton((Action)new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TimerCardImpl.this.timerActionSelectedActionPerformed(TimerNode.TimerAction.RESET);
            }
        });
        this.resetButton.setText(textResource.ResetTimer());
        this.resetButton.setName(TimerCard.RESET_TIMER);
        this.radioButtons.add((Enum)TimerNode.TimerAction.RESET, (AbstractButton)this.resetButton);
        this.buildPanels();
    }

    private void bindCardComponents(TimerNodeValidationStrategyProvider timerNodeValidationStrategyProvider) {
        ComboBoxRenderer.bindRenderer((JComboBox)this.variableDropDown, (RenderingStrategy)new VariableRenderingStrategy());
        TextHolder provider = new TextHolder(){

            public String getText() {
                return ((TimerNode)TimerCardImpl.this.getNode()).getVariableName();
            }

            public void setText(String text) {
                ((TimerNode)TimerCardImpl.this.getNode()).setVariableName(text);
                TimerCardImpl.this.updateCard();
            }
        };
        TextProvider variableNameProvider = this.createCardVariableNameProvider();
        AutoCorrectionValidator variableNameValidator = timerNodeValidationStrategyProvider.getVariableNameValidator(variableNameProvider, Variable.class);
        TextFieldUtils.bindTextPicker((JComponent)this.renameVariableButton, (TextHolder)provider, (ValidationStrategy)variableNameValidator);
        this.variableDropDown.setName(TimerCard.VARIABLE_SELECTOR);
        this.renameVariableButton.setName(TimerCard.RENAME_VARIABLE);
        this.helpIdAssigner.assignHelpId((JComponent)((Object)this), "gui:command_timer");
    }

    private TextProvider createCardVariableNameProvider() {
        return new TextProvider(){

            public String getText() {
                if (TimerCardImpl.this.getNode() != null) {
                    return ((TimerNode)TimerCardImpl.this.getNode()).getVariableName();
                }
                return "";
            }
        };
    }

    private void buildPanels() {
        this.setLayout(new BorderLayout());
        this.renameVariableButton.setIcon(ViewImageResource.rename());
        this.renameVariableButton.setPreferredSize(new Dimension(64, 32));
        this.variableDropDown.setPreferredSize(new Dimension(190, 32));
        FormBuilder formBuilder = this.getViewContext().createFormBuilder();
        JPanel variableRenameSelectPanel = new JPanel();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(7);
        variableRenameSelectPanel.setLayout(borderLayout);
        variableRenameSelectPanel.add((Component)this.renameVariableButton, "West");
        variableRenameSelectPanel.add((Component)this.variableDropDown, "Center");
        JPanel header = formBuilder.headerLabel(((CommandNamesResource)this.getViewContext().getTextResource(CommandNamesResource.class)).Timer(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().description(((TextResource)this.getViewContext().getTextResource(TextResource.class)).timerDescription(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().end().component((JComponent)variableRenameSelectPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).spacer(2).end().spacer().end().component((JComponent)this.startButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.stopButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.resetButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().getPanel();
        this.add(header, "Center");
    }
}

