/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.infrastructure.waitnode;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.program.nodes.infrastructure.waitnode.WaitNodeViewPart;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import gui.commandpanels.WaitCard;
import gui.program.WaitNode;
import gui.program.validation.WaitNodeValidationStrategyProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.text.Format;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class TimerWaitPanel
extends JPanel
implements WaitNodeViewPart {
    private final NumberField timeInSeconds;
    private final ActionListener timeInSecondsActionListener;
    private final ItemListener selectionItemListener;
    private final ActionListener selectionActionListener;
    private WaitNode waitNode;
    private JRadioButton selection;
    private EnumButtonGroup<WaitNode.Type> waitButtonGroup;

    @Inject
    public TimerWaitPanel(ViewContext viewContext, WaitNodeValidationStrategyProvider waitNodeValidationStrategyProvider) {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.selection = new JRadioButton();
        this.selection.setText(((TextResource)viewContext.getTextResource(TextResource.class)).waitXxx());
        this.selection.setName(WaitCard.WAIT_TIME);
        this.selectionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TimerWaitPanel.this.selection.isSelected()) {
                    TimerWaitPanel.this.waitNode.setTypeAndResetOthers(WaitNode.Type.TIMER_WAIT);
                } else {
                    TimerWaitPanel.this.timeInSeconds.setValue((Object)TimerWaitPanel.this.waitNode.getWaitTime());
                }
            }
        };
        this.selectionItemListener = e -> {
            if (e.getStateChange() == 2 && this.waitNode != null) {
                this.waitNode.setWaitTime(0.01);
            }
        };
        this.timeInSeconds = new NumberField();
        this.timeInSeconds.setName(WaitCard.INPUT_WAIT_TIME_IN_SECONDS);
        this.timeInSeconds.setHorizontalAlignment(11);
        this.timeInSeconds.setValue((Object)0.01);
        this.timeInSeconds.setPreferredSize(new Dimension(170, 28));
        this.timeInSeconds.setUnit(Units.getText().unitSeconds());
        this.timeInSeconds.setMode(Mode.PositiveNumbers);
        this.timeInSeconds.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0##"));
        this.timeInSeconds.setUnitWidth(80);
        this.timeInSeconds.setErrorValidationStrategy(new ValidationStrategy[]{waitNodeValidationStrategyProvider.getWaitTimeValidator()});
        this.timeInSecondsActionListener = e -> {
            this.waitNode.setWaitTimeAndType(((Double)this.timeInSeconds.getValue()).doubleValue());
            this.waitButtonGroup.select((Enum)WaitNode.Type.TIMER_WAIT);
        };
        this.add(this.selection);
        this.add((Component)this.timeInSeconds);
    }

    public void enter(WaitNode waitNode) {
        this.waitNode = waitNode;
        this.timeInSeconds.setValue((Object)waitNode.getWaitTime());
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
        this.waitNode = null;
    }

    private void addListeners() {
        this.timeInSeconds.addActionListener(this.timeInSecondsActionListener);
        this.selection.addActionListener(this.selectionActionListener);
        this.selection.addItemListener(this.selectionItemListener);
    }

    private void removeListeners() {
        this.selection.removeItemListener(this.selectionItemListener);
        this.selection.removeActionListener(this.selectionActionListener);
        this.timeInSeconds.removeActionListener(this.timeInSecondsActionListener);
    }

    public void setButtonGroup(EnumButtonGroup<WaitNode.Type> waitButtonGroup) {
        this.waitButtonGroup = waitButtonGroup;
        waitButtonGroup.add((Enum)WaitNode.Type.TIMER_WAIT, (AbstractButton)this.selection);
    }

    public JComponent getPanel() {
        return this;
    }
}

