/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.infrastructure.waitnode;

import com.ur.i18n.CommandNamesResource;
import com.ur.i18n.TextResource;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.nodes.infrastructure.waitnode.WaitNodeViewPart;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import gui.commandpanels.WaitCard;
import gui.program.WaitNode;
import java.util.Map;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WaitCardImpl
extends WaitCard {
    private final Map<WaitNode.Type, WaitNodeViewPart> waitConditions;
    private ViewContext viewContext;
    private EnumButtonGroup<WaitNode.Type> waitButtonGroup;

    @Inject
    public WaitCardImpl(ViewContext viewContext, Map<WaitNode.Type, WaitNodeViewPart> waitConditions) {
        this.waitConditions = waitConditions;
        this.viewContext = viewContext;
        this.initComponents();
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_wait");
    }

    public void enter(Object o) {
        super.enter(o);
        this.waitButtonGroup.select((Enum)((WaitNode)this.getNode()).getType());
        for (WaitNode.Type each : this.waitConditions.keySet()) {
            this.waitConditions.get(each).enter((AbstractProgramNode)((WaitNode)this.getNode()));
        }
    }

    public Object exit() {
        for (WaitNode.Type each : this.waitConditions.keySet()) {
            this.waitConditions.get(each).exit();
        }
        return super.exit();
    }

    protected void updateCard() {
    }

    private void initComponents() {
        this.waitButtonGroup = new EnumButtonGroup(WaitNode.Type.class);
        JRadioButton noneSelectedInvisibleRadioButton = new JRadioButton();
        noneSelectedInvisibleRadioButton.setText("iAmInvisible");
        this.waitButtonGroup.add((Enum)WaitNode.Type.UNDEFINED, (AbstractButton)noneSelectedInvisibleRadioButton);
        JPanel viewParts = this.viewContext.createWidgetFactory().verticalPanel(5);
        WaitNode.Type[] typeArray = WaitNode.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            WaitNode.Type each = typeArray[n2];
            if (this.waitConditions.containsKey(each)) {
                WaitNodeViewPart selection = this.waitConditions.get(each);
                selection.setButtonGroup(this.waitButtonGroup);
                viewParts.add(selection.getPanel());
            }
            ++n2;
        }
        this.viewContext.createFormBuilder().headerLabel(((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Wait(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().description(((TextResource)this.viewContext.getTextResource(TextResource.class)).commandWait(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(2).component((JComponent)viewParts, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_10_ROWS, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(11).setOnPanel((JPanel)((Object)this));
    }
}

