/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.infrastructure.waitnode;

import com.ur.i18n.TextResource;
import com.ur.program.nodes.infrastructure.waitnode.WaitNodeViewPart;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import gui.commandpanels.WaitCard;
import gui.program.WaitNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WaitForExpressionViewPart
extends JPanel
implements WaitNodeViewPart {
    private final ActionListener selectionActionListener;
    private final ItemListener selectionItemListener;
    private final ActionListener expressionChangedListener;
    private EnumButtonGroup<WaitNode.Type> waitButtonGroup;
    private ExpressionField expression;
    private JRadioButton selection;
    private WaitNode waitNode;

    @Inject
    public WaitForExpressionViewPart(ViewContext viewContext, ExpressionField expressionEditor) {
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setBorder(BorderFactory.createEmptyBorder());
        this.selection = new JRadioButton();
        this.selection.setName("waitOnExpressoin.waitCard");
        this.selection.setText(((TextResource)viewContext.getTextResource(TextResource.class)).waitForAnalogInput());
        this.selectionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitForExpressionViewPart.this.waitNode.setTypeAndResetOthers(WaitNode.Type.EXPRESSION_WAIT);
            }
        };
        this.selectionItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 2) {
                    WaitForExpressionViewPart.this.expression.setNodeWithExpression((ExpressionNodeProperty)WaitForExpressionViewPart.this.waitNode);
                } else {
                    WaitForExpressionViewPart.this.waitNode.setTypeAndResetOthers(WaitNode.Type.EXPRESSION_WAIT);
                }
            }
        };
        this.expression = expressionEditor;
        this.expression.setName(WaitCard.INPUT_WAIT_EXPRESSION);
        this.expression.setHorizontalAlignment(0);
        this.expression.setPreferredSize(new Dimension(480, 28));
        this.expressionChangedListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                WaitForExpressionViewPart.this.waitNode.setType(WaitNode.Type.EXPRESSION_WAIT);
                WaitForExpressionViewPart.this.waitButtonGroup.select((Enum)WaitNode.Type.EXPRESSION_WAIT);
                if (WaitForExpressionViewPart.this.waitNode.getExpression() == null) {
                    WaitForExpressionViewPart.this.waitNode.setExpression(null);
                }
                WaitForExpressionViewPart.this.waitNode.textHasChanged();
            }
        };
        this.add(this.selection);
        this.add((Component)this.expression);
    }

    public void enter(WaitNode waitNode) {
        this.waitNode = waitNode;
        this.expression.setNodeWithExpression((ExpressionNodeProperty)waitNode);
        if (!this.selection.isSelected()) {
            this.expression.setBackground(Color.WHITE);
        }
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.selection.addActionListener(this.selectionActionListener);
        this.selection.addItemListener(this.selectionItemListener);
        this.expression.addActionListener(this.expressionChangedListener);
    }

    private void removeListeners() {
        this.expression.removeActionListener(this.expressionChangedListener);
        this.selection.removeItemListener(this.selectionItemListener);
        this.selection.removeActionListener(this.selectionActionListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<WaitNode.Type> waitButtonGroup) {
        this.waitButtonGroup = waitButtonGroup;
        this.waitButtonGroup.add((Enum)WaitNode.Type.EXPRESSION_WAIT, (AbstractButton)this.selection);
    }
}

