/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.setnode.infrastructure;

import com.ur.program.internal.TextResource;
import com.ur.program.nodes.setnode.infrastructure.SetNodeViewPart;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.validation.ValidationFactory;
import com.ur.view.variables.InstallationVariableReference;
import com.ur.view.variables.core.InstallationVariable;
import com.ur.view.variables.core.Variable;
import com.ur.view.variables.domain.InstallationVariables;
import gui.installation.RobotInstallationLookupService;
import gui.program.services.ProgramReferenceService;
import gui.program.setnode.SetNode;
import gui.swing.renderers.VariableComboBoxModel;
import gui.swing.renderers.VariableRenderingStrategy;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class IncrementVariableViewPart
extends JPanel
implements SetNodeViewPart {
    private final ViewContext viewContext;
    private final RobotInstallationLookupService installationLookupService;
    private final ProgramReferenceService programReferenceService;
    private final ActionListener incrementVariableSelectionActionListener;
    private JRadioButton setVariableIncrement;
    private JComboBox incrementVariableSelection;
    private EnumButtonGroup<SetNode.Type> buttonGroup;
    private SetNode node;
    private ItemListener setVariableIncrementItemListener;

    @Inject
    public IncrementVariableViewPart(ViewContext viewContext, RobotInstallationLookupService installationLookupService, ProgramReferenceService programReferenceService) {
        this.viewContext = viewContext;
        this.installationLookupService = installationLookupService;
        this.programReferenceService = programReferenceService;
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setVariableIncrement = new JRadioButton();
        this.setVariableIncrement.setName("ActionCard.incrementSelectionId");
        this.setVariableIncrement.setText(((TextResource)viewContext.getTextResource(TextResource.class)).actionCardIncrementInstallationVariableWithOne());
        this.setVariableIncrementItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    IncrementVariableViewPart.this.node.setTypeAndResetOthers(SetNode.Type.INCREMENT_VARIABLE);
                }
            }
        };
        this.incrementVariableSelection = new ComboBox();
        this.incrementVariableSelection.setName("ActionCard.incrementVariableSelectionId");
        this.incrementVariableSelection.setPreferredSize(new Dimension(200, 28));
        this.incrementVariableSelection.setPrototypeDisplayValue("XXXXXXXXXXXXXXX");
        ComboBoxRenderer.bindRenderer((JComboBox)this.incrementVariableSelection, (RenderingStrategy)new VariableRenderingStrategy());
        this.incrementVariableSelectionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IncrementVariableViewPart.this.updateSelectedVariable();
            }
        };
        this.add(this.setVariableIncrement);
        this.add(this.incrementVariableSelection);
    }

    public void enter(SetNode node) {
        this.node = node;
        VariableComboBoxModel variableSelectionModel = new VariableComboBoxModel();
        variableSelectionModel.addElement((Object)((TextResource)this.viewContext.getTextResource(TextResource.class)).placeholderVariable());
        for (InstallationVariable each : ((InstallationVariables)this.installationLookupService.getInstallation().getComponent(InstallationVariables.class)).getInstallationVariables()) {
            if (!ValidationFactory.getNumberValidator().isValid(each.getValue())) continue;
            variableSelectionModel.addElement((Object)this.programReferenceService.getInstallationVariableReference(each));
        }
        this.incrementVariableSelection.setModel(variableSelectionModel);
        if (node.getVariable() == null) {
            variableSelectionModel.setSelectedItem(variableSelectionModel.getElementAt(0));
        } else {
            variableSelectionModel.selectVariable((Variable)node.getVariable());
        }
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.setVariableIncrement.addItemListener(this.setVariableIncrementItemListener);
        this.incrementVariableSelection.addActionListener(this.incrementVariableSelectionActionListener);
    }

    private void removeListeners() {
        this.setVariableIncrement.removeItemListener(this.setVariableIncrementItemListener);
        this.incrementVariableSelection.removeActionListener(this.incrementVariableSelectionActionListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<SetNode.Type> buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((Enum)SetNode.Type.INCREMENT_VARIABLE, (AbstractButton)this.setVariableIncrement);
    }

    private void updateSelectedVariable() {
        Object selectedItem = this.incrementVariableSelection.getSelectedItem();
        if (selectedItem instanceof InstallationVariableReference) {
            this.node.setVariableAndType((InstallationVariableReference)selectedItem);
            this.buttonGroup.select((Enum)SetNode.Type.INCREMENT_VARIABLE);
        } else if (this.node.getVariable() != null) {
            this.node.setVariable(null);
        }
    }
}

