/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.setnode.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.program.nodes.setnode.infrastructure.SetNodeViewPart;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.units.UnitsConverter;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import gui.program.setnode.SetNode;
import gui.program.validation.SetNodeValidationStrategyProvider;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemListener;
import java.text.Format;
import java.util.Arrays;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SetAnalogOutputViewPart
extends JPanel
implements SetNodeViewPart {
    public static final int _4_TO_20mA = 0;
    private final ViewContext viewContext;
    private final IOService ioLookupService;
    private final SetNodeValidationStrategyProvider setNodeValidationStrategyProvider;
    private final ActionListener analogOutputSelectionActionListener;
    private final ItemListener setAnalogOutputRadioButtonItemListener;
    private final ActionListener analogValueActionListener;
    private JRadioButton setAnalogOutputRadioButton;
    private JComboBox analogOutputSelection;
    private NumberField analogValue;
    private SetNode node;
    private EnumButtonGroup<SetNode.Type> buttonGroup;

    @Inject
    public SetAnalogOutputViewPart(ViewContext viewContext, IOService ioLookupService, SetNodeValidationStrategyProvider setNodeValidationStrategyProvider) {
        this.viewContext = viewContext;
        this.ioLookupService = ioLookupService;
        this.setNodeValidationStrategyProvider = setNodeValidationStrategyProvider;
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setAnalogOutputRadioButton = new JRadioButton();
        this.setAnalogOutputRadioButton.setName("ActionCard.analogOutput");
        this.setAnalogOutputRadioButton.setText(((TextResource)viewContext.getTextResource(TextResource.class)).setAnalogOutput());
        this.setAnalogOutputRadioButtonItemListener = evt -> {
            if (evt.getStateChange() == 1) {
                this.node.setTypeAndResetOthers(SetNode.Type.ANALOG_OUTPUT_ACTION);
            }
        };
        this.analogOutputSelection = new ComboBox();
        this.analogOutputSelection.setName("ActionCard.analogOutputSelection");
        this.analogOutputSelection.setModel(new DefaultComboBoxModel<String>(new String[]{"initialization...", " "}));
        this.analogOutputSelection.setPreferredSize(new Dimension(200, 28));
        this.analogOutputSelectionActionListener = evt -> this.analogOutputSelectionActionPerformed();
        PinRenderingStrategy pinRenderingStrategy = new PinRenderingStrategy();
        ComboBoxRenderer.bindRenderer((JComboBox)this.analogOutputSelection, (RenderingStrategy)pinRenderingStrategy);
        this.analogValue = new NumberField((ValueConverter)new ValueConverter.DoubleConverter(UnitsConverter.NULL_CONVERTER));
        this.analogValue.setName("ActionCard.analogValue");
        this.analogValue.setHorizontalAlignment(11);
        this.analogValue.setText("0.0");
        this.analogValue.setPreferredSize(new Dimension(120, 28));
        this.analogValue.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.0"));
        this.analogValue.setUnit(Units.getText().unitMa());
        this.analogValue.setName("ActionCard.analogValue");
        this.analogValueActionListener = e -> this.node.setAnalogValue(((Double)this.analogValue.getValue()).doubleValue());
        this.add(this.setAnalogOutputRadioButton);
        this.add(this.analogOutputSelection);
        this.add((Component)this.analogValue);
    }

    public void enter(SetNode node) {
        this.node = node;
        this.analogValue.setEnabled(node.getAnalogOutput() != null);
        this.analogValue.setValue((Object)node.getAnalogValue());
        PinComboBoxModel model = new PinComboBoxModel();
        model.addElement((Object)((TextResource)this.viewContext.getTextResource(TextResource.class)).tokenAnalogOutputAbbrev());
        model.addAllElements(this.ioLookupService.getStandardAnalogOutputPins());
        model.addAllElements((Iterable)this.ioLookupService.getCustomAnalogOutputPins());
        model.addAllElements((Iterable)CollectionUtils.filter(Arrays.asList(this.ioLookupService.getGeneralPurposeFloatOutputRegisters()), (Predicate)new IOService.WithUserDefinedName()));
        this.analogOutputSelection.setModel(model);
        if (node.getAnalogPinReference() == null) {
            this.analogOutputSelection.setSelectedIndex(0);
        } else {
            model.selectPinReference(node.getAnalogPinReference());
        }
        if (this.analogOutputSelection.getSelectedItem() instanceof Register) {
            this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{ValidationFactory.getNumberValidator()});
            this.analogValue.setMode(Mode.Standard);
        } else if (this.analogOutputSelection.getSelectedItem() instanceof AnalogIOPin) {
            if (node.getAnalogOutputDomain() == 0) {
                this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{this.setNodeValidationStrategyProvider.getElectricalCurrentValidator()});
            } else {
                this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{this.setNodeValidationStrategyProvider.getElectricalPotentialValidator()});
            }
            this.analogValue.setMode(Mode.PositiveNumbers);
        }
        this.updateAnalogUnitLabel();
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.analogOutputSelection.addActionListener(this.analogOutputSelectionActionListener);
        this.setAnalogOutputRadioButton.addItemListener(this.setAnalogOutputRadioButtonItemListener);
        this.analogValue.addActionListener(this.analogValueActionListener);
    }

    private void removeListeners() {
        this.analogValue.removeActionListener(this.analogValueActionListener);
        this.setAnalogOutputRadioButton.removeItemListener(this.setAnalogOutputRadioButtonItemListener);
        this.analogOutputSelection.removeActionListener(this.analogOutputSelectionActionListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<SetNode.Type> buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((Enum)SetNode.Type.ANALOG_OUTPUT_ACTION, (AbstractButton)this.setAnalogOutputRadioButton);
    }

    private void updateAnalogUnitLabel() {
        if (this.node.getAnalogOutput() == null) {
            this.analogValue.setUnit(Units.getText().unitMa());
        } else if (this.node.getAnalogOutput() instanceof AnalogIOPin) {
            if (((AnalogIOPin)this.node.getAnalogOutput()).getAnalogOutputDomain() == 0) {
                this.analogValue.setUnit(Units.getText().unitMa());
            } else {
                this.analogValue.setUnit(Units.getText().unitVolts());
            }
        } else {
            this.analogValue.setUnit("");
        }
    }

    private void analogOutputSelectionActionPerformed() {
        if (this.analogOutputSelection.getSelectedItem() instanceof Pin) {
            Pin selectAnalogOutput = (Pin)this.analogOutputSelection.getSelectedItem();
            this.node.setAnalogOutputAndType(selectAnalogOutput);
            this.buttonGroup.select((Enum)SetNode.Type.ANALOG_OUTPUT_ACTION);
        } else if (this.node.getAnalogOutput() != null) {
            this.node.setAnalogOutput(null);
        }
    }
}

