/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.setnode.infrastructure;

import com.ur.i18n.CommandNamesResource;
import com.ur.lang.EqualsUtil;
import com.ur.polyscope.application.ViewComponent;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.internal.TextResource;
import com.ur.program.nodes.setnode.infrastructure.SetNodeViewPart;
import com.ur.resources.ViewImageResource;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.g5.G5LookAndFeel;
import gui.commandpanels.SetCard;
import gui.program.setnode.SetNode;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;

public class SetCardImpl
extends SetCard {
    private static final int VERTICAL_VIEW_PARTS_GAP_PX = 0;
    private final ViewContext viewContext;
    private final Map<SetNode.Type, SetNodeViewPart> viewParts;
    private final ViewComponent payloadComponent;
    private final ViewComponent tcpComponent;
    private EnumButtonGroup buttonGroup;
    private JButton performActionButton;
    private JComponent payloadComponentView;
    private JPanel tcpPanel;
    private JComponent tcpComponentView;
    private TextResource textResource;
    private JLabel payloadHint;

    @Inject
    public SetCardImpl(ViewContext viewContext, Map<SetNode.Type, SetNodeViewPart> viewParts, @Named(value="payload-with-cog") @Named(value="payload-with-cog") ViewComponent payloadComponent, @Named(value="tcp-reference") @Named(value="tcp-reference") ViewComponent tcpComponent) {
        this.viewContext = viewContext;
        this.viewParts = viewParts;
        this.payloadComponent = payloadComponent;
        this.tcpComponent = tcpComponent;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.initComponents();
        this.bindComponents(payloadComponent, tcpComponent);
        this.assignHelpIds();
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_action");
    }

    public void enter(Object o) {
        this.enteringCard = true;
        super.enter(o);
        SetNode node = (SetNode)this.getNode();
        this.payloadComponent.setDomain(node.getPayloadWithCog());
        this.updateTCPPanel();
        this.tcpComponent.setDomain(node.getTcpReference());
        this.buttonGroup.select((Enum)((SetNode)this.getNode()).getType());
        for (SetNodeViewPart each : this.viewParts.values()) {
            each.enter((AbstractProgramNode)((SetNode)this.getNode()));
        }
        this.enteringCard = false;
    }

    public Object exit() {
        for (SetNodeViewPart each : this.viewParts.values()) {
            each.exit();
        }
        return super.exit();
    }

    public void updateCard() {
        if (this.updated) {
            SetNode node = (SetNode)this.getNode();
            this.payloadComponent.setDomain(node.getPayloadWithCog());
            this.tcpComponent.setDomain(node.getTcpReference());
            this.updateTCPPanel();
            boolean hasAction = EqualsUtil.equalsOneOf((Object)node.getType(), (Object[])new SetNode.Type[]{SetNode.Type.DIGITAL_OUTPUT_ACTION, SetNode.Type.ANALOG_OUTPUT_ACTION, SetNode.Type.EXPRESSION_OUTPUT_ACTION});
            boolean hasPayloadEnabled = node.getPayloadWithCog().isEnabled();
            boolean hasSetTcpEnabled = node.getTcpReference().isEnabled();
            this.performActionButton.setEnabled(!node.isUndefined() && (hasAction || hasPayloadEnabled || hasSetTcpEnabled));
        }
    }

    private void initComponents() {
        this.buttonGroup = new EnumButtonGroup(SetNode.Type.class);
        JRadioButton invisibleRadioButton = new JRadioButton();
        this.buttonGroup.add((Enum)SetNode.Type.UNDEFINED, (AbstractButton)invisibleRadioButton);
        JPanel setViewParts = this.viewContext.createWidgetFactory().verticalPanel(0);
        SetNode.Type[] typeArray = SetNode.Type.values();
        int n = typeArray.length;
        int n2 = 0;
        while (n2 < n) {
            SetNode.Type each = typeArray[n2];
            if (this.viewParts.containsKey(each)) {
                SetNodeViewPart viewPart = this.viewParts.get(each);
                viewPart.setButtonGroup(this.buttonGroup);
                setViewParts.add(viewPart.getPanel());
            }
            ++n2;
        }
        this.performActionButton = new JButton(this.textResource.testNode());
        this.performActionButton.setName("ActionCard.testNode");
        this.performActionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (!((SetNode)SetCardImpl.this.getNode()).isUndefined()) {
                    ((SetNode)SetCardImpl.this.getNode()).sendActionCommand();
                }
            }
        });
        JPanel actionCardPanel = this.viewContext.createFormBuilder().headerLabel(((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Action(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().description(this.textResource.commandAction(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_ROWS, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(2).component((JComponent)setViewParts, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.FILL_ROWS, FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end(11).getPanel();
        this.setupTcpPayloadPanel();
        JPanel bottomPanel = new JPanel();
        JLabel testButtonLabel = new JLabel();
        testButtonLabel.setPreferredSize(new Dimension(400, 50));
        bottomPanel.add(Box.createHorizontalStrut(20));
        bottomPanel.add(testButtonLabel);
        bottomPanel.add(Box.createHorizontalGlue());
        JPanel testButtonPanel = new JPanel(new FlowLayout(0, 20, 0));
        testButtonPanel.setBorder(new EmptyBorder(10, 0, 10, 20));
        this.performActionButton.setPreferredSize(new Dimension(200, 50));
        testButtonPanel.add(this.performActionButton);
        bottomPanel.add(testButtonPanel);
        bottomPanel.add(Box.createHorizontalGlue());
        this.setBackground(G5LookAndFeel.BETWEEN_CARD_COLOR);
        this.setLayout(new BorderLayout(0, 5));
        this.add(actionCardPanel, "North");
        this.add(this.tcpPanel, "Center");
        this.add(bottomPanel, "South");
    }

    private void setupTcpPayloadPanel() {
        this.payloadComponentView = this.payloadComponent.asComponent();
        this.tcpComponentView = this.tcpComponent.asComponent();
        this.payloadHint = new JLabel(this.textResource.useNewPayloadNode(), ViewImageResource.formInformation(), 10);
        this.tcpPanel = new JPanel();
        this.tcpPanel.setLayout(new BoxLayout(this.tcpPanel, 3));
    }

    private void updateTCPPanel() {
        this.tcpPanel.removeAll();
        if (this.showPayloadObject((SetNode)this.getNode())) {
            this.tcpPanel.add(this.createPayloadTCPPanelWithPayloadHint());
            this.disablePanel(this.payloadComponentView);
        } else {
            this.tcpPanel.add(this.createTCPPanelWithPayloadHint());
        }
    }

    private boolean showPayloadObject(SetNode node) {
        return node.getPayloadWithCog().isEnabled();
    }

    private JPanel createTCPPanelWithPayloadHint() {
        return this.viewContext.createFormBuilder().label(this.payloadHint, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().component(this.tcpComponentView, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().getPanel();
    }

    private JPanel createPayloadTCPPanelWithPayloadHint() {
        return this.viewContext.createFormBuilder().label(this.payloadHint, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component(this.payloadComponentView, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(2).end().component(this.tcpComponentView, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().end().getPanel();
    }

    private void disablePanel(JComponent panel) {
        Component[] components;
        panel.setEnabled(false);
        Component[] componentArray = components = panel.getComponents();
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JPanel) {
                this.disablePanel((JPanel)component);
            }
            component.setEnabled(false);
            ++n2;
        }
    }
}

