/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.setnode.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.program.nodes.setnode.infrastructure.DigitalLowHiComboBoxModel;
import com.ur.program.nodes.setnode.infrastructure.DigitalPinComboBoxModel;
import com.ur.program.nodes.setnode.infrastructure.SetNodeViewPart;
import com.ur.program.nodes.setnode.infrastructure.UseSteppedComboBox;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import gui.program.setnode.SetNode;
import gui.swing.renderers.PinRenderingStrategy;
import gui.tools.BoundsPopupMenuListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SetDigitalOutputViewPart
extends JPanel
implements SetNodeViewPart {
    private final ItemListener setDigitalOutputRadioButtonItemListener;
    private final ActionListener digitalOutputSelectionActionListener;
    private final ActionListener digitalValueActionListener;
    private EnumButtonGroup<SetNode.Type> buttonGroup;
    private JRadioButton setDigitalOutputRadioButton;
    private JComboBox digitalOutputSelection;
    private JComboBox digitalValue;
    private SetNode setNode;
    private DigitalPinComboBoxModel digitalPinComboBoxModel;
    private final UseSteppedComboBox useSteppedComboBox;
    private TextResource textResource;
    private static final int MAXIMUM_ROW_COUNT = 9;

    @Inject
    public SetDigitalOutputViewPart(ViewContext viewContext, DigitalPinComboBoxModel digitalPinComboBoxModel, UseSteppedComboBox useSteppedComboBox) {
        this.digitalPinComboBoxModel = digitalPinComboBoxModel;
        this.useSteppedComboBox = useSteppedComboBox;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setDigitalOutputRadioButton = new JRadioButton();
        this.setDigitalOutputRadioButton.setName("ActionCard.digitalOutput");
        this.setDigitalOutputRadioButton.setText(this.textResource.setDigitalOutput());
        this.setDigitalOutputRadioButtonItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    SetDigitalOutputViewPart.this.setNode.setTypeAndResetOthers(SetNode.Type.DIGITAL_OUTPUT_ACTION);
                }
            }
        };
        this.digitalOutputSelection = new ComboBox();
        PinRenderingStrategy pinRenderingStrategy = new PinRenderingStrategy();
        ComboBoxRenderer.bindRenderer((JComboBox)this.digitalOutputSelection, (RenderingStrategy)pinRenderingStrategy);
        this.digitalOutputSelection.setName("ActionCard.digitalOutputSelection");
        this.digitalOutputSelection.setModel(digitalPinComboBoxModel);
        this.digitalOutputSelection.setPreferredSize(new Dimension(200, 28));
        this.digitalOutputSelectionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetDigitalOutputViewPart.this.selectSignal(SetDigitalOutputViewPart.this.digitalOutputSelection.getSelectedItem());
            }
        };
        this.digitalValue = new JComboBox();
        this.digitalValue.setModel(new DigitalLowHiComboBoxModel(this.textResource));
        this.digitalValue.setPreferredSize(new Dimension(100, 28));
        this.digitalValue.setName("ActionCard.digitalOutputValue");
        this.digitalValueActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetDigitalOutputViewPart.this.digitalValueActionPerformed();
            }
        };
        this.add(this.setDigitalOutputRadioButton);
        this.add(this.digitalOutputSelection);
        this.add(this.digitalValue);
    }

    public void enter(SetNode setNode) {
        this.setNode = setNode;
        PinReference selectedDigitalOutput = setNode.getDigitalPinReference();
        this.digitalPinComboBoxModel.initializeAndSelect(selectedDigitalOutput);
        this.digitalValue.setSelectedIndex(setNode.getDigitalValue());
        this.digitalValue.setEnabled(setNode.getType().equals((Object)SetNode.Type.DIGITAL_OUTPUT_ACTION) && setNode.getDigitalOutput() != null);
        boolean immiEnabled = this.useSteppedComboBox.isSteppedComboBox();
        BoundsPopupMenuListener.enableOnComboBox((JComboBox)this.digitalOutputSelection, (boolean)immiEnabled);
        if (immiEnabled) {
            this.digitalOutputSelection.setMaximumRowCount(9);
        }
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.setDigitalOutputRadioButton.addItemListener(this.setDigitalOutputRadioButtonItemListener);
        this.digitalOutputSelection.addActionListener(this.digitalOutputSelectionActionListener);
        this.digitalValue.addActionListener(this.digitalValueActionListener);
    }

    private void removeListeners() {
        this.digitalValue.removeActionListener(this.digitalValueActionListener);
        this.digitalOutputSelection.removeActionListener(this.digitalOutputSelectionActionListener);
        this.setDigitalOutputRadioButton.removeItemListener(this.setDigitalOutputRadioButtonItemListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<SetNode.Type> buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((Enum)SetNode.Type.DIGITAL_OUTPUT_ACTION, (AbstractButton)this.setDigitalOutputRadioButton);
    }

    private void digitalValueActionPerformed() {
        if (this.digitalValue.isEnabled() && this.setNode.getDigitalValue() != this.digitalValue.getSelectedIndex()) {
            this.setNode.setDigitalValueAndType(this.digitalValue.getSelectedIndex());
        }
    }

    private void selectSignal(Object signal) {
        if (signal instanceof Pin) {
            Pin selectedOutput = (Pin)signal;
            this.setNode.setDigitalOutputAndType(selectedOutput);
            this.buttonGroup.select((Enum)SetNode.Type.DIGITAL_OUTPUT_ACTION);
        } else if (this.setNode.getDigitalOutput() != null) {
            this.setNode.setDigitalOutput(null);
        }
    }
}

