/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.setnode.infrastructure;

import com.ur.i18n.TextResource;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.program.nodes.setnode.infrastructure.SetNodeViewPart;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.expression.field.ExpressionField;
import com.ur.swing.expression.field.ExpressionNodeProperty;
import com.ur.util.CollectionUtils;
import com.ur.util.Conjunction;
import com.ur.util.Disjunction;
import com.ur.util.Predicate;
import gui.program.setnode.SetNode;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import gui.tools.BoundsPopupMenuListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SetOutputExpressionWithExpressionViewPart
extends JPanel
implements SetNodeViewPart {
    private final ViewContext viewContext;
    private final IOService ioLookupService;
    private final InstallationComponentLookup installationLookupService;
    private final ItemListener setExpressionOutputRadioButtonItemListener;
    private final ActionListener expressionOutputSelectionActionListener;
    private final ActionListener expressionTextFieldActionListener;
    private EnumButtonGroup<SetNode.Type> buttonGroup;
    private JRadioButton setExpressionOutputRadioButton;
    private JComboBox expressionOutputSelection;
    private ExpressionField expressionTextField;
    private SetNode node;

    @Inject
    public SetOutputExpressionWithExpressionViewPart(ViewContext viewContext, IOService ioLookupService, InstallationComponentLookup installationLookupService, ExpressionField expEdit) {
        this.viewContext = viewContext;
        this.ioLookupService = ioLookupService;
        this.installationLookupService = installationLookupService;
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setExpressionOutputRadioButton = new JRadioButton();
        this.setExpressionOutputRadioButton.setName("ActionCard.outputExpression");
        this.setExpressionOutputRadioButton.setText(((TextResource)viewContext.getTextResource(TextResource.class)).Set());
        this.setExpressionOutputRadioButtonItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    SetOutputExpressionWithExpressionViewPart.this.node.setTypeAndResetOthers(SetNode.Type.EXPRESSION_OUTPUT_ACTION);
                }
            }
        };
        this.expressionOutputSelection = new ComboBox();
        this.expressionOutputSelection.setName("ActionCard.outputExpressionSelection");
        this.expressionOutputSelection.setPreferredSize(new Dimension(200, 28));
        this.expressionOutputSelectionActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SetOutputExpressionWithExpressionViewPart.this.selectSignal();
            }
        };
        ComboBoxRenderer.bindRenderer((JComboBox)this.expressionOutputSelection, (RenderingStrategy)new PinRenderingStrategy());
        Font valueFont = viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD);
        this.expressionTextField = expEdit;
        this.expressionTextField.setFont(valueFont);
        this.expressionTextField.setHorizontalAlignment(0);
        this.expressionTextField.setPreferredSize(new Dimension(250, 28));
        this.expressionTextField.setName("ActionCard.outputExpressionValue");
        this.expressionTextFieldActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SetOutputExpressionWithExpressionViewPart.this.node.textHasChanged();
                SetOutputExpressionWithExpressionViewPart.this.buttonGroup.select((Enum)SetNode.Type.EXPRESSION_OUTPUT_ACTION);
            }
        };
        this.add(this.setExpressionOutputRadioButton);
        this.add(this.expressionOutputSelection);
        this.add((Component)this.expressionTextField);
    }

    public void enter(SetNode node) {
        this.node = node;
        PinComboBoxModel model = new PinComboBoxModel();
        model.addElement((Object)((TextResource)this.viewContext.getTextResource(TextResource.class)).tokenOutputAbbrev());
        Disjunction disjunctionExpression = new Disjunction();
        disjunctionExpression.addFilter((Predicate)new Conjunction(new Predicate[]{new IOService.Unassigned(), new Predicate.Not((Predicate)new Predicate.ByType(Register.class))}));
        disjunctionExpression.addFilter((Predicate)new Conjunction(new Predicate[]{new IOService.Unassigned(), new Predicate.ByType(Register.class), new IOService.WithUserDefinedName()}));
        model.addAllElements((Iterable)CollectionUtils.filter((Iterable)this.ioLookupService.getAllOutputs(), (Predicate)disjunctionExpression));
        this.expressionOutputSelection.setModel(model);
        PinReference selectedDigitalOutput = node.getDigitalExpressionPinReference();
        if (selectedDigitalOutput == null) {
            this.expressionOutputSelection.setSelectedIndex(0);
        } else if (node.getType() == SetNode.Type.EXPRESSION_OUTPUT_ACTION) {
            model.selectPinReference(selectedDigitalOutput);
        }
        this.expressionTextField.setNodeWithExpression((ExpressionNodeProperty)node);
        this.expressionTextField.setEnabled(selectedDigitalOutput != null);
        boolean immiEnabled = this.isEuromap67Enabled(this.installationLookupService);
        BoundsPopupMenuListener.enableOnComboBox((JComboBox)this.expressionOutputSelection, (boolean)immiEnabled);
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.setExpressionOutputRadioButton.addItemListener(this.setExpressionOutputRadioButtonItemListener);
        this.expressionOutputSelection.addActionListener(this.expressionOutputSelectionActionListener);
        this.expressionTextField.addActionListener(this.expressionTextFieldActionListener);
    }

    private void removeListeners() {
        this.expressionTextField.removeActionListener(this.expressionTextFieldActionListener);
        this.expressionOutputSelection.removeActionListener(this.expressionOutputSelectionActionListener);
        this.setExpressionOutputRadioButton.removeItemListener(this.setExpressionOutputRadioButtonItemListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<SetNode.Type> buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((Enum)SetNode.Type.EXPRESSION_OUTPUT_ACTION, (AbstractButton)this.setExpressionOutputRadioButton);
    }

    private boolean isEuromap67Enabled(InstallationComponentLookup installationLookupService) {
        return installationLookupService.getComponent(Immi.class) != null && ((Immi)installationLookupService.getComponent(Immi.class)).isEnabled();
    }

    private void selectSignal() {
        Object signal = this.expressionOutputSelection.getSelectedItem();
        if (signal instanceof Pin) {
            Pin selectedOutput = (Pin)signal;
            this.node.setOutputExpressionAndType(selectedOutput);
            this.buttonGroup.select((Enum)SetNode.Type.EXPRESSION_OUTPUT_ACTION);
        } else if (this.node.getDigitalExpressionOutput() != null) {
            this.node.setDigitalExpressionOutput(null);
        }
    }
}

