/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.setnode.infrastructure;

import com.ur.math.Time;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.program.internal.TextResource;
import com.ur.program.nodes.setnode.infrastructure.DigitalPinComboBoxModel;
import com.ur.program.nodes.setnode.infrastructure.SetNodeViewPart;
import com.ur.program.nodes.setnode.infrastructure.UseSteppedComboBox;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.UnitsValueConverterFactory;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.view.io.externalapi.MinimumPulseTimeValidator;
import gui.program.setnode.SetNode;
import gui.program.setnode.SingleDigitalPulseActionState;
import gui.swing.renderers.PinRenderingStrategy;
import gui.tools.BoundsPopupMenuListener;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SetSingleDigitalPulseViewPart
extends JPanel
implements SetNodeViewPart {
    private static final boolean FORCE_SI_UNITS = true;
    private final UseSteppedComboBox useSteppedComboBox;
    private final ItemListener setSingleDigitalPulseRadioButtonItemListener;
    private final UpdateSinglePulseListener digitalOutputSelectionActionListener;
    private final UpdateSinglePulseListener pulseTimeActionListener;
    private DigitalPinComboBoxModel digitalPinComboBoxModel;
    private JRadioButton setSingleDigitalPulseRadioButton;
    private JComboBox digitalOutputSelection;
    private NumberField pulseTime;
    private SetNode node;
    private EnumButtonGroup<SetNode.Type> buttonGroup;
    private static final int MAXIMUM_ROW_COUNT = 9;

    @Inject
    public SetSingleDigitalPulseViewPart(ViewContext viewContext, DigitalPinComboBoxModel digitalPinComboBoxModel, UseSteppedComboBox useSteppedComboBox, MinimumPulseTimeValidator minimumPulseTimeValidator) {
        this.useSteppedComboBox = useSteppedComboBox;
        TextResource textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.digitalPinComboBoxModel = digitalPinComboBoxModel;
        this.setLayout(new FlowLayout(0, 5, 0));
        this.setSingleDigitalPulseRadioButton = new JRadioButton();
        this.setSingleDigitalPulseRadioButton.setName("ActionCard.singleDigitalPulse");
        this.setSingleDigitalPulseRadioButton.setText(textResource.setSinglePulse());
        this.setSingleDigitalPulseRadioButtonItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    SetSingleDigitalPulseViewPart.this.node.setTypeAndResetOthers(SetNode.Type.SINGLE_DIGITAL_PULSE);
                }
            }
        };
        this.digitalOutputSelection = new ComboBox();
        PinRenderingStrategy pinRenderingStrategy = new PinRenderingStrategy();
        ComboBoxRenderer.bindRenderer((JComboBox)this.digitalOutputSelection, (RenderingStrategy)pinRenderingStrategy);
        this.digitalOutputSelection.setName("ActionCard.singleDigitalPulseSelection");
        this.digitalOutputSelection.setModel(digitalPinComboBoxModel);
        this.digitalOutputSelection.setPreferredSize(new Dimension(200, 28));
        this.digitalOutputSelectionActionListener = new UpdateSinglePulseListener();
        this.pulseTime = new NumberField();
        this.pulseTime.setValueConverter(UnitsValueConverterFactory.getTimeConverter((boolean)true));
        this.pulseTime.setPreferredSize(new Dimension(120, 28));
        this.pulseTime.setName("ActionCard.singleDigitalPulseTime");
        this.pulseTime.setErrorValidationStrategy(new ValidationStrategy[]{minimumPulseTimeValidator});
        this.pulseTime.setMode(Mode.PositiveNumbers);
        this.pulseTimeActionListener = new UpdateSinglePulseListener();
        this.add(this.setSingleDigitalPulseRadioButton);
        this.add(this.digitalOutputSelection);
        this.add((Component)this.pulseTime);
    }

    public void enter(SetNode node) {
        this.node = node;
        SingleDigitalPulseActionState singleDigitalPulseActionState = node.getSingleDigitalPulseActionState();
        PinReference pinReference = singleDigitalPulseActionState.getPinReference();
        this.pulseTime.setValue((Object)singleDigitalPulseActionState.getTime());
        this.pulseTime.setEnabled(pinReference != null);
        this.digitalPinComboBoxModel.initializeAndSelect(pinReference);
        boolean immiEnabled = this.useSteppedComboBox.isSteppedComboBox();
        BoundsPopupMenuListener.enableOnComboBox((JComboBox)this.digitalOutputSelection, (boolean)immiEnabled);
        if (immiEnabled) {
            this.digitalOutputSelection.setMaximumRowCount(9);
        }
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.setSingleDigitalPulseRadioButton.addItemListener(this.setSingleDigitalPulseRadioButtonItemListener);
        this.digitalOutputSelection.addActionListener(this.digitalOutputSelectionActionListener);
        this.pulseTime.addActionListener((ActionListener)this.pulseTimeActionListener);
    }

    private void removeListeners() {
        this.pulseTime.removeActionListener((ActionListener)this.pulseTimeActionListener);
        this.digitalOutputSelection.removeActionListener(this.digitalOutputSelectionActionListener);
        this.setSingleDigitalPulseRadioButton.removeItemListener(this.setSingleDigitalPulseRadioButtonItemListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<SetNode.Type> buttonGroup) {
        this.buttonGroup = buttonGroup;
        buttonGroup.add((Enum)SetNode.Type.SINGLE_DIGITAL_PULSE, (AbstractButton)this.setSingleDigitalPulseRadioButton);
    }

    private class UpdateSinglePulseListener
    implements ActionListener {
        private UpdateSinglePulseListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Pin selectedPin = this.getPin();
            SetSingleDigitalPulseViewPart.this.node.setSingleDigitalPulseAndType(selectedPin, (Time)SetSingleDigitalPulseViewPart.this.pulseTime.getValue());
            if (selectedPin != null) {
                SetSingleDigitalPulseViewPart.this.buttonGroup.select((Enum)SetNode.Type.SINGLE_DIGITAL_PULSE);
            }
        }

        private Pin getPin() {
            if (SetSingleDigitalPulseViewPart.this.digitalOutputSelection.getSelectedItem() instanceof Pin) {
                return (Pin)SetSingleDigitalPulseViewPart.this.digitalOutputSelection.getSelectedItem();
            }
            return null;
        }
    }
}

