/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.waitnode;

import com.ur.i18n.TextResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.react.Recipe;
import com.ur.monitor.Source;
import com.ur.monitor.model.Masterboard;
import com.ur.polyscope.io.tool.ToolCommInfo;
import com.ur.polyscope.pin.AnalogIOPin;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.program.nodes.infrastructure.waitnode.WaitNodeViewPart;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.URFontFactory;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.CollectionUtils;
import com.ur.util.Predicate;
import com.ur.util.event.Subscription;
import gui.program.WaitNode;
import gui.program.validation.WaitNodeValidationStrategyProvider;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.text.Format;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WaitOnAnalogInputPanel
extends JPanel
implements WaitNodeViewPart {
    public static final int _4_TO_20mA = 0;
    private final IOService ioService;
    private final ViewContext viewContext;
    private final WaitNodeValidationStrategyProvider validationProvider;
    private final Recipe<ToolCommInfo> toolCommInfoRecipe;
    private final ActionListener selectionActionListener;
    private final ActionListener analogSensorSelectionActionListener;
    private final ActionListener analogComparisonComboBoxActionListener;
    private final ActionListener analogValueActionListener;
    private EnumButtonGroup<WaitNode.Type> waitButtonGroup;
    private WaitNode waitNode;
    private JRadioButton selection;
    private JComboBox analogComparisonComboBox;
    private JComboBox analogSensorSelection;
    private NumberField analogValue;
    private byte[] analogRange = new byte[4];
    private boolean toolCommEnabled;
    private Subscription subscription = Subscription.NULL;

    @Inject
    public WaitOnAnalogInputPanel(IOService ioService, ViewContext viewContext, WaitNodeValidationStrategyProvider validationProvider, @Source(value=ToolCommInfo.class) Recipe<ToolCommInfo> toolCommInfoRecipe, @Source(value=Masterboard.class) Recipe<Masterboard> armRecipe) {
        this.ioService = ioService;
        this.viewContext = viewContext;
        this.validationProvider = validationProvider;
        this.toolCommInfoRecipe = toolCommInfoRecipe;
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.setLayout(new FlowLayout(0, 5, 0));
        this.selection = new JRadioButton();
        this.selection.setName("waitOnAnalogInput.waitCard");
        this.selection.setText(((TextResource)viewContext.getTextResource(TextResource.class)).waitForAnalogInput());
        this.selectionActionListener = e -> {
            if (this.selection.isSelected()) {
                this.waitNode.setTypeAndResetOthers(WaitNode.Type.ANALOG_SENSOR_WAIT);
            } else {
                this.analogComparisonComboBox.setSelectedIndex(this.waitNode.getAnalogComparison());
                this.analogValue.setValue((Object)this.waitNode.getAnalogValue());
                this.analogValue.setEnabled(this.waitNode.getAnalogPinReference() != null);
            }
        };
        this.analogSensorSelection = widgetFactory.createComboBox();
        this.analogSensorSelection.setPreferredSize(new Dimension(200, 28));
        this.analogSensorSelection.setName("selectAnalogInput.waitCard");
        this.analogSensorSelectionActionListener = evt -> this.analogSensorSelectionActionPerformed();
        ComboBoxRenderer.bindRenderer((JComboBox)this.analogSensorSelection, (RenderingStrategy)new PinRenderingStrategy());
        this.analogComparisonComboBox = widgetFactory.createComboBox();
        this.analogComparisonComboBox.setFont(viewContext.getFontFactory().getRelativeFont(URFontFactory.Style.BOLD));
        this.analogComparisonComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{">", "<"}));
        this.analogComparisonComboBox.setPreferredSize(new Dimension(70, 28));
        this.analogComparisonComboBoxActionListener = evt -> this.analogComparisonComboBoxActionPerformed();
        this.analogValue = new NumberField();
        this.analogValue.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0#######"));
        this.analogValue.setHorizontalAlignment(11);
        this.analogValue.setValue((Object)0.0);
        this.analogValue.setPreferredSize(new Dimension(120, 28));
        this.analogValue.setUnitWidth(80);
        this.analogValueActionListener = e -> this.waitNode.setAnalogValue(((Double)this.analogValue.getValue()).doubleValue());
        armRecipe.map(Masterboard::getAnalogInputRange).distinctUntilChanged().executeOnUIThread().subscribe(thisAnalogRange -> {
            this.analogRange = thisAnalogRange;
            if (this.waitNode != null) {
                this.analogValue.setUnit(this.getUnitLabel());
                this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{this.getValueValidationStrategy(this.waitNode.getAnalogInput())});
            }
        });
        this.add(this.selection);
        this.add(this.analogSensorSelection);
        this.add(this.analogComparisonComboBox);
        this.add((Component)this.analogValue);
    }

    public void enter(WaitNode waitNode) {
        this.subscription.dispose();
        this.subscription = this.toolCommInfoRecipe.distinctUntilChanged().executeOnUIThread().subscribe(toolCommInfo -> {
            this.toolCommEnabled = toolCommInfo.isEnabled();
            if (waitNode != null) {
                this.updateModel(waitNode);
            }
        });
        this.updateModel(waitNode);
        this.addListeners();
    }

    private void updateModel(WaitNode waitNode) {
        this.waitNode = waitNode;
        PinComboBoxModel analogInputModel = new PinComboBoxModel();
        analogInputModel.addElement((Object)((TextResource)this.viewContext.getTextResource(TextResource.class)).tokenAnalogInputAbbrev());
        analogInputModel.addAllElements((Iterable)CollectionUtils.filter((Object[])this.ioService.getAllAnalogInputPins(), (Predicate)this.ioService.getToolCommEnabledPredicate(this.toolCommEnabled)));
        analogInputModel.addAllElements((Iterable)this.ioService.getCustomAnalogInputPins());
        analogInputModel.addAllElements((Iterable)CollectionUtils.filter((Object[])this.ioService.getGeneralPurposeFloatInputRegisters(), (Predicate)new IOService.WithUserDefinedName()));
        this.analogSensorSelection.setModel(analogInputModel);
        WaitOnAnalogInputPanel.initPinReferenceSelection(waitNode.getAnalogPinReference(), analogInputModel);
        this.analogComparisonComboBox.setSelectedIndex(waitNode.getAnalogComparison());
        this.analogComparisonComboBox.setEnabled(waitNode.getAnalogPinReference() != null);
        Object pin = this.analogSensorSelection.getSelectedItem();
        this.analogValue.setErrorValidationStrategy(new ValidationStrategy[]{this.getValueValidationStrategy(pin)});
        this.analogValue.setMode(pin instanceof Register ? Mode.Standard : Mode.PositiveNumbers);
        this.analogValue.setValue((Object)waitNode.getAnalogValue());
        this.analogValue.setEnabled(waitNode.getAnalogPinReference() != null);
        this.analogValue.setUnit(this.getUnitLabel());
    }

    public void exit() {
        this.removeListeners();
        this.subscription.dispose();
        this.waitNode = null;
    }

    private void addListeners() {
        this.selection.addActionListener(this.selectionActionListener);
        this.analogSensorSelection.addActionListener(this.analogSensorSelectionActionListener);
        this.analogComparisonComboBox.addActionListener(this.analogComparisonComboBoxActionListener);
        this.analogValue.addActionListener(this.analogValueActionListener);
    }

    private void removeListeners() {
        this.analogValue.removeActionListener(this.analogValueActionListener);
        this.analogComparisonComboBox.removeActionListener(this.analogComparisonComboBoxActionListener);
        this.analogSensorSelection.removeActionListener(this.analogSensorSelectionActionListener);
        this.selection.removeActionListener(this.selectionActionListener);
    }

    public JComponent getPanel() {
        return this;
    }

    public void setButtonGroup(EnumButtonGroup<WaitNode.Type> waitButtonGroup) {
        this.waitButtonGroup = waitButtonGroup;
        this.waitButtonGroup.add((Enum)WaitNode.Type.ANALOG_SENSOR_WAIT, (AbstractButton)this.selection);
    }

    private String getUnitLabel() {
        if (this.waitNode.getAnalogInput() instanceof Register) {
            return "";
        }
        if (this.waitNode.getAnalogInput() instanceof AnalogIOPin) {
            AnalogIOPin analogIOPin = (AnalogIOPin)this.waitNode.getAnalogInput();
            if (this.analogRange[analogIOPin.getPin()] == 0) {
                return Units.getText().unitMa();
            }
            return Units.getText().unitVolts();
        }
        return Units.getText().unitMa();
    }

    private void analogComparisonComboBoxActionPerformed() {
        int analogComparison = this.analogComparisonComboBox.getSelectedIndex();
        if (analogComparison != this.waitNode.getAnalogComparison()) {
            this.waitNode.setAnalogComparisonAndType(analogComparison);
        }
    }

    private void analogSensorSelectionActionPerformed() {
        Object selectedAnalogSensor = this.analogSensorSelection.getSelectedItem();
        if (selectedAnalogSensor instanceof Pin) {
            this.waitNode.setAnalogInputAndType((Pin)selectedAnalogSensor);
            this.waitButtonGroup.select((Enum)WaitNode.Type.ANALOG_SENSOR_WAIT);
        } else if (this.waitNode.getAnalogInput() != null) {
            this.waitNode.setAnalogInput(null);
        }
    }

    private ValidationStrategy getValueValidationStrategy(Object selectedAnalogSensor) {
        if (selectedAnalogSensor instanceof AnalogIOPin) {
            return this.waitNode.getAnalogInputRange() == 0 ? this.validationProvider.getElectricalCurrentValidator() : this.validationProvider.getElectricalPotentialValidator();
        }
        return this.validationProvider.getNumberValidator();
    }

    private static void initPinReferenceSelection(PinReference pinReference, PinComboBoxModel comboBoxModel) {
        if (pinReference == null) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        } else {
            comboBoxModel.selectPinReference(pinReference);
        }
    }
}

