/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.nodes.waitnode;

import com.ur.i18n.TextResource;
import com.ur.polyscope.immi.Immi;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.pin.PinReference;
import com.ur.polyscope.pin.Register;
import com.ur.polyscope.pin.service.IOService;
import com.ur.polyscope.viewfacade.pin.IOServiceType;
import com.ur.polyscope.viewfacade.pin.Pin;
import com.ur.program.nodes.infrastructure.waitnode.WaitNodeViewPart;
import com.ur.swing.ComboBox;
import com.ur.swing.ComboBoxRenderer;
import com.ur.swing.EnumButtonGroup;
import com.ur.swing.RenderingStrategy;
import com.ur.swing.ViewContext;
import com.ur.util.CollectionUtils;
import com.ur.util.Conjunction;
import com.ur.util.Disjunction;
import com.ur.util.Predicate;
import com.ur.util.logging.Log;
import gui.program.WaitNode;
import gui.swing.renderers.PinComboBoxModel;
import gui.swing.renderers.PinRenderingStrategy;
import gui.tools.BoundsPopupMenuListener;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.inject.Inject;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class WaitOnDigitalInputPanel
extends JPanel
implements WaitNodeViewPart {
    private final IOService ioService;
    private final ViewContext viewContext;
    private final InstallationComponentLookup robotInstallationLookupService;
    private final ItemListener selectionItemListener;
    private final ActionListener digitalSensorsActionListener;
    private final ActionListener valueOfSensorActionListener;
    private JRadioButton selection;
    private JComboBox digitalSensors;
    private JComboBox valueOfSensor;
    private WaitNode waitNode;
    private EnumButtonGroup<WaitNode.Type> waitButtonGroup;
    private TextResource textResource;
    private static final int MAXIMUM_ROW_COUNT = 9;

    @Inject
    public WaitOnDigitalInputPanel(IOService ioService, ViewContext viewContext, InstallationComponentLookup robotInstallationLookupService) {
        this.ioService = ioService;
        this.viewContext = viewContext;
        this.robotInstallationLookupService = robotInstallationLookupService;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.setLayout(new FlowLayout(0, 5, 0));
        this.selection = new JRadioButton();
        this.selection.setName("waitOnDigitalInput.waitCard");
        this.selection.setText(((TextResource)viewContext.getTextResource(TextResource.class)).waitForDigitalInput());
        this.selectionItemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    WaitOnDigitalInputPanel.this.waitNode.setTypeAndResetOthers(WaitNode.Type.DIGITAL_SENSOR_WAIT);
                } else {
                    WaitOnDigitalInputPanel.this.valueOfSensor.setSelectedIndex(WaitOnDigitalInputPanel.this.waitNode.getDigitalValue());
                    WaitOnDigitalInputPanel.this.valueOfSensor.setEnabled(WaitOnDigitalInputPanel.this.waitNode.getDigitalPinReference() != null);
                }
            }
        };
        this.digitalSensors = new ComboBox();
        this.digitalSensors.setName("selectDigitalInput.waitCard");
        this.digitalSensors.setPreferredSize(new Dimension(200, 28));
        this.digitalSensors.setPrototypeDisplayValue("XXXXXXXXX");
        this.digitalSensorsActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitOnDigitalInputPanel.this.digitalSensorSelectionActionPerformed();
            }
        };
        PinRenderingStrategy pinRenderingStrategy = new PinRenderingStrategy();
        ComboBoxRenderer.bindRenderer((JComboBox)this.digitalSensors, (RenderingStrategy)pinRenderingStrategy);
        this.valueOfSensor = new JComboBox();
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        model.addElement(this.textResource.tokenDigitalLo());
        model.addElement(this.textResource.tokenDigitalHi());
        this.valueOfSensor.setModel(model);
        this.valueOfSensor.setPreferredSize(new Dimension(100, 28));
        this.valueOfSensorActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                WaitOnDigitalInputPanel.this.digitalValueComboBoxActionPerformed();
            }
        };
        this.add(this.selection);
        this.add(this.digitalSensors);
        this.add(this.valueOfSensor);
    }

    public void enter(WaitNode waitNode) {
        this.waitNode = waitNode;
        PinComboBoxModel digitalInputModel = new PinComboBoxModel();
        digitalInputModel.addElement((Object)((TextResource)this.viewContext.getTextResource(TextResource.class)).tokenDigitalInputAbbrev());
        Disjunction disjunction = new Disjunction();
        disjunction.addFilter((Predicate)new IOService.UnassignedOfType(IOServiceType.DIGITAL));
        disjunction.addFilter((Predicate)new Conjunction(new Predicate[]{new IOService.UnassignedOfType(IOServiceType.BOOLEAN), new Predicate.ByType(Register.class), new IOService.WithUserDefinedName()}));
        digitalInputModel.addAllElements((Iterable)CollectionUtils.filter((Iterable)this.ioService.getAllInputs(), (Predicate)disjunction));
        this.digitalSensors.setModel(digitalInputModel);
        WaitOnDigitalInputPanel.initPinReferenceSelection(waitNode.getDigitalPinReference(), digitalInputModel);
        this.valueOfSensor.setSelectedIndex(waitNode.getDigitalValue());
        this.valueOfSensor.setEnabled(waitNode.getDigitalPinReference() != null);
        boolean immiEnabled = ((Immi)this.robotInstallationLookupService.getComponent(Immi.class)).isEnabled();
        BoundsPopupMenuListener.enableOnComboBox((JComboBox)this.digitalSensors, (boolean)immiEnabled);
        if (immiEnabled) {
            this.digitalSensors.setMaximumRowCount(9);
        }
        this.addListeners();
    }

    public void exit() {
        this.removeListeners();
    }

    private void addListeners() {
        this.selection.addItemListener(this.selectionItemListener);
        this.digitalSensors.addActionListener(this.digitalSensorsActionListener);
        this.valueOfSensor.addActionListener(this.valueOfSensorActionListener);
    }

    private void removeListeners() {
        this.valueOfSensor.removeActionListener(this.valueOfSensorActionListener);
        this.digitalSensors.removeActionListener(this.digitalSensorsActionListener);
        this.selection.removeItemListener(this.selectionItemListener);
    }

    public void setButtonGroup(EnumButtonGroup<WaitNode.Type> waitButtonGroup) {
        this.waitButtonGroup = waitButtonGroup;
        waitButtonGroup.add((Enum)WaitNode.Type.DIGITAL_SENSOR_WAIT, (AbstractButton)this.selection);
    }

    public JComponent getPanel() {
        return this;
    }

    private static void initPinReferenceSelection(PinReference pinReference, PinComboBoxModel comboBoxModel) {
        if (pinReference == null) {
            comboBoxModel.setSelectedItem(comboBoxModel.getElementAt(0));
        } else {
            comboBoxModel.selectPinReference(pinReference);
        }
    }

    private void digitalValueComboBoxActionPerformed() {
        int digitalValue = this.valueOfSensor.getSelectedIndex();
        if (digitalValue != this.waitNode.getDigitalValue()) {
            this.waitNode.setDigitalValueAndType(digitalValue);
        }
    }

    private void digitalSensorSelectionActionPerformed() {
        Object selectedDigitalSensor = this.digitalSensors.getSelectedItem();
        Log.debug((String)"Selection changed");
        if (selectedDigitalSensor instanceof Pin) {
            this.waitNode.setTypeAndResetOthers(WaitNode.Type.DIGITAL_SENSOR_WAIT);
            this.waitNode.setDigitalInputAndType((Pin)selectedDigitalSensor);
            this.waitButtonGroup.select((Enum)WaitNode.Type.DIGITAL_SENSOR_WAIT);
            Log.debug((String)"Selecting digital input");
        } else if (this.waitNode.getDigitalInput() != null) {
            this.waitNode.setDigitalInput(null);
        }
    }
}

