/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.optimove;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.program.internal.TextResource;
import com.ur.program.optimove.AccelerationField$AjcClosure1;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import gui.commandpanels.AccelerationFieldParser;
import gui.commandpanels.WaypointCard;
import gui.program.AccelerationValueNode;
import gui.program.OptiMoveNode;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.text.Format;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

class AccelerationField {
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;
    private final TextResource textResource;
    public final NumberField acceleration;
    public final JLabel label;
    private OptiMoveNode optiMoveNode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    AccelerationField(ViewContext viewContext, WaypointNodeValidationStrategyProvider validationStrategyProvider) {
        this.validationStrategyProvider = validationStrategyProvider;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.acceleration = viewContext.createWidgetFactory().createNumberField(actionEvent -> this.accelerationFieldActionPerformed());
        this.label = viewContext.createWidgetFactory().createLabel(((TextResource)viewContext.getTextResource(TextResource.class)).jointAcceleration());
        this.initializeAcceleration(this.acceleration);
    }

    private void initializeAcceleration(NumberField acceleration) {
        acceleration.setName(WaypointCard.ACCELERATION_FIELD);
        acceleration.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        acceleration.setText("500.0");
        acceleration.setUnitWidth(55);
        acceleration.setMode(Mode.PositiveNumbers);
    }

    public void updateField() {
        this.setCartesianAcceleration();
        this.setJointAcceleration();
        AccelerationFieldParser.update((JTextComponent)this.acceleration, (AccelerationValueNode)this.optiMoveNode);
    }

    private void setJointAcceleration() {
        if (this.optiMoveNode.isCartesianMotion()) {
            return;
        }
        this.label.setText(this.textResource.jointAcceleration());
        this.acceleration.setUnit(Units.getText().unitDegS2());
        this.acceleration.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getJointAccelerationLimitValidator()});
    }

    private void setCartesianAcceleration() {
        if (!this.optiMoveNode.isCartesianMotion()) {
            return;
        }
        this.label.setText(this.textResource.toolAcceleration());
        this.acceleration.setUnit(Units.getText().unitMmS2());
        this.acceleration.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointAccelerationLimitValidator()});
    }

    public void setEnabled(boolean selected) {
        this.acceleration.setEnabled(selected);
    }

    public void setOptiMoveNode(OptiMoveNode optiMoveNode) {
        this.optiMoveNode = optiMoveNode;
    }

    @CompoundProgramChange
    private void accelerationFieldActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AccelerationField$AjcClosure1 accelerationField$AjcClosure1 = new AccelerationField$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(accelerationField$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        AccelerationField.ajc$preClinit();
    }

    static final /* synthetic */ void accelerationFieldActionPerformed_aroundBody0(AccelerationField ajc$this, JoinPoint joinPoint) {
        AccelerationFieldParser.parse((JTextComponent)ajc$this.acceleration, (AccelerationValueNode)ajc$this.optiMoveNode);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AccelerationField.java", AccelerationField.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "accelerationFieldActionPerformed", "com.ur.program.optimove.AccelerationField", "", "", "", "void"), 74);
    }
}

