/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.optimove;

import com.ur.program.optimove.MotionControlsPanel;
import com.ur.program.optimove.OptiMoveParametersPanel;
import com.ur.program.optimove.SpeedAndAccelerationParametersPanel;
import com.ur.program.optimove.TimeFieldPanel;
import com.ur.swing.ViewContext;
import gui.program.OptiMoveNode;
import gui.program.position.ParametersType;
import gui.program.position.PositionNode;
import gui.program.position.WaypointNode;
import java.awt.CardLayout;
import java.awt.Component;
import javax.inject.Inject;
import javax.swing.JPanel;

class AggregateParametersPanel
extends JPanel {
    private final MotionControlsPanel motionControlsPanel;
    private final TimeFieldPanel timeFieldPanel;
    private final CardLayout cardFlipper;
    private WaypointNode node;
    private static final String MOTION_CONTROLS = "MotionControls";

    @Inject
    AggregateParametersPanel(ViewContext viewContext, SpeedAndAccelerationParametersPanel speedAndAccelerationParametersPanel, OptiMoveParametersPanel optiMoveParametersPanel, TimeFieldPanel timeFieldPanel) {
        this.motionControlsPanel = new MotionControlsPanel(viewContext, speedAndAccelerationParametersPanel, optiMoveParametersPanel);
        this.timeFieldPanel = timeFieldPanel;
        this.cardFlipper = new CardLayout();
        this.setLayout(this.cardFlipper);
        this.add((Component)this.motionControlsPanel, MOTION_CONTROLS);
        this.add((Component)timeFieldPanel, ParametersType.TIME.name());
    }

    public void updateCard() {
        String parameterType;
        ParametersType type = ParametersType.getType((PositionNode)this.node);
        String string = parameterType = type == ParametersType.SHARED ? MOTION_CONTROLS : type.name();
        if (type == ParametersType.ABSOLUTE || type == ParametersType.OPTIMOVE) {
            parameterType = MOTION_CONTROLS;
        }
        this.setPanelEnabled(!this.node.isUsingSharedParameters());
        this.timeFieldPanel.updatePanel();
        this.motionControlsPanel.updatePanel();
        this.cardFlipper.show(this, parameterType);
    }

    public void setPositionNode(WaypointNode node) {
        this.node = node;
        this.motionControlsPanel.setOptiMoveNode((OptiMoveNode)node);
        if (!node.isUsingSharedParameters()) {
            this.motionControlsPanel.allowOptiMove(!node.isProcessMoveNode());
        }
        this.timeFieldPanel.setPositionNode((PositionNode)node);
    }

    private void setPanelEnabled(boolean isEnabled) {
        this.motionControlsPanel.setPanelEnablement(isEnabled);
        this.enableComponents(this.timeFieldPanel.getComponents(), isEnabled);
    }

    private void enableComponents(Component[] components, boolean isEnabled) {
        Component[] componentArray = components;
        int n = components.length;
        int n2 = 0;
        while (n2 < n) {
            Component component = componentArray[n2];
            if (component instanceof JPanel) {
                this.setPanelEnabled(isEnabled);
            }
            component.setEnabled(isEnabled);
            ++n2;
        }
    }
}

