/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.optimove;

import com.ur.i18n.CommandNamesResource;
import com.ur.lang.DecimalFormatFactory;
import com.ur.lang.naming.NamingService;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeCardContribution;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.program.internal.TextResource;
import com.ur.program.optimove.AggregateParametersPanel;
import com.ur.program.optimove.MeasuredWaypointCard$AjcClosure1;
import com.ur.program.optimove.MeasuredWaypointCard$AjcClosure3;
import com.ur.program.optimove.ParameterSelector;
import com.ur.program.waypoint.infrastructure.PositionTypeCellRenderer;
import com.ur.program.waypoint.infrastructure.PositionTypeModel;
import com.ur.program.waypoint.infrastructure.WaypointFixedTypePanel;
import com.ur.program.waypoint.infrastructure.WaypointRelativeTypePanel;
import com.ur.program.waypoint.infrastructure.WaypointVariableTypePanel;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.card.CardLayoutUtil;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.swing.g5.G5LookAndFeel;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.LogTime;
import com.ur.util.swing.HTML;
import gui.commandpanels.WaypointCard;
import gui.program.MotionDefiningNode;
import gui.program.UpdateExecutionFlowComponent;
import gui.program.position.PositionNode;
import gui.program.position.WaypointNode;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.Format;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Set;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class MeasuredWaypointCard
extends WaypointCard {
    public static final String BLEND_RADIUS;
    private static final String WAYPOINT_CARD = "WaypointCard";
    private static final String WAYPOINT_HEADER = "Waypoint_header";
    private static final String VARIABLE_HEADER = "VARIABLE_HEADER";
    private final NamingService namingService;
    private final AggregateParametersPanel aggregator;
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;
    private final EnumMap<PositionNodeType, Runnable> positionNodeTypToAction;
    private NumberField blendRadiusField;
    private JRadioButton stopRadioButton;
    private JRadioButton blendRadioButton;
    private JComboBox<PositionNodeType> waypointTypeComboBox;
    private ParameterSelector parameterSelector;
    private final FlippablePanel waypointTypePanel;
    private JPanel headerPanel;
    private boolean needToUpdate = true;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;

    static {
        MeasuredWaypointCard.ajc$preClinit();
        BLEND_RADIUS = "blendRadius." + MeasuredWaypointCard.class.getSimpleName();
    }

    @Inject
    MeasuredWaypointCard(NamingService namingService, ViewContext viewContext, WaypointNodeValidationStrategyProvider validationStrategyProvider, AggregateParametersPanel aggregator, WaypointFixedTypePanel fixedTypePanel, WaypointRelativeTypePanel relativeTypePanel, WaypointVariableTypePanel variableTypePanel, Set<ProgramNodeCardContribution> programNodeCardContributions) {
        super(viewContext, programNodeCardContributions);
        this.namingService = namingService;
        this.aggregator = aggregator;
        this.validationStrategyProvider = validationStrategyProvider;
        this.waypointTypePanel = new FlippablePanel();
        this.initComponents();
        this.assignHelpIds();
        this.positionNodeTypToAction = new EnumMap(PositionNodeType.class);
        this.positionNodeTypToAction.put(PositionNodeType.UNDEFINED, this::handleUndefinedOrFixed);
        this.positionNodeTypToAction.put(PositionNodeType.FIXED, this::handleUndefinedOrFixed);
        this.positionNodeTypToAction.put(PositionNodeType.RELATIVE, this::handleRelative);
        this.positionNodeTypToAction.put(PositionNodeType.VARIABLE, this::handleVariable);
        this.waypointTypePanel.addCardPanel((CardPanel)fixedTypePanel);
        this.waypointTypePanel.addCardPanel((CardPanel)variableTypePanel);
        this.waypointTypePanel.addCardPanel((CardPanel)relativeTypePanel);
        this.waypointTypePanel.setCardParent((CardPanel)this);
        this.waypointTypeComboBox.setName(WaypointCard.SELECT_WAYPOINT_TYPE);
        this.setName(WAYPOINT_CARD);
    }

    private void assignHelpIds() {
        this.viewContext.getHelpIdAssigner().assignHelpId((JComponent)((Object)this), "gui:command_waypoint");
    }

    protected void updateCard() {
        try {
            this.parameterSelector.setPositionNode((PositionNode)this.getNode());
            this.aggregator.setPositionNode((WaypointNode)this.getNode());
            if (((WaypointNode)this.getNode()).getMotionDefiningNode() == null) {
                return;
            }
            if (this.needToUpdate) {
                this.needToUpdate = false;
                SwingUtilities.invokeLater(() -> {
                    this.updateLater();
                    this.needToUpdate = true;
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateLater() {
        LogTime.startLog((String)"update_waypoint_card");
        WaypointNode node = (WaypointNode)this.getNode();
        this.waypointTypeComboBox.setEnabled(this.namingService.getEntitiesWithName(((WaypointNode)this.getNode()).getName()).size() <= 1 || ((WaypointNode)this.getNode()).getPositionNodeType() == PositionNodeType.VARIABLE);
        this.updatePositionType();
        this.waypointTypePanel.getCurrentCard().enter((Object)node);
        this.aggregator.updateCard();
        this.parameterSelector.updateCard();
        this.updateBlendFields();
        LogTime.stopLog((String)"update_waypoint_card");
    }

    public Object exit() {
        this.waypointTypePanel.exitActiveChild();
        return super.exit();
    }

    private void updatePositionType() {
        WaypointNode node = (WaypointNode)this.getNode();
        PositionNodeType type = node.getPositionNodeType();
        this.waypointTypePanel.exitActiveChild();
        CardLayoutUtil.flipToCard((JPanel)this.headerPanel, (String)(type == PositionNodeType.VARIABLE ? VARIABLE_HEADER : WAYPOINT_HEADER));
        this.positionNodeTypToAction.get(type).run();
    }

    private void handleUndefinedOrFixed() {
        this.waypointTypeComboBox.setSelectedItem(((WaypointNode)this.getNode()).getPositionNodeType());
        this.waypointTypePanel.switchTo(WaypointFixedTypePanel.class, this.getNode());
    }

    private void handleRelative() {
        this.waypointTypeComboBox.setSelectedItem(PositionNodeType.RELATIVE);
        this.waypointTypePanel.switchTo(WaypointRelativeTypePanel.class, this.getNode());
    }

    private void handleVariable() {
        this.waypointTypeComboBox.setSelectedItem(PositionNodeType.VARIABLE);
        this.waypointTypePanel.switchTo(WaypointVariableTypePanel.class, this.getNode());
    }

    private void updateBlendFields() {
        WaypointNode node = (WaypointNode)this.getNode();
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        this.blendRadiusField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getBlendRadiusValidator((PositionNode)node)});
        this.stopRadioButton.setSelected(node.isUseSharedBlendParameter());
        this.blendRadioButton.setSelected(!node.isUseSharedBlendParameter());
        this.blendRadiusField.setText(Units.convert_from_m((double)node.getBlendRadius()));
        this.blendRadiusField.setEnabled(this.blendRadioButton.isSelected());
        MotionDefiningNode.MotionType motionType = ((WaypointNode)this.getNode()).getMotionDefiningNode().getMotionType();
        if (motionType != MotionDefiningNode.MotionType.PROCESS_MOVE) {
            this.stopRadioButton.setText(resource.stopAtThisPoint());
        } else {
            this.stopRadioButton.setText(resource.useSharedProcessBlendRadius());
        }
        UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)((AbstractProgramNode)this.getNode()));
    }

    @CompoundProgramChange
    private void updateStopPointChoice() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        MeasuredWaypointCard$AjcClosure1 measuredWaypointCard$AjcClosure1 = new MeasuredWaypointCard$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(measuredWaypointCard$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        ButtonGroup stopOrBlendButtonGroup = new ButtonGroup();
        this.blendRadiusField = factory.createNumberField(e -> this.parseBlendValue((JTextField)this.blendRadiusField));
        this.blendRadiusField.setUnit(Units.getText().unitMm());
        this.blendRadiusField.setMode(Mode.PositiveNumbers);
        this.blendRadiusField.setName(BLEND_RADIUS);
        this.blendRadiusField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"#.#"));
        this.blendRadiusField.setPreferredSize(new Dimension(100, 30));
        this.blendRadiusField.setMaximumSize(this.blendRadiusField.getPreferredSize());
        this.stopRadioButton = new JRadioButton(resource.stopAtThisPoint());
        this.blendRadioButton = new JRadioButton(resource.blendWithRadius());
        this.waypointTypeComboBox = factory.createComboBox();
        this.waypointTypeComboBox.setRenderer((ListCellRenderer<PositionNodeType>)((Object)new PositionTypeCellRenderer(resource)));
        this.waypointTypeComboBox.setModel(new PositionTypeModel());
        this.waypointTypeComboBox.addActionListener(evt -> this.waypointTypeComboBoxActionPerformed());
        this.parameterSelector = new ParameterSelector(this.viewContext, this::updateCard);
        this.initHeaderPanel();
        JPanel blendNumberField = this.viewContext.createFormBuilder().component((JComponent)this.blendRadiusField, new FormBuilder.PanelConstraints[0]).end().getPanel();
        blendNumberField.setBorder(BorderFactory.createEmptyBorder(0, 7, 0, 5));
        JPanel mainPanel = this.viewContext.createFormBuilder().component((JComponent)this.headerPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).spacer().component(this.waypointTypeComboBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.waypointTypePanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_10_ROWS}).end(11).component(this.getVerticallyCenterSeparator(factory), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().component((JComponent)this.stopRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.parameterSelector, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).end().component((JComponent)this.blendRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).spacer().component((JComponent)this.aggregator, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS, FormBuilder.PanelConstraints.SPAN_7_ROWS}).end().component((JComponent)blendNumberField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.INDENT, FormBuilder.PanelConstraints.SPAN_2_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(7).component(this.getContribution(0), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).end().getPanel();
        stopOrBlendButtonGroup.add(this.stopRadioButton);
        this.stopRadioButton.addActionListener(evt -> this.updateStopPointChoice());
        stopOrBlendButtonGroup.add(this.blendRadioButton);
        this.blendRadioButton.addActionListener(evt -> this.updateStopPointChoice());
        this.setLayout(new BorderLayout(0, 0));
        this.add(mainPanel, "Center");
    }

    private JComponent getVerticallyCenterSeparator(WidgetFactory factory) {
        JPanel result = this.viewContext.createFormBuilder().component(factory.createSeparator(G5LookAndFeel.BETWEEN_CARD_COLOR), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS}).end().getPanel();
        result.setBorder(BorderFactory.createEmptyBorder(10, -5, 0, 0));
        return result;
    }

    private JComponent getContribution(int index) {
        if (index >= this.programNodeCardContributions.size()) {
            return new JPanel();
        }
        ProgramNodeCardContribution[] contributions = this.programNodeCardContributions.toArray(new ProgramNodeCardContribution[this.programNodeCardContributions.size()]);
        Arrays.sort(contributions, (a, b) -> a.getPriority() < b.getPriority() ? 1 : 0);
        return contributions[index].getContribution();
    }

    private void initHeaderPanel() {
        JPanel waypointHeader = this.viewContext.createFormBuilder().headerLabel(((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Waypoint(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).getRow();
        JPanel variableHeader = this.viewContext.createFormBuilder().label(HTML.html((String)HTML.h1((String)((CommandNamesResource)this.viewContext.getTextResource(CommandNamesResource.class)).Waypoint())), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_4_COLUMNS}).getRow();
        this.headerPanel = new JPanel(new CardLayout());
        this.headerPanel.add((Component)waypointHeader, WAYPOINT_HEADER);
        this.headerPanel.add((Component)variableHeader, VARIABLE_HEADER);
        CardLayoutUtil.flipToCard((JPanel)this.headerPanel, (String)WAYPOINT_HEADER);
    }

    @CompoundProgramChange
    private void waypointTypeComboBoxActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        MeasuredWaypointCard$AjcClosure3 measuredWaypointCard$AjcClosure3 = new MeasuredWaypointCard$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(measuredWaypointCard$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    static final /* synthetic */ void updateStopPointChoice_aroundBody0(MeasuredWaypointCard ajc$this, JoinPoint joinPoint) {
        WaypointNode node = (WaypointNode)ajc$this.getNode();
        if (ajc$this.stopRadioButton.isSelected()) {
            node.setStopPoint(true);
            node.setUseSharedBlendParameter(true);
        }
        if (ajc$this.blendRadioButton.isSelected()) {
            node.setStopPoint(false);
            node.setUseSharedBlendParameter(false);
        }
        ajc$this.updateBlendFields();
    }

    static final /* synthetic */ void waypointTypeComboBoxActionPerformed_aroundBody2(MeasuredWaypointCard ajc$this, JoinPoint joinPoint) {
        PositionNodeType type = (PositionNodeType)ajc$this.waypointTypeComboBox.getSelectedItem();
        if (type != ((WaypointNode)ajc$this.getNode()).getPositionNodeType()) {
            ((WaypointNode)ajc$this.getNode()).setPositionNodeType(type);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("MeasuredWaypointCard.java", MeasuredWaypointCard.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "updateStopPointChoice", "com.ur.program.optimove.MeasuredWaypointCard", "", "", "", "void"), 199);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "waypointTypeComboBoxActionPerformed", "com.ur.program.optimove.MeasuredWaypointCard", "", "", "", "void"), 297);
    }
}

