/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.optimove;

import com.ur.program.optimove.OptiMoveParametersPanel;
import com.ur.program.optimove.SpeedAndAccelerationParametersPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.card.CardLayoutUtil;
import gui.program.OptiMoveNode;
import java.awt.CardLayout;
import java.awt.Component;
import java.util.stream.Stream;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class MotionControlsPanel
extends JPanel {
    private static final String OPTIMOVE = "optimove";
    private static final String ABSOLUTE = "absolute";
    private final SpeedAndAccelerationParametersPanel speedAndAccelerationParametersPanel;
    private final OptiMoveParametersPanel optiMoveParametersPanel;
    private final JPanel parametersPanel;
    private OptiMoveNode optiMoveNode;

    public MotionControlsPanel(ViewContext viewContext, SpeedAndAccelerationParametersPanel speedAndAccelerationParametersPanel, OptiMoveParametersPanel optiMoveParametersPanel) {
        this.speedAndAccelerationParametersPanel = speedAndAccelerationParametersPanel;
        this.optiMoveParametersPanel = optiMoveParametersPanel;
        this.parametersPanel = this.createIndividualParametersPanel(speedAndAccelerationParametersPanel, optiMoveParametersPanel);
        this.populatePanel(viewContext, this.parametersPanel);
    }

    private JPanel createIndividualParametersPanel(SpeedAndAccelerationParametersPanel speedAndAccelerationParametersPanel, OptiMoveParametersPanel optiMoveParametersPanel) {
        JPanel result = new JPanel(new CardLayout());
        result.add((Component)speedAndAccelerationParametersPanel, ABSOLUTE);
        result.add((Component)optiMoveParametersPanel, OPTIMOVE);
        return result;
    }

    private void populatePanel(ViewContext viewContext, JComponent parametersPanel) {
        viewContext.createFormBuilder().component(parametersPanel, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_7_COLUMNS, FormBuilder.PanelConstraints.SPAN_12_ROWS}).end(12).setOnPanel((JPanel)this);
        this.setBorder(BorderFactory.createEmptyBorder(0, -5, 0, 0));
    }

    public void setOptiMoveNode(OptiMoveNode optiMoveNode) {
        this.optiMoveNode = optiMoveNode;
        this.speedAndAccelerationParametersPanel.setOptiMoveNode(optiMoveNode);
        this.optiMoveParametersPanel.setOptiMoveNode(optiMoveNode);
    }

    public void updatePanel() {
        boolean usingOptiMove = this.optiMoveNode.isUsingOptiMove();
        CardLayoutUtil.flipToCard((JPanel)this.parametersPanel, (String)(usingOptiMove ? OPTIMOVE : ABSOLUTE));
    }

    public void setPanelEnablement(boolean isEnabled) {
        this.optiMoveParametersPanel.setEnabled(isEnabled);
        this.componentsEnablement(this.speedAndAccelerationParametersPanel.getComponents(), isEnabled);
    }

    private void componentsEnablement(Component[] components, boolean isEnabled) {
        Stream.of(components).forEach(it -> this.toggleComponentEnablement((Component)it, isEnabled));
    }

    private void toggleComponentEnablement(Component component, boolean isEnabled) {
        if (component instanceof JPanel) {
            this.componentsEnablement(((JPanel)component).getComponents(), isEnabled);
        }
        component.setEnabled(isEnabled);
    }

    private void disableOptiMove() {
        this.optiMoveNode.setUsingOptiMove(false);
        this.updatePanel();
    }

    public void allowOptiMove(boolean allowed) {
        if (!allowed && this.optiMoveNode.isUsingOptiMove()) {
            this.disableOptiMove();
        }
    }
}

