/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.optimove;

import com.ur.lang.PrimitiveUtils;
import com.ur.polyscope.program.nodes.move.MoveNodeWithOptiMove;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationProvider;
import com.ur.polyscope.robot.configuration.optimove.OptiMoveConfigurationSettings;
import com.ur.polyscope.valueobjects.Percentage;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.program.internal.TextResource;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.g5.URSliderUI;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.ValueConverter;
import com.ur.swing.validation.ValidationFactory;
import com.ur.swing.validation.ValidationStrategy;
import gui.program.OptiMoveNode;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Dictionary;
import java.util.Hashtable;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.plaf.SliderUI;

public class OptiMoveParametersPanel
extends JPanel {
    public static final String OPTIMOVE_SLIDER = "OptiMoveSlider." + OptiMoveParametersPanel.class.getSimpleName();
    public static final String OPTIMOVE_SPEED = "OptiMoveSpeedField." + OptiMoveParametersPanel.class.getSimpleName();
    public static final String OPTIMOVE_ACCELERATION = "OptimoveAccelerationField." + OptiMoveParametersPanel.class.getSimpleName();
    public static final String OPTIMOVE_CHECKBOX = "OptiMoveCheckBox." + OptiMoveParametersPanel.class.getSimpleName();
    private static final int VALIDATOR_MINIMUM = 0;
    private static final int LOWER_LIMIT = 1;
    private static final int UPPER_LIMIT = 100;
    private static final ValueConverter<String, Percentage> percentageConverter = UnitsValueConverterFactory.getPercentageConverter();
    private final TextResource textResource;
    private final JSlider slider;
    private final NumberField speedField;
    private final NumberField accelerationField;
    private final JCheckBox customValuesCheckBox;
    private OptiMoveNode optiMoveNode;

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        if (enabled) {
            this.enableComponents();
            return;
        }
        this.disableComponents();
    }

    private void disableComponents() {
        this.slider.setEnabled(false);
        this.speedField.setEnabled(false);
        this.accelerationField.setEnabled(false);
        this.customValuesCheckBox.setEnabled(false);
    }

    private void enableComponents() {
        this.customValuesCheckBox.setEnabled(true);
        if (!this.customValuesCheckBox.isSelected()) {
            this.useScaledOptiMoveParameters();
            return;
        }
        this.useCustomOptiMoveParameters();
    }

    @Inject
    public OptiMoveParametersPanel(ViewContext viewContext, OptiMoveConfigurationProvider optiMoveConfigurationProvider) {
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        WidgetFactory widgetFactory = viewContext.createWidgetFactory();
        this.customValuesCheckBox = this.getCustomValuesCheckBox();
        this.slider = this.getOptiMoveSlider();
        Box speedSliderBox = Box.createHorizontalBox();
        speedSliderBox.add(this.slider);
        speedSliderBox.add(Box.createHorizontalStrut(32));
        OptiMoveConfigurationSettings optiMoveConfigurationSettings = (OptiMoveConfigurationSettings)optiMoveConfigurationProvider.getOptiMoveConfigurationSettings().orElseThrow(IllegalStateException::new);
        this.speedField = this.getSpeedField(widgetFactory, optiMoveConfigurationSettings);
        this.accelerationField = this.getAccelerationField(widgetFactory, optiMoveConfigurationSettings);
        viewContext.createFormBuilder().component((JComponent)speedSliderBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS, FormBuilder.PanelConstraints.SPAN_2_ROWS}).end(3).label(this.textResource.optimoveSpeed(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.speedField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().label(this.textResource.optimoveAcceleration(), new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_3_COLUMNS}).component((JComponent)this.accelerationField, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.customValuesCheckBox, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_5_COLUMNS}).end().setOnPanel((JPanel)this);
        this.setBorder(BorderFactory.createEmptyBorder(-2, -5, 0, 0));
    }

    private JCheckBox getCustomValuesCheckBox() {
        JCheckBox checkbox = new JCheckBox(this.textResource.optimoveCheckbox());
        checkbox.setName(OPTIMOVE_CHECKBOX);
        checkbox.setSelected(true);
        checkbox.addItemListener(e -> {
            if (e.getStateChange() == 2) {
                this.useScaledOptiMoveParameters();
                if (this.optiMoveNode.isUsingOptiMove()) {
                    double acceleration = OptiMoveParametersPanel.getScaledAcceleration(this.optiMoveNode.getOptiMoveSpeed());
                    this.optiMoveNode.setOptiMoveAcceleration(Percentage.from((double)acceleration));
                }
            } else if (e.getStateChange() == 1) {
                this.useCustomOptiMoveParameters();
            }
        });
        return checkbox;
    }

    private NumberField getSpeedField(WidgetFactory widgetFactory, OptiMoveConfigurationSettings optiMoveConfigurationSettings) {
        NumberField speedNumberField = widgetFactory.createNumberField(this::onSpeedChanged);
        speedNumberField.setUnit("%");
        speedNumberField.setName(OPTIMOVE_SPEED);
        this.configureNumberField(speedNumberField);
        speedNumberField.setValue((Object)Percentage.from((double)optiMoveConfigurationSettings.getSpeedPercentageDefault()));
        return speedNumberField;
    }

    private void onSpeedChanged(ActionEvent actionEvent) {
        double speed = PrimitiveUtils.parseDouble((String)actionEvent.getActionCommand());
        speed = Math.max(speed, Double.MIN_VALUE);
        this.slider.setValue((int)Math.ceil(speed));
        this.optiMoveNode.setOptiMoveSpeed((Percentage)percentageConverter.fromGui((Object)("" + speed)));
    }

    private NumberField getAccelerationField(WidgetFactory widgetFactory, OptiMoveConfigurationSettings optiMoveConfigurationSettings) {
        NumberField accelerationNumberField = widgetFactory.createNumberField(this::onAccelerationChanged);
        accelerationNumberField.setUnit("%");
        accelerationNumberField.setName(OPTIMOVE_ACCELERATION);
        this.configureNumberField(accelerationNumberField);
        accelerationNumberField.setValue((Object)Percentage.from((double)optiMoveConfigurationSettings.getAccelerationPercentageDefault()));
        return accelerationNumberField;
    }

    private void configureNumberField(NumberField numberField) {
        numberField.setEnabled(false);
        numberField.setValueConverter(percentageConverter);
        ValidationStrategy rangeValidator = ValidationFactory.getRangeValidator((double)0.0, (double)100.0, (String)this.textResource.optimovePercentageValidationError("0%", "100%"));
        numberField.setErrorValidationStrategy(new ValidationStrategy[]{rangeValidator});
    }

    private void onAccelerationChanged(ActionEvent actionEvent) {
        double acceleration = PrimitiveUtils.parseDouble((String)actionEvent.getActionCommand());
        acceleration = Math.max(acceleration, Double.MIN_VALUE);
        this.optiMoveNode.setOptiMoveAcceleration((Percentage)percentageConverter.fromGui((Object)("" + acceleration)));
    }

    private void useCustomOptiMoveParameters() {
        if (!this.isEnabled()) {
            return;
        }
        this.customValuesCheckBox.setSelected(true);
        this.slider.setEnabled(false);
        this.speedField.setEnabled(true);
        this.accelerationField.setEnabled(true);
    }

    private void useScaledOptiMoveParameters() {
        if (!this.isEnabled()) {
            return;
        }
        this.customValuesCheckBox.setSelected(false);
        this.slider.setEnabled(true);
        this.speedField.setEnabled(false);
        this.accelerationField.setEnabled(false);
    }

    private JSlider getOptiMoveSlider() {
        final JSlider percentageSlider = new JSlider(0);
        percentageSlider.setUI((SliderUI)new URSliderUI(){

            protected Dimension getThumbSize() {
                return new Dimension(19, 19);
            }
        });
        Hashtable<Integer, JLabel> sliderLabels = new Hashtable<Integer, JLabel>();
        ((Dictionary)sliderLabels).put(2, new JLabel("1%"));
        ((Dictionary)sliderLabels).put(100, new JLabel("100%"));
        percentageSlider.setName(OPTIMOVE_SLIDER);
        percentageSlider.setLabelTable(sliderLabels);
        percentageSlider.setMajorTickSpacing(25);
        percentageSlider.setMinimum(1);
        percentageSlider.setMaximum(100);
        percentageSlider.setValue(30);
        percentageSlider.setPaintLabels(true);
        percentageSlider.setPaintTicks(true);
        percentageSlider.setSnapToTicks(false);
        percentageSlider.setBorder(BorderFactory.createEmptyBorder(0, -13, 0, 0));
        percentageSlider.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (!percentageSlider.isEnabled()) {
                    return;
                }
                OptiMoveParametersPanel.this.confirmSliderPosition(e.getX());
            }
        });
        percentageSlider.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                if (!percentageSlider.isEnabled()) {
                    return;
                }
                OptiMoveParametersPanel.this.setUIToMousePosition(e.getX());
            }
        });
        return percentageSlider;
    }

    public void setOptiMoveNode(OptiMoveNode optiMoveNode) {
        this.optiMoveNode = optiMoveNode;
        this.updateUI(this.optiMoveNode.getOptiMoveSpeed(), this.optiMoveNode.getOptiMoveAcceleration());
    }

    public void updateCard() {
        if (this.optiMoveNode == null) {
            return;
        }
        this.updateUI(this.optiMoveNode.getOptiMoveSpeed(), this.optiMoveNode.getOptiMoveAcceleration());
    }

    private void updateUI(Percentage speed, Percentage acceleration) {
        this.slider.setValue((int)(speed.getValue() * 100.0));
        this.speedField.setValue((Object)speed);
        this.accelerationField.setValue((Object)acceleration);
        this.updateScaledCheckbox(speed, acceleration);
    }

    private void updateScaledCheckbox(Percentage speed, Percentage acceleration) {
        this.customValuesCheckBox.setSelected(OptiMoveParametersPanel.getScaledAcceleration(speed) != acceleration.getValue());
    }

    private void confirmSliderPosition(int mousePosition) {
        if (this.customValuesCheckBox.isSelected()) {
            return;
        }
        int sliderValue = this.getSliderValueFromMousePosition(mousePosition);
        Percentage speed = (Percentage)percentageConverter.fromGui((Object)("" + sliderValue));
        double acceleration = OptiMoveParametersPanel.getScaledAcceleration(speed);
        this.optiMoveNode.setOptiMoveSpeed(speed);
        this.optiMoveNode.setOptiMoveAcceleration(Percentage.from((double)acceleration));
    }

    private void setUIToMousePosition(int mousePosition) {
        if (this.customValuesCheckBox.isSelected()) {
            return;
        }
        int sliderValue = this.getSliderValueFromMousePosition(mousePosition);
        Percentage speed = (Percentage)percentageConverter.fromGui((Object)("" + sliderValue));
        this.updateUI(speed, Percentage.from((double)OptiMoveParametersPanel.getScaledAcceleration(speed)));
    }

    private int getSliderValueFromMousePosition(int mousePosition) {
        double sliderPositionFraction = (double)mousePosition / (double)(this.slider.getWidth() - 16);
        int sliderValue = Math.min(100, (int)(sliderPositionFraction * 100.0));
        sliderValue = Math.max(1, sliderValue);
        return sliderValue;
    }

    private static double getScaledAcceleration(Percentage speed) {
        double acceleration = MoveNodeWithOptiMove.getScaledAcceleration((double)speed.getValue());
        if (acceleration > 0.01) {
            acceleration = BigDecimal.valueOf(acceleration).setScale(3, RoundingMode.HALF_EVEN).doubleValue();
        }
        return acceleration;
    }
}

