/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.optimove;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.program.internal.TextResource;
import com.ur.program.optimove.SpeedField$AjcClosure1;
import com.ur.swing.ViewContext;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import gui.commandpanels.SpeedFieldParser;
import gui.commandpanels.WaypointCard;
import gui.program.OptiMoveNode;
import gui.program.SpeedValueNode;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.Dimension;
import java.text.Format;
import javax.swing.JLabel;
import javax.swing.text.JTextComponent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

class SpeedField {
    private final TextResource textResource;
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;
    public final NumberField speed;
    public final JLabel label;
    private OptiMoveNode optiMoveNode;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    SpeedField(ViewContext viewContext, WaypointNodeValidationStrategyProvider validationStrategyProvider) {
        this.validationStrategyProvider = validationStrategyProvider;
        this.textResource = (TextResource)viewContext.getTextResource(TextResource.class);
        this.label = viewContext.createWidgetFactory().createLabel(((TextResource)viewContext.getTextResource(TextResource.class)).jointSpeed());
        this.speed = viewContext.createWidgetFactory().createNumberField(actionEvent -> this.speedFieldActionPerformed());
        this.initSpeed(this.speed);
        this.setCartesianSpeed();
    }

    private void initSpeed(NumberField speed) {
        speed.setName(WaypointCard.SPEED_FIELD);
        speed.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        speed.setText("50.0");
        speed.setUnitWidth(55);
        speed.setMode(Mode.PositiveNumbers);
        speed.setPreferredSize(new Dimension(168, 30));
        speed.setMaximumSize(speed.getPreferredSize());
    }

    public void updateField() {
        if (this.optiMoveNode.isCartesianMotion()) {
            this.setCartesianSpeed();
        } else {
            this.setJointSpeed();
        }
        SpeedFieldParser.update((JTextComponent)this.speed, (SpeedValueNode)this.optiMoveNode);
    }

    private void setJointSpeed() {
        this.label.setText(this.textResource.jointSpeed());
        this.speed.setUnit(Units.getText().unitDegS());
        this.speed.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getJointSpeedLimitValidator()});
    }

    public void setOptiMoveNode(OptiMoveNode optiMoveNode) {
        this.optiMoveNode = optiMoveNode;
    }

    public void setEnabled(boolean selected) {
        this.speed.setEnabled(selected);
    }

    private void setCartesianSpeed() {
        this.label.setText(this.textResource.toolSpeed());
        this.speed.setUnit(Units.getText().unitMmS());
        this.speed.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointSpeedLimitValidator()});
    }

    @CompoundProgramChange
    private void speedFieldActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        SpeedField$AjcClosure1 speedField$AjcClosure1 = new SpeedField$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(speedField$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    static {
        SpeedField.ajc$preClinit();
    }

    static final /* synthetic */ void speedFieldActionPerformed_aroundBody0(SpeedField ajc$this, JoinPoint joinPoint) {
        SpeedFieldParser.parse((JTextComponent)ajc$this.speed, (SpeedValueNode)ajc$this.optiMoveNode);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("SpeedField.java", SpeedField.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "speedFieldActionPerformed", "com.ur.program.optimove.SpeedField", "", "", "", "void"), 75);
    }
}

