/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.script;

import com.ur.i18n.TextResource;
import com.ur.log.SuggestionProvider;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.util.event.EventManager;
import com.ur.util.logging.Log;
import com.ur.util.swing.HTML;
import com.ur.view.program.PlayProgramListener;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import java.awt.Color;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;

@Singleton
public class ScriptErrorDetailsCreator
implements SuggestionProvider {
    private static final int MARGIN = 15;
    private static final int CHARACTERS_TO_SHOW = 80;
    private static final int CHARACTERS_IN_ERROR = 40;
    private static final int LINES_BEFORE_ERROR = 4;
    private static final int LINES_AFTER_ERROR = 3;
    private static final String CONTINUATION_DOTS = "...";
    private static final int MAX_KEY_PIXELS = 150;
    private static final int MAX_VALUE_PIXELS = 350;
    private static final int MAX_NUMBER_OF_LINES = 4;
    private final ProgramLookupService programLookupService;
    private final TextResource textResource;
    private String scriptCode;
    Map<String, String> scriptError = new LinkedHashMap<String, String>();
    Map<String, String> urCapInfo = new LinkedHashMap<String, String>();

    @Inject
    public ScriptErrorDetailsCreator(EventManager eventManager, ProgramLookupService programLookupService, TextResource textResource) {
        eventManager.addStrongListener(PlayProgramListener.class, (Object)new PlayProgramListener(){

            public void preparingPlay(ProgramRootNode program) {
            }

            public void playing(ProgramRootNode programRootNode, ScriptWriter writer) {
                ScriptErrorDetailsCreator.this.scriptCode = writer.toString();
                if (Log.canLog((Log.Level)Log.Level.TRACE)) {
                    Log.trace((String)ScriptErrorDetailsCreator.this.scriptCode);
                }
            }
        });
        this.programLookupService = programLookupService;
        this.textResource = textResource;
    }

    public String getSuggestion(RobotMessage message) {
        return this.createDetails(message);
    }

    public String createDetails(RobotMessage rm) {
        ScriptWriter.ScriptPosition errorPosition = (ScriptWriter.ScriptPosition)rm.extraData;
        ScriptGenerator scriptGenerator = this.getScriptGenerator(errorPosition);
        String details = "";
        if (scriptGenerator != null) {
            this.extractUrcapInfoFromSciptError(scriptGenerator);
            details = HTML.html((String)(String.valueOf(this.getDetailsAsHtml()) + this.createCodeSnippetAsHtml(errorPosition) + this.getUrcapMetaDeta()));
        }
        return details;
    }

    private String getAsHtml(Map<String, String> info, boolean isBold) {
        String table = "";
        String rows = "";
        for (Map.Entry<String, String> label : info.entrySet()) {
            String key = HTML.truncateLongWordsWithDots((double)150.0, (String)label.getKey().toString());
            String text = label.getValue().toString();
            text = HTML.truncateLongWordsWithDots((double)350.0, (String)text);
            String value = HTML.truncateTextWithDots((double)1400.0, (String)text);
            rows = isBold ? String.valueOf(rows) + HTML.tableRow((String[])new String[]{HTML.tableCellAlignTop((String)HTML.maxWidth((int)150, (String)this.createCellContent(key))), HTML.tableCellAlignTop((String)HTML.maxWidth((int)350, (String)HTML.fontBold((String)this.createCellContent(value))))}) : String.valueOf(rows) + HTML.tableRow((String[])new String[]{HTML.tableCellAlignTop((String)HTML.maxWidth((int)150, (String)this.createCellContent(key))), HTML.tableCellAlignTop((String)HTML.maxWidth((int)350, (String)this.createCellContent(value)))});
        }
        table = HTML.tableWithProperties((String)"", (String[])new String[]{rows});
        return rows.isEmpty() ? "" : String.valueOf(table) + HTML.br();
    }

    private String getUrcapMetaDeta() {
        String urCapMetaData = "";
        if (!this.urCapInfo.isEmpty()) {
            urCapMetaData = String.valueOf(HTML.br()) + HTML.hr((String)Color.black.toString()) + HTML.br();
            urCapMetaData = String.valueOf(urCapMetaData) + this.getAsHtml(this.urCapInfo, true);
        }
        return urCapMetaData;
    }

    private void extractUrcapInfoFromSciptError(ScriptGenerator scriptGenerator) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(String.valueOf(this.textResource.urcapName()) + ":");
        info.add(String.valueOf(this.textResource.urcapVersion()) + ":");
        info.add(String.valueOf(this.textResource.Developer()) + ":");
        info.add(String.valueOf(this.textResource.urcapContactinfo()) + ":");
        for (Map.Entry label : scriptGenerator.getScriptError().getLabels().entrySet()) {
            if (info.contains(label.getKey())) {
                this.urCapInfo.put(label.getKey().toString(), label.getValue().toString());
                continue;
            }
            this.scriptError.put(label.getKey().toString(), label.getValue().toString());
        }
    }

    private String getDetailsAsHtml() {
        return this.getAsHtml(this.scriptError, false);
    }

    private String createCellContent(Object cell) {
        String cellContent = cell.toString().trim();
        return cellContent.isEmpty() ? HTML.space() : HTML.convertToHtml((String)cellContent);
    }

    protected ScriptGenerator getScriptGenerator(ScriptWriter.ScriptPosition errorPosition) {
        ProgramRootNode programRootNode = this.getProgramRootNode();
        return programRootNode == null ? null : programRootNode.getScriptGeneratorLookup().findScriptGenerator(errorPosition);
    }

    protected String createCodeSnippetAsHtml(ScriptWriter.ScriptPosition errorPosition) {
        String snippetHeader = HTML.p((String)HTML.fontBold((String)this.textResource.scriptCode()));
        String position = this.getPositionTextFromResource(errorPosition);
        position = HTML.p((String)position);
        String snippetCode = this.makeSnippet(errorPosition);
        return String.valueOf(snippetHeader) + HTML.indent((int)8, (int)15, (int)0, (int)0, (String)(String.valueOf(position) + snippetCode));
    }

    private String getPositionTextFromResource(ScriptWriter.ScriptPosition errorPosition) {
        return errorPosition.getColumn() == 0 ? String.valueOf(this.textResource.errorPosition()) + " " + this.textResource.linePosition(Integer.toString(errorPosition.getLine())) : this.textResource.positionInScript(Integer.toString(errorPosition.getLine()), Integer.toString(errorPosition.getColumn()));
    }

    private String makeSnippet(ScriptWriter.ScriptPosition errorPosition) {
        ScriptWriter.ScriptPosition errorLine = new ScriptWriter.ScriptPosition(errorPosition.getLine());
        ScriptWriter.ScriptPosition prologStart = errorLine.add(new ScriptWriter.ScriptPosition(-4, 0));
        ScriptWriter.ScriptPosition epilogStop = errorLine.add(new ScriptWriter.ScriptPosition(3, 0));
        int smallestIndentation = this.calculateIndentation(errorLine);
        String continuationProlog = this.makeContinuationProlog(prologStart);
        String prolog = this.makeProlog(prologStart, errorLine, smallestIndentation);
        String erorLine = this.formatErrorLine(errorPosition, smallestIndentation);
        String epilog = this.makeEpilog(errorLine, epilogStop, smallestIndentation);
        String continuationEpilog = this.makeContinuationEpilog(epilogStop);
        return HTML.pre((String)(String.valueOf(continuationProlog) + prolog + erorLine + epilog + continuationEpilog));
    }

    private int calculateIndentation(ScriptWriter.ScriptPosition errorLine) {
        ScriptWriter.ScriptPosition prologStart = errorLine.add(new ScriptWriter.ScriptPosition(-4, 0));
        ScriptWriter.ScriptPosition epilogStop = errorLine.add(new ScriptWriter.ScriptPosition(3, 0));
        ScriptGeneratorLookup.Range snippetRange = new ScriptGeneratorLookup.Range(prologStart, epilogStop);
        String[] snippet = this.codeFromRange(snippetRange);
        int smallestIndentation = this.findSmallestIndentation(snippet);
        return smallestIndentation;
    }

    private String makeContinuationProlog(ScriptWriter.ScriptPosition prologStart) {
        ScriptWriter.ScriptPosition scriptStart = new ScriptWriter.ScriptPosition(1);
        return scriptStart.less(prologStart) ? "...\n" : "";
    }

    private String makeProlog(ScriptWriter.ScriptPosition prologStart, ScriptWriter.ScriptPosition errorLine, int smallestIndentation) {
        ScriptGeneratorLookup.Range prologRange = new ScriptGeneratorLookup.Range(prologStart, errorLine);
        String prolog = this.formattedCode(prologRange, smallestIndentation);
        return prolog;
    }

    private String formatErrorLine(ScriptWriter.ScriptPosition errorPosition, int smallestIndentation) {
        ScriptWriter.ScriptPosition nextLine;
        ScriptWriter.ScriptPosition errorLine = new ScriptWriter.ScriptPosition(errorPosition.getLine());
        ScriptGeneratorLookup.Range errorRange = new ScriptGeneratorLookup.Range(errorLine, nextLine = errorLine.add(new ScriptWriter.ScriptPosition(1, 0)));
        String[] snippetLines = this.codeFromRange(errorRange);
        String codeLine = snippetLines.length == 1 ? snippetLines[0] : "";
        codeLine = smallestIndentation <= codeLine.length() ? codeLine.substring(smallestIndentation) : "";
        int errorColumn = errorPosition.getColumn() - smallestIndentation - 1;
        if (errorColumn < 0 || errorColumn >= codeLine.length()) {
            errorColumn = 0;
        }
        if (codeLine.length() > 80) {
            if (errorColumn + 40 > 80) {
                int toMany = errorColumn + 40 - 80;
                codeLine = CONTINUATION_DOTS + codeLine.substring(toMany + 3);
                errorColumn -= toMany;
            }
            if (codeLine.length() > 80) {
                codeLine = String.valueOf(codeLine.substring(0, 77)) + CONTINUATION_DOTS;
            }
        }
        String preCode = HTML.convertToHtml((String)codeLine.substring(0, errorColumn));
        String errorCode = HTML.convertToHtml((String)codeLine.substring(errorColumn));
        String code = String.valueOf(preCode) + HTML.fontColor((String)"red", (String)errorCode);
        return String.valueOf(HTML.fontBold((String)code)) + "\n";
    }

    private String makeEpilog(ScriptWriter.ScriptPosition errorLine, ScriptWriter.ScriptPosition epilogStop, int smallestIndentation) {
        ScriptWriter.ScriptPosition epilogStart = errorLine.add(new ScriptWriter.ScriptPosition(1, 0));
        ScriptGeneratorLookup.Range epilogRange = new ScriptGeneratorLookup.Range(epilogStart, epilogStop);
        String epilog = this.formattedCode(epilogRange, smallestIndentation);
        return epilog;
    }

    private String makeContinuationEpilog(ScriptWriter.ScriptPosition epilogStop) {
        ScriptWriter.ScriptPosition scriptEnd = ScriptWriter.ScriptPosition.getEndPostion((String)this.getScriptCode());
        return scriptEnd.larger(epilogStop) ? "...\n" : "";
    }

    private int findSmallestIndentation(String[] lines) {
        int smallestIndentation = Integer.MAX_VALUE;
        int i = 0;
        while (i < lines.length) {
            int indentation = StringUtils.indexOfAnyBut((String)lines[i], (String)" ");
            smallestIndentation = indentation == -1 ? smallestIndentation : Math.min(smallestIndentation, indentation);
            ++i;
        }
        return smallestIndentation == Integer.MAX_VALUE ? 0 : smallestIndentation;
    }

    public String getScriptCodePart(ScriptGeneratorLookup.Range range) {
        String scriptCode = this.getScriptCode();
        int beginIndex = range.getStart().index(scriptCode);
        int endIndex = range.getNext().index(scriptCode);
        return scriptCode != null ? scriptCode.substring(beginIndex, endIndex) : "";
    }

    private String[] codeFromRange(ScriptGeneratorLookup.Range range) {
        return this.getScriptCodePart(range).split("\n");
    }

    private String getScriptCode() {
        ProgramRootNode programRootNode = this.getProgramRootNode();
        return programRootNode == null ? "" : this.scriptCode;
    }

    private String formattedCode(ScriptGeneratorLookup.Range range, int smallestIndentation) {
        String[] snippetLines = this.codeFromRange(range);
        return this.linesToParagraphs(snippetLines, smallestIndentation);
    }

    private String linesToParagraphs(String[] lines, int smallestIndentation) {
        String paragraphs = "";
        int i = 0;
        while (i < lines.length) {
            String line = lines[i];
            if ((line = line.substring(Math.min(smallestIndentation, line.length()))).length() > 80) {
                line = String.valueOf(line.substring(0, 77)) + CONTINUATION_DOTS;
            }
            paragraphs = String.valueOf(paragraphs) + HTML.convertToHtml((String)line) + "\n";
            ++i;
        }
        return paragraphs;
    }

    private ProgramRootNode getProgramRootNode() {
        ProgramRootNode programRootNode = this.programLookupService.getProgramRootNode();
        return programRootNode;
    }
}

