/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.script;

import com.ur.i18n.TextResource;
import com.ur.log.logentry.robotmessage.RobotMessage;
import com.ur.polyscope.installation.InstallationScriptGenerator;
import com.ur.polyscope.program.ProgramModeHolder;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.program.edit.infrastructure.CommandTab;
import com.ur.program.script.ScriptErrorDetailsCreator;
import com.ur.swing.dialog.URDialogPanel;
import com.ur.swing.flippable.FlippablePanel;
import com.ur.util.event.EventManager;
import com.ur.view.help.HelpLoader;
import gui.installation.services.ProgramLookupService;
import gui.polyscope.InstallationTreeSelector;
import gui.polyscope.ProgramTab;
import gui.program.ProgramRootNode;
import gui.tools.dialogs.MessageDialogPanel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScriptErrorDialogCreator
extends ScriptErrorDetailsCreator {
    private final ProgramModeHolder programModeHolder;
    private final InstallationTreeSelector installationTreeSelector;
    private final TextResource textResource;
    private FlippablePanel mainPanel;

    @Inject
    public ScriptErrorDialogCreator(EventManager eventManager, ProgramLookupService programLookupService, ProgramModeHolder programModeHolder, InstallationTreeSelector installationTreeSelector, FlippablePanel mainPanel, TextResource textResource) {
        super(eventManager, programLookupService, textResource);
        this.programModeHolder = programModeHolder;
        this.installationTreeSelector = installationTreeSelector;
        this.mainPanel = mainPanel;
        this.textResource = textResource;
    }

    public URDialogPanel create(RobotMessage robotMessage) {
        WarningParameters wp = new WarningParameters(this, robotMessage);
        return MessageDialogPanel.createWarningDialog((MessageDialogPanel.DialogParameters)new MessageDialogPanel.DialogParameters(wp.message, wp.scriptError, wp.urCapInfo, wp.codeSnippet, wp.goToProblem, (Runnable)wp.showScriptErrorAction));
    }

    private class ShowScriptErrorAction
    implements Runnable {
        private final ScriptGenerator scriptGenerator;

        ShowScriptErrorAction(ScriptGenerator scriptGenerator) {
            this.scriptGenerator = scriptGenerator;
        }

        @Override
        public void run() {
            if (this.scriptGenerator instanceof AbstractProgramNode) {
                this.takeMeHome();
                CommandTab commandTab = CommandTab.getInstance();
                commandTab.switchTo(ProgramTab.class);
                commandTab.switchTo(CommandTab.class);
                AbstractProgramNode programNode = (AbstractProgramNode)this.scriptGenerator;
                commandTab.showCardFor(programNode);
                ((ProgramSelectionModel)ProgramRootNode.get((AbstractProgramNode)programNode).getComponent(ProgramSelectionModel.class)).setSelected(programNode);
            } else if (this.scriptGenerator instanceof InstallationScriptGenerator) {
                this.takeMeHome();
                CommandTab commandTab = CommandTab.getInstance();
                commandTab.switchTo(ScriptErrorDialogCreator.this.installationTreeSelector.getPanelClass());
                ScriptErrorDialogCreator.this.installationTreeSelector.selectTreeNode(((InstallationScriptGenerator)this.scriptGenerator).getInstallationNode());
            }
        }

        public void takeMeHome() {
            ScriptErrorDialogCreator.this.mainPanel.resetAll();
            boolean helpGlass = HelpLoader.isHelpIconsShowing();
            if (helpGlass) {
                HelpLoader.resetHelp();
            }
        }
    }

    public class WarningParameters {
        final ScriptErrorDialogCreator scriptErrorDialogCreator;
        public String message = "";
        public Map<String, String> scriptError = new LinkedHashMap<String, String>();
        public Map<String, String> urCapInfo = new LinkedHashMap<String, String>();
        public String codeSnippet = "";
        public String goToProblem = "";
        public ShowScriptErrorAction showScriptErrorAction = null;

        public WarningParameters(ScriptErrorDialogCreator scriptErrorDialogCreator2, RobotMessage robotMessage) {
            this.scriptErrorDialogCreator = scriptErrorDialogCreator2;
            ScriptWriter.ScriptPosition errorPosition = (ScriptWriter.ScriptPosition)robotMessage.extraData;
            ScriptGenerator scriptGenerator = scriptErrorDialogCreator2.getScriptGenerator(errorPosition);
            this.message = robotMessage.toString();
            if (scriptGenerator != null) {
                this.extractURCapInfo(scriptGenerator);
                this.codeSnippet = scriptErrorDialogCreator2.createCodeSnippetAsHtml(errorPosition);
                ProgramModeHolder.ProgramMode programMode = scriptErrorDialogCreator2.programModeHolder.getMode();
                this.goToProblem = programMode != ProgramModeHolder.ProgramMode.ReadOnly ? ScriptErrorDialogCreator.this.textResource.goToProblem() : "";
                this.showScriptErrorAction = new ShowScriptErrorAction(scriptGenerator);
            }
        }

        private void extractURCapInfo(ScriptGenerator scriptGenerator) {
            ArrayList<String> info = new ArrayList<String>();
            info.add(String.valueOf(ScriptErrorDialogCreator.this.textResource.urcapName()) + ":");
            info.add(String.valueOf(ScriptErrorDialogCreator.this.textResource.urcapVersion()) + ":");
            info.add(String.valueOf(ScriptErrorDialogCreator.this.textResource.Developer()) + ":");
            info.add(String.valueOf(ScriptErrorDialogCreator.this.textResource.urcapContactinfo()) + ":");
            for (Map.Entry label : scriptGenerator.getScriptError().getLabels().entrySet()) {
                if (info.contains(label.getKey())) {
                    this.urCapInfo.put(label.getKey().toString(), label.getValue().toString());
                    continue;
                }
                this.scriptError.put(label.getKey().toString(), label.getValue().toString());
            }
        }
    }
}

