/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.search;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.program.internal.ProgramImageResource;
import com.ur.program.search.SearchBackendService;
import com.ur.program.search.SearchListener;
import com.ur.program.search.SearchModel;
import com.ur.program.search.SearchView;
import com.ur.swing.CompletedListener;
import com.ur.swing.FontFactory;
import com.ur.swing.SwingUtil;
import com.ur.swing.URFontFactory;
import com.ur.swing.help.HelpIdAssigner;
import com.ur.swing.text.TextFieldUtils;
import com.ur.swing.text.TextHolder;
import com.ur.swing.validation.ValidationStrategy;
import gui.commandpanels.ControlProgramTreeStructure;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;

public class JSearchTextField
extends JPanel
implements SearchView {
    public static final GridBagConstraints LOCKED_WIDTH = new GridBagConstraints(){
        {
            this.weightx = 0.0;
        }
    };
    public static final GridBagConstraints EXPANDING_WIDTH = new GridBagConstraints(){
        {
            this.weightx = 10.0;
            this.fill = 2;
        }
    };
    private final JTextField textField;
    private final JLabel count;
    private final JButton previousButton;
    private final JButton nextButton;
    private final JLabel spacer;
    private final JButton closeButton;
    private final ControlProgramTreeStructure controlProgramTreeStructure;
    private final SearchBackendService searchBackendService;
    private final JSeparator verticalDivide;
    SearchListener searchListener;

    public JSearchTextField(ControlProgramTreeStructure controlProgramTreeStructure, final SearchBackendService searchBackendService, HelpIdAssigner helpIdAssigner) {
        this.controlProgramTreeStructure = controlProgramTreeStructure;
        this.searchBackendService = searchBackendService;
        this.textField = new JTextField();
        searchBackendService.setSearchView(this);
        this.setBackground(Color.WHITE);
        this.setBorder(UIManager.getBorder("TextField.border"));
        this.textField.setBorder(BorderFactory.createEmptyBorder());
        this.textField.setFocusable(false);
        this.textField.setEditable(false);
        this.count = new JLabel();
        this.count.setFont(new FontFactory().getRelativeFont((URFontFactory.Size)UIManager.get("SearchResults.fontSize")));
        this.count.setForeground(UIManager.getColor("SearchResults.color"));
        this.count.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.count.setHorizontalAlignment(4);
        this.verticalDivide = new JSeparator(1);
        this.verticalDivide.setForeground(Color.lightGray);
        this.verticalDivide.setBorder(BorderFactory.createEmptyBorder(2, 0, 2, 0));
        this.verticalDivide.setPreferredSize(new Dimension(1, 28));
        this.spacer = new JLabel();
        this.spacer.setPreferredSize(new Dimension(8, 5));
        this.spacer.setMinimumSize(new Dimension(8, 5));
        this.previousButton = new JButton(ProgramImageResource.arrowPreviousSearch());
        this.previousButton.setBorder(UIManager.getBorder("SearchButton.border"));
        this.previousButton.setEnabled(false);
        this.previousButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchBackendService.previousNode();
            }
        });
        this.nextButton = new JButton(ProgramImageResource.arrowNextSearch());
        this.nextButton.setEnabled(false);
        this.nextButton.setBorder(UIManager.getBorder("SearchButton.border"));
        this.nextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                searchBackendService.nextNode();
            }
        });
        this.closeButton = new JButton(ProgramImageResource.programSearchExit());
        this.closeButton.setBorder(UIManager.getBorder("SearchButton.border"));
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JSearchTextField.this.textField.setText("");
            }
        });
        TextFieldUtils.bindTextPicker((JComponent)this.textField, (TextHolder)new TextHolder(){

            public String getText() {
                return JSearchTextField.this.textField.getText();
            }

            public void setText(String text) {
                JSearchTextField.this.textField.setText(text.trim());
            }
        }, (CompletedListener)new CompletedListener(){

            public void requestApply() {
                JSearchTextField.this.searchListener.searchWordEvent(JSearchTextField.this.textField.getText());
            }

            public void requestCancel() {
            }
        }, (ValidationStrategy)ValidationStrategy.ALWAYS_VALID);
        this.addPropertyChangeListener("visible", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                JSearchTextField thisPanel = JSearchTextField.this;
                if (thisPanel.getComponentCount() > 3 && thisPanel.getWidth() < 250) {
                    JSearchTextField.this.hideNavigation();
                }
                if (thisPanel.getComponentCount() < 3 && thisPanel.getWidth() > 250) {
                    JSearchTextField.this.showNavigation();
                }
            }
        });
        this.buildLayout();
        helpIdAssigner.assignHelpId((JComponent)this, "gui:search_functionality");
    }

    private void buildLayout() {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.textField, EXPANDING_WIDTH);
        this.add((Component)this.verticalDivide, LOCKED_WIDTH);
        this.add((Component)this.closeButton, LOCKED_WIDTH);
    }

    @Override
    public void updateUI(SearchModel searchModel) {
        boolean enableNavigation = searchModel.totalCount > 0;
        this.previousButton.setEnabled(enableNavigation);
        this.nextButton.setEnabled(enableNavigation);
        if (enableNavigation) {
            this.showNavigation();
        }
        if (searchModel.selected != null) {
            this.controlProgramTreeStructure.expandPathTo(searchModel.selected);
            if (searchModel.selected instanceof AbstractProgramNode) {
                ((AbstractProgramNode)searchModel.selected).setSelected();
            }
        }
        if (!this.searchBackendService.isSearching()) {
            SwingUtil.invokeLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    JSearchTextField.this.textField.setText("");
                }
            });
            this.hideNavigation();
        }
        this.count.setText("" + (enableNavigation ? (searchModel.index == 0 ? Integer.valueOf(searchModel.totalCount) : String.valueOf(searchModel.index) + "/" + searchModel.totalCount) : (this.textField.getText().isEmpty() ? "" : "0")));
    }

    public void setClearOnClose() {
        this.closeButton.setIcon(ProgramImageResource.programSearch());
        this.textField.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (JSearchTextField.this.textField.getText().isEmpty()) {
                    JSearchTextField.this.closeButton.setIcon(ProgramImageResource.programSearch());
                    JSearchTextField.this.hideNavigation();
                } else {
                    JSearchTextField.this.closeButton.setIcon(ProgramImageResource.programSearchExit());
                    JSearchTextField.this.showNavigation();
                }
            }
        });
    }

    public void addCloseListener(ActionListener listener) {
        this.closeButton.addActionListener(listener);
    }

    public void registerSearchListener(SearchListener searchListener) {
        this.searchListener = searchListener;
    }

    public void showNavigation() {
        if (this.textField.getText().isEmpty() || this.getWidth() < 250) {
            return;
        }
        this.remove(this.textField);
        this.remove(this.verticalDivide);
        this.remove(this.closeButton);
        this.add((Component)this.textField, EXPANDING_WIDTH);
        this.add((Component)this.count, LOCKED_WIDTH);
        this.add((Component)this.verticalDivide, LOCKED_WIDTH);
        this.add((Component)this.previousButton, LOCKED_WIDTH);
        this.add((Component)this.nextButton, LOCKED_WIDTH);
        this.add((Component)this.spacer, LOCKED_WIDTH);
        this.add((Component)this.closeButton, LOCKED_WIDTH);
        this.repaint();
    }

    public void hideNavigation() {
        this.remove(this.count);
        this.remove(this.previousButton);
        this.remove(this.nextButton);
        this.remove(this.spacer);
        this.repaint();
    }
}

