/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.search;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.viewfacade.program.ProgramEventListener;
import com.ur.program.search.SearchModel;
import com.ur.program.search.SearchView;
import com.ur.reversible.Reversible;
import com.ur.reversible.ReversibleAction;
import com.ur.reversible.UndoRedoListener;
import com.ur.util.IterableEnumerationWrapper;
import com.ur.util.event.EventManager;
import gui.installation.services.ProgramLookupService;
import gui.program.ProgramRootNode;
import gui.program.ProgramUndoRedoService;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.tree.TreeNode;

@Singleton
public class SearchBackendService {
    private static final String MATCH_ALL_REGEX = ".*";
    private ArrayList<TreeNode> matches = new ArrayList();
    private final ProgramLookupService lookupService;
    private SearchView searchView = new SearchView(){

        @Override
        public void updateUI(SearchModel searchModel) {
        }
    };
    private boolean isSearching = false;
    private Pattern searchPattern;

    @Inject
    public SearchBackendService(ProgramLookupService lookupService, ProgramUndoRedoService programUndoRedoService, EventManager manager) {
        this.lookupService = lookupService;
        this.searchPattern = null;
        manager.addStrongListener(ProgramEventListener.class, (Object)new ProgramEventListener.Template(){

            public void onPostNewProgram() {
                SearchBackendService.this.beginSearch("");
            }
        });
        programUndoRedoService.addListener((UndoRedoListener)new UndoRedoListener<AbstractProgramNode>(){

            public void perform(ReversibleAction reversibleAction, Reversible<AbstractProgramNode> reversible) {
                if (SearchBackendService.this.isSearching && SearchBackendService.this.searchPattern != null) {
                    SearchBackendService.this.matches.clear();
                    SearchBackendService.this.findMatches();
                    SearchBackendService.this.searchView.updateUI(new SearchModel(null, 0, SearchBackendService.this.matches.size()));
                }
            }
        });
    }

    public void setSearchView(SearchView searchView) {
        this.searchView = searchView;
    }

    public void beginSearch(String str) {
        String simplified = str.toLowerCase().trim();
        this.endSearch();
        if (simplified.isEmpty()) {
            this.searchPattern = null;
            this.searchView.updateUI(new SearchModel(null, 0, 0));
        } else {
            simplified = Pattern.quote(simplified);
            this.searchPattern = Pattern.compile(MATCH_ALL_REGEX + simplified + MATCH_ALL_REGEX);
            this.isSearching = true;
            this.findMatches();
            this.searchView.updateUI(new SearchModel(null, 0, this.matches.size()));
        }
    }

    public void continueSearch() {
        this.isSearching = true;
    }

    public void endSearch() {
        this.matches.clear();
        this.isSearching = false;
        this.searchPattern = null;
    }

    public boolean isSearching() {
        return this.isSearching;
    }

    private boolean matches(String s) {
        if (this.searchPattern == null) {
            return false;
        }
        return this.searchPattern.matcher(s.toLowerCase()).matches();
    }

    public boolean matches(AbstractProgramNode node) {
        return this.isSearching && this.matches(node.toString());
    }

    private void findMatches() {
        Enumeration allNodes = this.lookupService.getProgramRootNode().depthFirstEnumeration();
        for (TreeNode each : new IterableEnumerationWrapper(allNodes)) {
            if (each instanceof ProgramRootNode || !this.matches(each.toString()) || !this.pathToRootIsExpandable(each)) continue;
            this.matches.add(each);
        }
    }

    private boolean pathToRootIsExpandable(TreeNode each) {
        if (!(each instanceof AbstractProgramNode)) {
            return false;
        }
        AbstractProgramNode node = (AbstractProgramNode)each.getParent();
        while (node != null) {
            if (!node.isTreeExpandable()) {
                return false;
            }
            node = (AbstractProgramNode)node.getParent();
        }
        return true;
    }

    public void nextNode() {
        AbstractProgramNode node = this.lookupService.getSelectedNode();
        int index = this.matches.indexOf(node) + 1;
        if (index >= this.matches.size()) {
            index = 0;
        }
        this.searchView.updateUI(new SearchModel(this.matches.get(index), index + 1, this.matches.size()));
    }

    public void previousNode() {
        AbstractProgramNode node = this.lookupService.getSelectedNode();
        int index = this.matches.indexOf(node) - 1;
        if (index < 0) {
            index = this.matches.size() - 1;
        }
        this.searchView.updateUI(new SearchModel(this.matches.get(index), index + 1, this.matches.size()));
    }
}

