/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.domain;

import com.ur.lang.EqualsUtil;
import com.ur.lang.StringUtils;
import com.ur.lang.naming.NamedEntity;
import com.ur.lang.naming.NamingService;
import com.ur.lang.naming.NamingStrategy;
import com.ur.move.PositionReference;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.program.waypoint.domain.WaypointNamingStrategy$AjcClosure1;
import gui.program.position.MeasuredWaypointScriptGeneration;
import gui.program.position.WaypointNode;
import gui.tools.LanguagePack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class WaypointNamingStrategy
extends NamingStrategy {
    private final NamingService namingService;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    WaypointNamingStrategy(NamingService namingService) {
        super(WaypointNode.class);
        this.namingService = namingService;
    }

    public void setName(NamedEntity entity, String nameCandidate) {
        boolean needToSetName;
        if (StringUtils.isNullOrOnlyWhitespace((String)nameCandidate) || EqualsUtil.equals((Object)nameCandidate, (Object)LanguagePack.getDefaultWaypointName())) {
            return;
        }
        WaypointNode waypoint = (WaypointNode)entity;
        nameCandidate = this.convertToValidName(nameCandidate);
        if (waypoint.getPositionNodeType() == PositionNodeType.VARIABLE) {
            return;
        }
        List sameNameEntities = this.namingService.getEntitiesWithName(nameCandidate);
        sameNameEntities.remove(waypoint);
        PositionReference closestPR = null;
        if (!sameNameEntities.isEmpty()) {
            boolean conflictsExist;
            ArrayList<PositionReference> positionReferencesToLink = new ArrayList<PositionReference>();
            Iterator sameNameEntityIterator = sameNameEntities.iterator();
            while (sameNameEntityIterator.hasNext()) {
                NamedEntity each = (NamedEntity)sameNameEntityIterator.next();
                if (each instanceof WaypointNode && !((WaypointNode)each).isLinkable() || !(each instanceof PositionReference)) continue;
                PositionReference positionReference = (PositionReference)each;
                if (!waypoint.isLinkedTo(positionReference)) {
                    positionReferencesToLink.add(positionReference);
                }
                sameNameEntityIterator.remove();
            }
            boolean bl = conflictsExist = sameNameEntities.size() > 0 || positionReferencesToLink.size() > 0;
            if (conflictsExist) {
                boolean linkWaypoint;
                closestPR = this.findClosestPositionReference(waypoint, positionReferencesToLink);
                boolean bl2 = linkWaypoint = sameNameEntities.size() == 0 && positionReferencesToLink.size() > 0 && waypoint.isLinkable();
                if (!linkWaypoint) {
                    closestPR = null;
                    nameCandidate = EqualsUtil.equals((Object)waypoint.getName(), (Object)nameCandidate) ? this.namingService.makeUniqueName(WaypointNode.class, nameCandidate) : waypoint.getName();
                }
            }
        }
        boolean bl = needToSetName = !EqualsUtil.equals((Object)waypoint.getName(), (Object)nameCandidate);
        if (needToSetName) {
            List entities = this.namingService.getEntitiesWithName(waypoint.getName());
            this.setWaypointName(nameCandidate, waypoint, entities);
            waypoint.textHasChanged();
        }
        if (closestPR != null) {
            List linkedWaypoints = this.namingService.getEntitiesWithName(waypoint.getName());
            this.linkPositionReferenceWaypoints(waypoint, linkedWaypoints, closestPR);
        }
    }

    public List<String> getAdditionalReservedNames(String nameCandidate) {
        ArrayList<String> additionalReservedNames = new ArrayList<String>();
        additionalReservedNames.add(MeasuredWaypointScriptGeneration.getPoseVariableName((String)nameCandidate));
        additionalReservedNames.add(MeasuredWaypointScriptGeneration.getPoseVariableRelativeFromName((String)nameCandidate));
        additionalReservedNames.add(MeasuredWaypointScriptGeneration.getPoseVariableRelativeToName((String)nameCandidate));
        additionalReservedNames.add(MeasuredWaypointScriptGeneration.getQnearVariableName((String)nameCandidate));
        return additionalReservedNames;
    }

    public void linkPositionReferenceWaypoints(WaypointNode waypoint, Iterable<NamedEntity> linkedWaypoints, PositionReference positionReference) {
        waypoint.linkTo(positionReference);
        waypoint.textHasChanged();
        for (NamedEntity e : linkedWaypoints) {
            if (e == waypoint || e == positionReference || !(e instanceof WaypointNode)) continue;
            WaypointNode linkedWaypoint = (WaypointNode)e;
            linkedWaypoint.linkTo(positionReference);
            linkedWaypoint.textHasChanged();
        }
    }

    private void setWaypointName(String nameCandidate, WaypointNode waypoint, List<NamedEntity> entities) {
        if (entities.size() > 1) {
            this.makeAllLinkedWaypointNamesSame(entities, nameCandidate, waypoint);
        } else {
            waypoint.setName(nameCandidate);
        }
    }

    @CompoundProgramChange
    private void makeAllLinkedWaypointNamesSame(List<NamedEntity> sameNameEntities, String nameCandidate, WaypointNode waypoint) {
        List<NamedEntity> list = sameNameEntities;
        String string = nameCandidate;
        WaypointNode waypointNode = waypoint;
        Object[] objectArray = new Object[]{list, string, waypointNode};
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object[])objectArray);
        Object[] objectArray2 = new Object[]{this, list, string, waypointNode, joinPoint};
        WaypointNamingStrategy$AjcClosure1 waypointNamingStrategy$AjcClosure1 = new WaypointNamingStrategy$AjcClosure1(objectArray2);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(waypointNamingStrategy$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    private PositionReference findClosestPositionReference(WaypointNode waypoint, Collection<PositionReference> sameNamePRs) {
        PositionReference result = null;
        double closestDist = Double.MAX_VALUE;
        for (PositionReference each : sameNamePRs) {
            double dist;
            if (result == null) {
                result = each;
            }
            if (!((dist = this.distance(each, waypoint)) <= closestDist)) continue;
            closestDist = dist;
            result = each;
        }
        return result;
    }

    private double distance(PositionReference each, WaypointNode waypoint) {
        if (each.isUndefined() || waypoint.isUndefined()) {
            return Double.MAX_VALUE;
        }
        return each.getToolPosition().distance(waypoint.getToolPosition());
    }

    static {
        WaypointNamingStrategy.ajc$preClinit();
    }

    static final /* synthetic */ void makeAllLinkedWaypointNamesSame_aroundBody0(WaypointNamingStrategy ajc$this, List sameNameEntities, String nameCandidate, WaypointNode waypoint, JoinPoint joinPoint) {
        String oldName = waypoint.getName();
        for (NamedEntity each : sameNameEntities) {
            PositionReference positionReference;
            if (each instanceof WaypointNode && !((WaypointNode)each).isLinkable() || !(each instanceof PositionReference) || !waypoint.isLinkedTo(positionReference = (PositionReference)each)) continue;
            ajc$this.namingService.updateName((NamedEntity)positionReference, oldName, nameCandidate);
            positionReference.setName(nameCandidate);
        }
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("WaypointNamingStrategy.java", WaypointNamingStrategy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("2", "makeAllLinkedWaypointNamesSame", "com.ur.program.waypoint.domain.WaypointNamingStrategy", "java.util.List:java.lang.String:gui.program.position.WaypointNode", "sameNameEntities:nameCandidate:waypoint", "", "void"), 132);
    }
}

