/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.externalapi;

import com.ur.lang.react.Recipe;
import com.ur.monitor.RobotState;
import com.ur.monitor.Source;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.JointPaintStrategy;
import com.ur.move.MoveTabPanel;
import com.ur.move.MoveTabPointStrategy;
import com.ur.move.Position;
import com.ur.polyscope.program.nodes.move.PositionNodeType;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.robot.configuration.kinematics.KinematicsCalibration;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.polyscope.visualizer.j3dcomponents.J3DComponent;
import com.ur.program.waypoint.externalapi.RelativeWaypointMoveTabStrategy$AjcClosure1;
import com.ur.view.hmc.KinematicsControllerRPC;
import gui.program.position.MeasuredPosition;
import gui.program.position.MeasuredWaypointNode;
import gui.program.position.PositionNode;
import gui.program.position.WaypointNode;
import javax.inject.Inject;
import javax.inject.Provider;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class RelativeWaypointMoveTabStrategy
implements MoveTabPointStrategy {
    private final Provider<KinematicsCalibration> calibrationProvider;
    private final KinematicsControllerRPC rpc;
    private Position fromPosition = null;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    @Inject
    public RelativeWaypointMoveTabStrategy(@Source(value=KinematicsCalibration.class) Recipe<KinematicsCalibration> calibrationRecipe, KinematicsControllerRPC rpc) {
        this.calibrationProvider = calibrationRecipe.lastProvider();
        this.rpc = rpc;
    }

    public boolean useStrategy(Object o) {
        return o instanceof WaypointNode && ((WaypointNode)o).getPositionNodeType() == PositionNodeType.RELATIVE;
    }

    public void onExit() {
        this.fromPosition = null;
    }

    public boolean hasVisualComponent() {
        return false;
    }

    public J3DComponent getComponent() {
        return null;
    }

    @CompoundProgramChange
    public void setPosition(Object o, RobotState robotState) {
        Object object = o;
        RobotState robotState2 = robotState;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)object, (Object)robotState2);
        Object[] objectArray = new Object[]{this, object, robotState2, joinPoint};
        RelativeWaypointMoveTabStrategy$AjcClosure1 relativeWaypointMoveTabStrategy$AjcClosure1 = new RelativeWaypointMoveTabStrategy$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(relativeWaypointMoveTabStrategy$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void onEnter(Object o, JointPaintStrategy paintJointsStrategy, MoveTabPanel moveTabPanel) {
        WaypointNode wn = (WaypointNode)o;
        if (wn.isGettingFromPosition()) {
            paintJointsStrategy.hideTargetPositions();
        } else {
            JointPositionVector shaddow = wn.getRelativeFromJointPositionVector();
            if (shaddow.isUndefined()) {
                RobotState robotState = RobotState.getLatestRobotState();
                this.fromPosition = new MeasuredPosition(robotState.jointPosition, Pose6dTransformUtils.getTransform3D((Pose6d)robotState.tcpOffset), (KinematicsCalibration)this.calibrationProvider.get());
            }
        }
        moveTabPanel.showOkCancelPanel();
    }

    public JointPositionVector getShadowJPV(Object o) {
        MeasuredWaypointNode wn = (MeasuredWaypointNode)o;
        if (wn.isGettingFromPosition()) {
            return null;
        }
        JointPositionVector result = wn.getActualFromJointPositionVector();
        if (result.isUndefined()) {
            RobotState robotState = RobotState.getLatestRobotState();
            result = robotState.jointPosition;
        }
        return result;
    }

    static {
        RelativeWaypointMoveTabStrategy.ajc$preClinit();
    }

    static final /* synthetic */ void setPosition_aroundBody0(RelativeWaypointMoveTabStrategy ajc$this, Object o, RobotState robotState, JoinPoint joinPoint) {
        PositionNode pn = (PositionNode)o;
        if (pn instanceof WaypointNode) {
            WaypointNode wn = (WaypointNode)pn;
            if (ajc$this.fromPosition != null) {
                wn.setRelativeFromPosition(ajc$this.fromPosition);
            }
        }
        pn.setPosition((Position)new MeasuredPosition(robotState.jointPosition, Pose6dTransformUtils.getTransform3D((Pose6d)robotState.tcpOffset), (KinematicsCalibration)ajc$this.calibrationProvider.get()));
        pn.setKinematicFlags(ajc$this.rpc.getKinematicFlags());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("RelativeWaypointMoveTabStrategy.java", RelativeWaypointMoveTabStrategy.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setPosition", "com.ur.program.waypoint.externalapi.RelativeWaypointMoveTabStrategy", "java.lang.Object:com.ur.monitor.RobotState", "o:robotState", "", "void"), 61);
    }
}

