/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.lang.DecimalFormatFactory;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.valueobjects.Time;
import com.ur.polyscope.valueobjects.converters.UnitsValueConverterFactory;
import com.ur.program.internal.TextResource;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure1;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure11;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure13;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure3;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure5;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure7;
import com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel$AjcClosure9;
import com.ur.swing.CardPanel;
import com.ur.swing.FormBuilder;
import com.ur.swing.ViewContext;
import com.ur.swing.WidgetFactory;
import com.ur.swing.number.Mode;
import com.ur.swing.number.NumberField;
import com.ur.swing.units.Units;
import com.ur.swing.validation.ValidationStrategy;
import com.ur.util.logging.Log;
import gui.commandpanels.AccelerationFieldParser;
import gui.commandpanels.SpeedFieldParser;
import gui.commandpanels.WaypointCard;
import gui.program.AccelerationValueNode;
import gui.program.SpeedValueNode;
import gui.program.UpdateExecutionFlowComponent;
import gui.program.position.PositionNode;
import gui.program.validation.WaypointNodeValidationStrategyProvider;
import java.awt.event.ItemEvent;
import java.text.Format;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.text.JTextComponent;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

class AdvancedPositionOptionsPanel
extends CardPanel {
    public static final boolean FORCE_SI_UNITS = true;
    private PositionNode positionNode = null;
    private final ViewContext viewContext;
    private JLabel accelerationLabel;
    private JRadioButton sharedRadioButton;
    private JRadioButton speedAccelerationRadioButton;
    private JRadioButton timeRadioButton;
    private NumberField accelerationField;
    private NumberField speedField;
    private NumberField timeField;
    private final WaypointNodeValidationStrategyProvider validationStrategyProvider;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;

    @Inject
    public AdvancedPositionOptionsPanel(ViewContext viewContext, WaypointNodeValidationStrategyProvider waypointNodeValidationStrategyProvider) {
        this.viewContext = viewContext;
        this.validationStrategyProvider = waypointNodeValidationStrategyProvider;
        this.initComponents();
    }

    @CompoundProgramChange
    public void enter(Object o) {
        Object object = o;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)object);
        Object[] objectArray = new Object[]{this, object, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure1 advancedPositionOptionsPanel$AjcClosure1 = new AdvancedPositionOptionsPanel$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public void updateCard() {
        if (this.positionNode == null || this.positionNode.getMotionDefiningNode() == null) {
            Log.error((String)"You must set a positionNode in AdvancedPositionOptionsPanel.");
            return;
        }
        if (this.positionNode.isUsingSharedParameters()) {
            this.sharedRadioButton.setSelected(true);
        } else if (this.positionNode.isUsingNextMotionTime()) {
            if (this.positionNode.isProcessMoveNode()) {
                this.sharedRadioButton.setSelected(true);
            } else {
                this.timeRadioButton.setSelected(true);
            }
        } else {
            this.speedAccelerationRadioButton.setSelected(true);
        }
        this.timeField.setValue((Object)this.positionNode.getNextMotionTime());
        this.setTimeVisibility();
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        if (this.positionNode.isCartesianMotion()) {
            this.speedAccelerationRadioButton.setText(resource.toolSpeed());
            this.speedField.setUnit(Units.getText().unitMmS());
            this.speedField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointSpeedLimitValidator()});
            this.accelerationLabel.setText(resource.toolAcceleration());
            this.accelerationField.setUnit(Units.getText().unitMmS2());
            this.accelerationField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getCartesianJointAccelerationLimitValidator()});
        } else {
            this.speedAccelerationRadioButton.setText(resource.jointSpeed());
            this.speedField.setUnit(Units.getText().unitDegS());
            this.speedField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getJointSpeedLimitValidator()});
            this.accelerationLabel.setText(resource.jointAcceleration());
            this.accelerationField.setUnit(Units.getText().unitDegS2());
            this.accelerationField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getJointAccelerationLimitValidator()});
        }
        if (this.positionNode.isProcessMoveNode() || this.positionNode.isCircleDefiningNode()) {
            this.timeRadioButton.setEnabled(false);
            this.timeField.setEnabled(false);
        } else {
            this.timeRadioButton.setEnabled(true);
        }
        this.timeField.setEnabled(this.timeRadioButton.isSelected());
        this.speedField.setEnabled(this.speedAccelerationRadioButton.isSelected());
        this.accelerationField.setEnabled(this.speedAccelerationRadioButton.isSelected());
        SpeedFieldParser.update((JTextComponent)this.speedField, (SpeedValueNode)this.positionNode);
        AccelerationFieldParser.update((JTextComponent)this.accelerationField, (AccelerationValueNode)this.positionNode);
    }

    private void setTimeVisibility() {
        boolean showTimeOption = this.positionNode != null && !this.positionNode.isProcessMoveNode();
        this.timeField.setEnabled(showTimeOption);
        this.timeRadioButton.setEnabled(showTimeOption);
    }

    private void parseTimeValue() {
        Time value = (Time)this.timeField.getValue();
        this.positionNode.setNextMotionTime(value);
        UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)this.positionNode);
    }

    public void setPositionNode(PositionNode positionNode) {
        this.positionNode = positionNode;
    }

    private void initComponents() {
        TextResource resource = (TextResource)this.viewContext.getTextResource(TextResource.class);
        WidgetFactory factory = this.viewContext.createWidgetFactory();
        this.timeField = factory.createNumberField(evt -> this.timeFieldActionPerformed());
        this.timeField.setValueConverter(UnitsValueConverterFactory.getTimeConverter((boolean)true));
        this.speedField = factory.createNumberField(evt -> this.speedFieldActionPerformed());
        this.speedField.setName(WaypointCard.SPEED_FIELD);
        this.speedField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        this.accelerationField = factory.createNumberField(evt -> this.accelerationFieldActionPerformed());
        this.accelerationField.setName(WaypointCard.ACCELERATION_FIELD);
        this.accelerationField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"###.#"));
        this.sharedRadioButton = new JRadioButton(resource.useSharedParameters());
        this.timeRadioButton = new JRadioButton(resource.Time());
        this.speedAccelerationRadioButton = new JRadioButton(resource.toolSpeed());
        this.accelerationLabel = new JLabel(resource.toolAcceleration());
        this.accelerationLabel.setBorder(BorderFactory.createEmptyBorder(0, 36, 0, 0));
        this.viewContext.createFormBuilder().component((JComponent)this.sharedRadioButton, new FormBuilder.PanelConstraints[]{FormBuilder.PanelConstraints.SPAN_2_COLUMNS}).end().component((JComponent)this.speedAccelerationRadioButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.speedField, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.accelerationLabel, new FormBuilder.PanelConstraints[0]).component((JComponent)this.accelerationField, new FormBuilder.PanelConstraints[0]).end().component((JComponent)this.timeRadioButton, new FormBuilder.PanelConstraints[0]).component((JComponent)this.timeField, new FormBuilder.PanelConstraints[0]).end().end().groupColumns(new int[]{2}).setOnPanel((JPanel)((Object)this));
        this.timeField.setValue((Object)Time.ZERO);
        this.timeField.setFormat((Format)DecimalFormatFactory.createHalfEvenDecimalFormat((String)"0.0"));
        this.timeField.setName(WaypointCard.TIME_FIELD);
        this.speedField.setText("50.0");
        this.speedField.setName(WaypointCard.SPEED_FIELD);
        this.accelerationField.setText("500.0");
        this.accelerationField.setName(WaypointCard.ACCELERATION_FIELD);
        this.timeField.setUnitWidth(55);
        this.speedField.setUnitWidth(55);
        this.accelerationField.setUnitWidth(55);
        this.timeField.setUnit(Units.getText().unitS());
        this.speedField.setUnit(Units.getText().unitMmS());
        this.accelerationField.setUnit(Units.getText().unitMmS2());
        ButtonGroup speedTimeButtonGroup = new ButtonGroup();
        speedTimeButtonGroup.add(this.sharedRadioButton);
        this.sharedRadioButton.setName(WaypointCard.SHARED_PARAMETERS_OPTION);
        this.sharedRadioButton.addItemListener(this::fireUseSharedParameters);
        speedTimeButtonGroup.add(this.timeRadioButton);
        this.timeRadioButton.setName(WaypointCard.TIME_OPTION);
        this.timeRadioButton.addItemListener(this::fireTimeUsed);
        speedTimeButtonGroup.add(this.speedAccelerationRadioButton);
        this.speedAccelerationRadioButton.setName(WaypointCard.SPEED_AND_ACCELERATION_OPTION);
        this.speedAccelerationRadioButton.addItemListener(this::fireSpeedAndAccelerationUsed);
        this.timeField.setMode(Mode.PositiveNumbers);
        this.timeField.setErrorValidationStrategy(new ValidationStrategy[]{this.validationStrategyProvider.getTimeValidator()});
        this.timeField.setRestrictionsText(resource.maximumNumericValue(TimeUnit.HOURS.toSeconds(6L), Units.getText().unitSeconds()));
        this.speedField.setMode(Mode.PositiveNumbers);
        this.accelerationField.setMode(Mode.PositiveNumbers);
        this.setBorder(BorderFactory.createEmptyBorder());
    }

    @CompoundProgramChange
    void fireUseSharedParameters(ItemEvent evt) {
        ItemEvent itemEvent = evt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)itemEvent);
        Object[] objectArray = new Object[]{this, itemEvent, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure3 advancedPositionOptionsPanel$AjcClosure3 = new AdvancedPositionOptionsPanel$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void fireSpeedAndAccelerationUsed(ItemEvent evt) {
        ItemEvent itemEvent = evt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)itemEvent);
        Object[] objectArray = new Object[]{this, itemEvent, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure5 advancedPositionOptionsPanel$AjcClosure5 = new AdvancedPositionOptionsPanel$AjcClosure5(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void fireTimeUsed(ItemEvent evt) {
        ItemEvent itemEvent = evt;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this), (Object)itemEvent);
        Object[] objectArray = new Object[]{this, itemEvent, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure7 advancedPositionOptionsPanel$AjcClosure7 = new AdvancedPositionOptionsPanel$AjcClosure7(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void accelerationFieldActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure9 advancedPositionOptionsPanel$AjcClosure9 = new AdvancedPositionOptionsPanel$AjcClosure9(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure9.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void speedFieldActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure11 advancedPositionOptionsPanel$AjcClosure11 = new AdvancedPositionOptionsPanel$AjcClosure11(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure11.linkClosureAndJoinPoint(69648));
    }

    @CompoundProgramChange
    void timeFieldActionPerformed() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        AdvancedPositionOptionsPanel$AjcClosure13 advancedPositionOptionsPanel$AjcClosure13 = new AdvancedPositionOptionsPanel$AjcClosure13(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(advancedPositionOptionsPanel$AjcClosure13.linkClosureAndJoinPoint(69648));
    }

    static {
        AdvancedPositionOptionsPanel.ajc$preClinit();
    }

    static final /* synthetic */ void enter_aroundBody0(AdvancedPositionOptionsPanel ajc$this, Object o, JoinPoint joinPoint) {
        super.enter(o);
        if (o instanceof PositionNode) {
            ajc$this.setPositionNode((PositionNode)o);
        }
        ajc$this.updateCard();
    }

    static final /* synthetic */ void fireUseSharedParameters_aroundBody2(AdvancedPositionOptionsPanel ajc$this, ItemEvent evt, JoinPoint joinPoint) {
        if (evt.getStateChange() == 1) {
            ajc$this.positionNode.setUsingSharedParameters();
            UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)ajc$this.positionNode);
            ajc$this.updateCard();
        }
    }

    static final /* synthetic */ void fireSpeedAndAccelerationUsed_aroundBody4(AdvancedPositionOptionsPanel ajc$this, ItemEvent evt, JoinPoint joinPoint) {
        if (evt.getStateChange() == 1) {
            ajc$this.positionNode.setUsingIndividualParameters();
            UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)ajc$this.positionNode);
            ajc$this.updateCard();
        }
    }

    static final /* synthetic */ void fireTimeUsed_aroundBody6(AdvancedPositionOptionsPanel ajc$this, ItemEvent evt, JoinPoint joinPoint) {
        if (evt.getStateChange() == 1) {
            ajc$this.positionNode.setUsingNextMotionTime();
            UpdateExecutionFlowComponent.updateExecutionFlow((AbstractProgramNode)ajc$this.positionNode);
            ajc$this.updateCard();
        }
    }

    static final /* synthetic */ void accelerationFieldActionPerformed_aroundBody8(AdvancedPositionOptionsPanel ajc$this, JoinPoint joinPoint) {
        AccelerationFieldParser.parse((JTextComponent)ajc$this.accelerationField, (AccelerationValueNode)ajc$this.positionNode);
    }

    static final /* synthetic */ void speedFieldActionPerformed_aroundBody10(AdvancedPositionOptionsPanel ajc$this, JoinPoint joinPoint) {
        SpeedFieldParser.parse((JTextComponent)ajc$this.speedField, (SpeedValueNode)ajc$this.positionNode);
    }

    static final /* synthetic */ void timeFieldActionPerformed_aroundBody12(AdvancedPositionOptionsPanel ajc$this, JoinPoint joinPoint) {
        ajc$this.parseTimeValue();
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AdvancedPositionOptionsPanel.java", AdvancedPositionOptionsPanel.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "enter", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "java.lang.Object", "o", "", "void"), 59);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "fireUseSharedParameters", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "java.awt.event.ItemEvent", "evt", "", "void"), 204);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "fireSpeedAndAccelerationUsed", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "java.awt.event.ItemEvent", "evt", "", "void"), 213);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "fireTimeUsed", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "java.awt.event.ItemEvent", "evt", "", "void"), 222);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "accelerationFieldActionPerformed", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "", "", "", "void"), 231);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "speedFieldActionPerformed", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "", "", "", "void"), 236);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("0", "timeFieldActionPerformed", "com.ur.program.waypoint.infrastructure.AdvancedPositionOptionsPanel", "", "", "", "void"), 241);
    }
}

