/*
 * Decompiled with CFR 0.152.
 */
package com.ur.program.waypoint.infrastructure;

import com.ur.monitor.RobotState;
import com.ur.monitor.model.JointPositionVector;
import com.ur.monitor.model.Pose6d;
import com.ur.move.automove.AutoMoveHelper;
import com.ur.polyscope.initializerobot.RobotInitializationService;
import com.ur.polyscope.viewfacade.visualizer.Pose6dTransformUtils;
import com.ur.program.internal.TextResource;
import com.ur.swing.dialog.DialogMessage;
import com.ur.swing.dialog.ErrorMessage;
import com.ur.swing.dialog.MessageDialogType;
import com.ur.swing.dialog.OkDialogListener;
import com.ur.view.constants.dev.RobotMode;
import gui.tools.DialogCreator;
import javax.inject.Inject;
import javax.media.j3d.Transform3D;

public class AutoMoveHelperImpl
implements AutoMoveHelper {
    private final RobotInitializationService initializationRobotDialog;
    private final DialogCreator dialogCreator;
    private final TextResource textResource;

    @Inject
    public AutoMoveHelperImpl(TextResource textResource, RobotInitializationService initializationRobotDialog, DialogCreator dialogCreator) {
        this.textResource = textResource;
        this.initializationRobotDialog = initializationRobotDialog;
        this.dialogCreator = dialogCreator;
    }

    public boolean isReadyToTransitionToAutoMove(final JointPositionVector target) {
        return new Template(this){

            @Override
            public boolean undefined() {
                return target.isUndefined();
            }

            @Override
            public boolean alreadyHere() {
                RobotState latestRobotState = RobotState.getLatestRobotState();
                JointPositionVector currentPosition = new JointPositionVector(latestRobotState.jointPosition);
                return currentPosition.epsilonEquals(target, 0.005);
            }
        }.isReady();
    }

    public boolean isReadyToTransitionToAutoMove(final Transform3D target) {
        return new Template(this){

            @Override
            public boolean undefined() {
                return target == null;
            }

            @Override
            public boolean alreadyHere() {
                Pose6d currentPose = new Pose6d(RobotState.getLatestRobotState().tool);
                Pose6d targetPose = Pose6dTransformUtils.getPose6dEquivalentOfTransform3D((Transform3D)target);
                return Pose6dTransformUtils.aggregatedDistanceTo((Pose6d)currentPose, (Pose6d)targetPose) <= 0.005;
            }
        }.isReady();
    }

    private abstract class Template {
        private Template() {
        }

        public boolean isReady() {
            if (this.undefined()) {
                AutoMoveHelperImpl.this.dialogCreator.showErrorDialog(new ErrorMessage(AutoMoveHelperImpl.this.textResource.undefinedPosition(), AutoMoveHelperImpl.this.textResource.undefinedPosition()), new OkDialogListener());
                return false;
            }
            RobotState latestRobotState = RobotState.getLatestRobotState();
            if (!latestRobotState.robotMode.equals((Object)RobotMode.RUNNING)) {
                AutoMoveHelperImpl.this.initializationRobotDialog.initializeRobot();
                return false;
            }
            if (this.alreadyHere()) {
                AutoMoveHelperImpl.this.dialogCreator.showMessageDialog(new DialogMessage(AutoMoveHelperImpl.this.textResource.robotIsAlreadAtThisPosition(), AutoMoveHelperImpl.this.textResource.robotIsAlreadAtThisPosition()), MessageDialogType.MESSAGE, new OkDialogListener());
                return false;
            }
            return true;
        }

        protected abstract boolean undefined();

        protected abstract boolean alreadyHere();
    }
}

